/*
 * Decompiled with CFR 0.152.
 */
package io.rong.common;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import io.rong.common.RLog;
import io.rong.common.fwlog.FwLog;
import io.rong.imlib.HeartbeatReceiver;

public class WakeLockUtils {
    private static final String TAG = WakeLockUtils.class.getSimpleName();
    private static final long DEF_HEARTBEAT_TIMER = 150000L;
    private static final int HEARTBEAT_TIMER_MIN = 10000;
    private static long interval;
    private static volatile boolean cancelHeartbeat;

    public static void scheduleHeartbeat(@NonNull Context context) {
        RLog.d(TAG, "startNextHeartbeat " + context.getPackageName() + ", cancelHeartbeat " + cancelHeartbeat);
        if (cancelHeartbeat) {
            return;
        }
        Intent heartbeatIntent = new Intent(context, HeartbeatReceiver.class);
        heartbeatIntent.setPackage(context.getPackageName());
        PendingIntent intent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)heartbeatIntent, (int)0);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        if (alarmManager == null) {
            RLog.e(TAG, "alarmManager is null");
            return;
        }
        Resources resources = context.getResources();
        if (interval <= 0L) {
            try {
                String config_time = resources.getString(resources.getIdentifier("rc_heartbeat_timer", "string", context.getPackageName()));
                interval = Long.parseLong(config_time);
            }
            catch (Exception e) {
                interval = 150000L;
                RLog.e(TAG, "Read config file exception. Use default heartbeat time value.");
            }
            if (interval < 10000L) {
                interval = 10000L;
            }
        }
        long triggerTime = SystemClock.elapsedRealtime() + interval;
        alarmManager.cancel(intent);
        FwLog.write(3, 1, FwLog.LogTag.L_PING_S.getTag(), "interval|enabled", interval, true);
        if (Build.VERSION.SDK_INT < 19) {
            alarmManager.set(2, triggerTime, intent);
        } else {
            alarmManager.setExact(2, triggerTime, intent);
        }
    }

    public static void cancelHeartbeat(@NonNull Context context) {
        FwLog.write(3, 1, FwLog.LogTag.L_PING_S.getTag(), "interval|enabled", interval, false);
        RLog.d(TAG, "cancelHeartbeat " + context.getPackageName());
        Intent heartbeatIntent = new Intent(context, HeartbeatReceiver.class);
        heartbeatIntent.setPackage(context.getPackageName());
        PendingIntent intent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)heartbeatIntent, (int)0);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        if (alarmManager != null) {
            alarmManager.cancel(intent);
        }
    }

    public static void cancelSDKHeartBeat(@NonNull Context context) {
        RLog.d(TAG, "cancelSDKHeartBeat ");
        cancelHeartbeat = true;
        ComponentName componentName = new ComponentName(context, HeartbeatReceiver.class);
        context.getPackageManager().setComponentEnabledSetting(componentName, 2, 1);
    }

    static {
        cancelHeartbeat = false;
    }
}

