/*
 * Decompiled with CFR 0.152.
 */
package io.rong.common;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import io.rong.common.fwlog.FwLog;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SystemUtils {
    private static String currentProcessName;

    public static String getCurrentProcessName(Context context) {
        if (context == null) {
            return currentProcessName;
        }
        String packageName = context.getPackageName();
        if (!TextUtils.isEmpty((CharSequence)currentProcessName)) {
            SystemUtils.writeFwlog(packageName);
            return currentProcessName;
        }
        currentProcessName = SystemUtils.getCurrentProcessNameByApplication();
        if (!TextUtils.isEmpty((CharSequence)currentProcessName)) {
            SystemUtils.writeFwlog(packageName);
            return currentProcessName;
        }
        currentProcessName = SystemUtils.getCurrentProcessNameByActivityThread();
        if (!TextUtils.isEmpty((CharSequence)currentProcessName)) {
            SystemUtils.writeFwlog(packageName);
            return currentProcessName;
        }
        currentProcessName = SystemUtils.getCurrentProcessNameByActivityManager(context);
        if (!TextUtils.isEmpty((CharSequence)currentProcessName)) {
            SystemUtils.writeFwlog(packageName);
        }
        return currentProcessName;
    }

    private static void writeFwlog(String packageName) {
        if (!currentProcessName.equals(packageName)) {
            FwLog.write(2, 1, FwLog.LogTag.L_INIT_S.getTag(), "packageName|currentProcessName", packageName, currentProcessName);
        }
    }

    private static String getCurrentProcessNameByApplication() {
        if (Build.VERSION.SDK_INT >= 28) {
            return Application.getProcessName();
        }
        return null;
    }

    private static String getCurrentProcessNameByActivityThread() {
        String processName = null;
        try {
            Method declaredMethod = Class.forName("android.app.ActivityThread", false, Application.class.getClassLoader()).getDeclaredMethod("currentProcessName", new Class[0]);
            declaredMethod.setAccessible(true);
            Object invoke = declaredMethod.invoke(null, new Object[0]);
            if (invoke instanceof String) {
                processName = (String)invoke;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return processName;
    }

    private static String getCurrentProcessNameByActivityManager(Context context) {
        List runningAppList;
        if (context == null) {
            return null;
        }
        int pid = Process.myPid();
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        if (am != null && (runningAppList = am.getRunningAppProcesses()) != null) {
            for (ActivityManager.RunningAppProcessInfo processInfo : runningAppList) {
                if (processInfo.pid != pid) continue;
                return processInfo.processName;
            }
        }
        return null;
    }

    public static boolean isValidAppKey(String appKey) {
        Pattern p = Pattern.compile("^[a-z0-9A-Z]+$");
        Matcher m = p.matcher(appKey);
        return m.find();
    }

    public static URL getLegalServer(String server, boolean containPort) {
        if (TextUtils.isEmpty((CharSequence)server)) {
            return null;
        }
        String backUp = server;
        if (server.startsWith("http")) {
            backUp = server.replace("http://", "").replace("https://", "");
        } else {
            server = "http://" + server;
        }
        URL retUrl = null;
        try {
            boolean legalhost;
            URL url = new URL(server);
            if (containPort) {
                legalhost = url.getHost() != null && url.getPort() >= 0 && (url.getHost() + ":" + url.getPort()).equals(backUp);
            } else {
                boolean bl = legalhost = url.getHost() != null && url.getHost().equals(backUp);
            }
            if (legalhost) {
                retUrl = url;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return retUrl;
    }

    public static boolean isLegalServer(String server) {
        return SystemUtils.getLegalServer(server, true) != null || SystemUtils.getLegalServer(server, false) != null;
    }

    public static String listToString(List<String> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String cmp : list) {
            sb.append(cmp);
            sb.append(",");
        }
        String str = sb.toString();
        return str.substring(0, str.length() - 1);
    }
}

