/*
 * Decompiled with CFR 0.152.
 */
package io.rong.common;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.imlib.R;
import io.rong.imlib.common.SavePathUtils;
import java.io.File;

public class LibStorageUtils {
    private static final String TAG = "LibStorageUtils";
    public static final String DIR = "RongCloud";
    public static final String VIDEO = "video";
    public static final String IMAGE = "image";
    public static final String FILE = "file";
    public static final String AUDIO = "audio";
    public static final String MEDIA = "media";
    private static Boolean isQMode = null;
    private static Boolean isBuildAndTargetForQ = null;

    public static boolean isQMode(Context context) {
        if (isQMode == null) {
            try {
                isQMode = context.getResources().getBoolean(R.bool.rc_q_storage_mode_enable);
            }
            catch (Resources.NotFoundException pE) {
                RLog.e(TAG, "isQMode rc_q_storage_mode_enable not found");
                isQMode = false;
            }
        }
        if (LibStorageUtils.isBuildAndTargetForQ(context) && !isQMode.booleanValue()) {
            RLog.e(TAG, "\u8bf7 rc_configuration \u8bbe\u7f6e rc_q_storage_mode_enable \u4e3a true ");
        }
        return isQMode;
    }

    public static boolean isBuildAndTargetForQ(Context context) {
        if (isBuildAndTargetForQ == null) {
            isBuildAndTargetForQ = Build.VERSION.SDK_INT >= 29 && context.getApplicationInfo().targetSdkVersion >= 29;
        }
        return isBuildAndTargetForQ;
    }

    public static String getMediaDownloadDir(Context context) {
        return LibStorageUtils.getMediaDownloadDir(context, MEDIA);
    }

    public static String getMediaDownloadDir(Context context, String dir) {
        if (!SavePathUtils.isSavePathEmpty()) {
            String savePath = SavePathUtils.getSavePath();
            File imageDir = new File(savePath, MEDIA);
            if (!imageDir.exists() && !imageDir.mkdirs()) {
                RLog.e(TAG, "getSavePath mkdirs error path is  " + imageDir.getAbsolutePath());
            }
            return imageDir.getAbsolutePath();
        }
        boolean sdCardExist = Environment.getExternalStorageState().equals("mounted");
        String result = context.getCacheDir().getPath();
        if (!sdCardExist) {
            RLog.d(TAG, "getSavePath error, sdcard does not exist.");
            return result;
        }
        if (LibStorageUtils.isQMode(context)) {
            File externalFilesDir = context.getExternalFilesDir(DIR);
            File file = new File(externalFilesDir, dir);
            result = !file.exists() && !file.mkdirs() ? externalFilesDir.getPath() : file.getPath();
        } else {
            String path = Environment.getExternalStorageDirectory().getPath();
            String filePath = context.getString(R.string.rc_media_message_default_save_path);
            File file = new File(path = path + filePath);
            if (!file.exists() && !file.mkdirs()) {
                RLog.e(TAG, "mkdirs error path is  " + path);
                result = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getPath();
            } else {
                result = path;
            }
        }
        return result;
    }

    public static String getAppName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            int labelRes = packageInfo.applicationInfo.labelRes;
            if (labelRes > 0) {
                return context.getResources().getString(labelRes);
            }
            CharSequence nonLocalizedLabel = packageInfo.applicationInfo.nonLocalizedLabel;
            if (TextUtils.isEmpty((CharSequence)nonLocalizedLabel)) {
                return null;
            }
            return nonLocalizedLabel.toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            RLog.e(TAG, "getAppName", e);
        }
        catch (Exception e) {
            RLog.e(TAG, "getAppName", e);
        }
        return null;
    }
}

