/*
 * Decompiled with CFR 0.152.
 */
package io.rong.common;

import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.imlib.model.MessageExpansion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONUtils {
    private static final String TAG = "JSONUtils";

    public static HashMap<String, MessageExpansion> jsonToExpansionEx(String originJson) {
        HashMap<String, MessageExpansion> hashMap = new HashMap<String, MessageExpansion>();
        if (TextUtils.isEmpty((CharSequence)originJson)) {
            return hashMap;
        }
        try {
            JSONObject innerObject = new JSONObject(originJson);
            Iterator it = innerObject.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object value = innerObject.get(key);
                JSONObject jsonObjectValue = new JSONObject(value.toString());
                String messageExpansionKey = jsonObjectValue.optString("v");
                long messageExpansionValue = jsonObjectValue.optLong("ts");
                MessageExpansion messageExpansion = new MessageExpansion(messageExpansionKey, messageExpansionValue);
                hashMap.put(key, messageExpansion);
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, "jsonToExpansionEx " + e.toString());
        }
        return hashMap;
    }

    public static HashMap<String, String> expansionExToMap(Map<String, MessageExpansion> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (map == null || map.size() == 0) {
            return null;
        }
        Iterator<Map.Entry<String, MessageExpansion>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, MessageExpansion> o;
            Map.Entry<String, MessageExpansion> e = o = iterator.next();
            hashMap.put(e.getKey().toString(), e.getValue().getValue());
        }
        return hashMap;
    }

    public static String mapTsCombineJson(Map<String, String> map, long ts) {
        JSONObject outObject = new JSONObject();
        if (map == null || map.size() == 0) {
            return "";
        }
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> o;
            Map.Entry<String, String> e = o = iterator.next();
            JSONObject innerObject = new JSONObject();
            try {
                innerObject.put("v", (Object)e.getValue());
                innerObject.put("ts", ts);
                outObject.put(e.getKey().toString(), (Object)innerObject);
            }
            catch (JSONException ex) {
                RLog.e(TAG, "mapTsCombineJson " + e.toString());
            }
        }
        return outObject.toString();
    }

    public static String exMapToJson(HashMap<String, MessageExpansion> hashMap) {
        if (hashMap == null || hashMap.isEmpty()) {
            return "";
        }
        JSONObject outObject = new JSONObject();
        Iterator<Map.Entry<String, MessageExpansion>> iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, MessageExpansion> o;
            Map.Entry<String, MessageExpansion> e = o = iterator.next();
            try {
                JSONObject innerObject = new JSONObject();
                innerObject.put("v", (Object)e.getValue().getValue());
                innerObject.put("ts", e.getValue().getTs());
                outObject.put(e.getKey().toString(), (Object)innerObject);
            }
            catch (JSONException ex) {
                RLog.e(TAG, "exMapToJson " + ex.toString());
                return "";
            }
        }
        return outObject.toString();
    }

    public static List<Object> removeKeysInExpansionEx(List<String> arrayList, HashMap<String, MessageExpansion> hashMap) {
        ArrayList<Object> list = new ArrayList<Object>();
        ArrayList<String> didRemoveList = new ArrayList<String>();
        if (arrayList == null || arrayList.size() == 0) {
            if (hashMap != null) {
                Set<String> set = hashMap.keySet();
                didRemoveList.addAll(set);
                hashMap.clear();
            }
            list.add(hashMap);
            list.add(didRemoveList);
            return list;
        }
        for (String key : arrayList) {
            if (hashMap == null) break;
            if (hashMap.containsKey(key)) {
                didRemoveList.add(key);
            }
            hashMap.remove(key);
        }
        list.add(hashMap);
        list.add(didRemoveList);
        return list;
    }

    public static List<Object> removeKeysTSInExpansionEx(long time, List<String> arrayList, HashMap<String, MessageExpansion> hashMap) {
        ArrayList<Object> list = new ArrayList<Object>();
        ArrayList<String> didRemoveList = new ArrayList<String>();
        if (arrayList == null || arrayList.size() == 0) {
            if (hashMap != null) {
                Set<String> set = hashMap.keySet();
                for (String key : set) {
                    MessageExpansion messageExpansion = hashMap.get(key);
                    if (messageExpansion == null || time <= messageExpansion.getTs()) continue;
                    hashMap.remove(key);
                    didRemoveList.add(key);
                }
            }
            list.add(hashMap);
            list.add(didRemoveList);
            return list;
        }
        for (String key : arrayList) {
            if (hashMap == null) break;
            MessageExpansion messageExpansion = hashMap.get(key);
            if (messageExpansion == null || time <= messageExpansion.getTs()) continue;
            hashMap.remove(key);
            didRemoveList.add(key);
        }
        list.add(hashMap);
        list.add(didRemoveList);
        return list;
    }

    public static HashMap<String, String> expansionExJSONToMap(String jsonString) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return map;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = jsonObject.get(key);
                JSONObject innerObject = new JSONObject(value.toString());
                value = innerObject.optString("v");
                map.put(key, value.toString());
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, "expansionExJSONToMap " + e.toString());
            return map;
        }
        return map;
    }

    public static String hashMapToJson(Map<String, String> map) {
        JSONObject jsonObject = new JSONObject();
        if (map == null || map.size() == 0) {
            return "";
        }
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> o;
            Map.Entry<String, String> e = o = iterator.next();
            try {
                JSONObject innerObject = new JSONObject();
                innerObject.put("v", (Object)e.getValue());
                jsonObject.put(e.getKey(), (Object)innerObject);
            }
            catch (JSONException ex) {
                ex.printStackTrace();
            }
        }
        return jsonObject.toString();
    }

    public static List<String> mergeJson(String expansionJsonSet, String expansionExisted) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            if (TextUtils.isEmpty((CharSequence)expansionJsonSet)) {
                list.add(expansionExisted);
                list.add("");
                return list;
            }
            if (TextUtils.isEmpty((CharSequence)expansionExisted)) {
                list.add(expansionJsonSet);
                list.add(expansionJsonSet);
                return list;
            }
            JSONObject jsonObjectSet = new JSONObject(expansionJsonSet);
            JSONObject jsonObjectExisted = new JSONObject(expansionExisted);
            JSONObject incrementObj = new JSONObject();
            Iterator iterator = jsonObjectSet.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = jsonObjectSet.get(key);
                if (jsonObjectExisted.has(key)) {
                    long currentTs;
                    Object existValue = jsonObjectExisted.get(key);
                    JSONObject innerSetObj = new JSONObject(value.toString());
                    JSONObject innerExistObj = new JSONObject(existValue.toString());
                    long setTs = innerSetObj.optLong("ts");
                    if (setTs <= (currentTs = innerExistObj.optLong("ts"))) continue;
                    jsonObjectExisted.put(key, value);
                    incrementObj.put(key, value);
                    continue;
                }
                jsonObjectExisted.put(key, value);
                incrementObj.put(key, value);
            }
            list.add(jsonObjectExisted.toString());
            list.add(incrementObj.toString());
            return list;
        }
        catch (JSONException e) {
            RLog.e(TAG, "mergeJson " + e.toString());
            return null;
        }
    }
}

