/*
 * Decompiled with CFR 0.152.
 */
package io.rong.common;

import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import io.rong.common.FileInfo;
import io.rong.common.LibStorageUtils;
import io.rong.common.RLog;
import io.rong.common.SystemUtils;
import io.rong.imlib.NativeClient;
import io.rong.imlib.common.DeviceUtils;
import io.rong.imlib.common.SavePathUtils;
import io.rong.imlib.common.SharedPreferencesUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class FileUtils {
    private static String TAG = "FileUtils";
    public static final int FILE_SCHEME_LENGTH = 7;

    public static InputStream getFileInputStream(String path) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(path));
        }
        catch (FileNotFoundException e) {
            RLog.e(TAG, "getFileInputStream", e);
        }
        return fileInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getByteFromUri(Uri uri) {
        if (uri == null) {
            RLog.e(TAG, "getByteFromUri uri should not be null!");
            return null;
        }
        InputStream input = FileUtils.getFileInputStream(uri.getPath());
        try {
            int count = 0;
            while (count == 0 && (count = input.available()) != 0) {
            }
            byte[] bytes = new byte[count];
            int byteCount = input.read(bytes);
            RLog.i(TAG, "byteCount = " + byteCount);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    RLog.e(TAG, "getByteFromUri", e);
                }
            }
        }
    }

    public static void writeByte(Uri uri, byte[] data) {
        if (uri == null || uri.getPath() == null || uri.getPath().lastIndexOf("/") == -1) {
            return;
        }
        File fileFolder = new File(uri.getPath().substring(0, uri.getPath().lastIndexOf("/")));
        boolean successMkdir = fileFolder.mkdirs();
        if (!successMkdir) {
            RLog.e(TAG, "Created folders unSuccessfully");
        }
        File file = new File(uri.getPath());
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            ((OutputStream)os).write(data);
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            RLog.e(TAG, "writeByte", e);
        }
    }

    public static File convertBitmap2File(Bitmap bm, String dir, String name) {
        File targetFile;
        if (bm == null || TextUtils.isEmpty((CharSequence)dir)) {
            RLog.e(TAG, "convertBitmap2File bm or dir should not be null!");
            return null;
        }
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            RLog.e(TAG, "convertBitmap2File: dir does not exist! -" + dirFile.getAbsolutePath());
            boolean successMkdir = dirFile.mkdirs();
            if (!successMkdir) {
                RLog.e(TAG, "Created folders unSuccessfully");
            }
        }
        if ((targetFile = new File(dirFile.getPath() + File.separator + name)).exists()) {
            boolean isDelete = targetFile.delete();
            RLog.e(TAG, "convertBitmap2File targetFile isDelete:" + isDelete);
        }
        File tmpFile = new File(dirFile.getPath() + File.separator + name + ".tmp");
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile));
            bm.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bos);
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            RLog.e(TAG, "convertBitmap2File: Exception!", e);
        }
        targetFile = new File(dirFile.getPath() + File.separator + name);
        if (tmpFile.renameTo(targetFile)) {
            return targetFile;
        }
        return tmpFile;
    }

    public static File copyFile(File src, String path, String name) {
        if (src == null) {
            RLog.e(TAG, "copyFile src should not be null!");
            return null;
        }
        if (!src.exists()) {
            RLog.e(TAG, "copyFile: src file does not exist! -" + src.getAbsolutePath());
            return null;
        }
        File dest = new File(path);
        if (!dest.exists()) {
            RLog.d(TAG, "copyFile: dir does not exist!");
            boolean successMkdir = dest.mkdirs();
            if (!successMkdir) {
                RLog.e(TAG, "Created folders unSuccessfully");
            }
        }
        dest = new File(path + name);
        try {
            int length;
            FileInputStream fis = new FileInputStream(src);
            FileOutputStream fos = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, length);
            }
            fos.flush();
            fos.close();
            fis.close();
        }
        catch (IOException e) {
            RLog.e(TAG, "copyFile: Exception!", e);
            return dest;
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String srcPath, String path, String name) {
        if (TextUtils.isEmpty((CharSequence)srcPath)) {
            RLog.e(TAG, "copyFile src should not be null!");
            return false;
        }
        File src = new File(srcPath);
        if (!src.exists()) {
            RLog.e(TAG, "copyFile: src file does not exist! -" + src.getAbsolutePath());
            return false;
        }
        File dest = new File(path);
        if (!dest.exists()) {
            RLog.d(TAG, "copyFile: dir does not exist!");
            boolean successMkdir = dest.mkdirs();
            if (!successMkdir) {
                RLog.e(TAG, "Created folders unSuccessfully");
            }
        }
        dest = new File(path, name);
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int length;
            fis = new FileInputStream(src);
            fos = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, length);
            }
            fos.flush();
        }
        catch (IOException e) {
            RLog.e(TAG, "copyFile: Exception!", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                RLog.e(TAG, "copyFile fos close", e);
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                RLog.e(TAG, "copyFile fis close", e);
            }
        }
        return true;
    }

    public static boolean copyFileToInternal(Context context, Uri srcUri, String desPath, String name) {
        if (FileUtils.uriStartWithFile(srcUri)) {
            return FileUtils.copyFile(srcUri.toString(), desPath, name);
        }
        if (FileUtils.uriStartWithContent(srcUri)) {
            return FileUtils.copyFile(context, srcUri, new File(desPath, name).getAbsolutePath());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(Context context, Uri srcUri, String desPath) {
        ParcelFileDescriptor pfd;
        if (!FileUtils.uriStartWithContent(srcUri)) {
            return false;
        }
        try {
            pfd = context.getContentResolver().openFileDescriptor(srcUri, "r");
        }
        catch (FileNotFoundException e) {
            RLog.e(TAG, "copyFile srcUri is error uri is " + srcUri.toString());
            return false;
        }
        if (pfd != null) {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                int length;
                fis = new FileInputStream(pfd.getFileDescriptor());
                fos = new FileOutputStream(desPath);
                byte[] buffer = new byte[1024];
                while ((length = fis.read(buffer)) != -1) {
                    fos.write(buffer, 0, length);
                }
                fos.flush();
            }
            catch (IOException e) {
                RLog.e(TAG, "copyFile: Exception!", e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException pE) {
                        RLog.e(TAG, "copyFile: Exception!", pE);
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException pE) {
                        RLog.e(TAG, "copyFile: Exception!", pE);
                    }
                }
            }
        }
        return true;
    }

    public static String getFileNameWithPath(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            RLog.e(TAG, "getFileNameWithPath path should not be null!");
            return null;
        }
        int start = path.lastIndexOf("/");
        if (start != -1) {
            return path.substring(start + 1);
        }
        return null;
    }

    public static byte[] file2byte(File file) {
        if (file == null) {
            RLog.e(TAG, "file2byte file should not be null!");
            return null;
        }
        if (!file.exists()) {
            RLog.e(TAG, "file2byte: src file does not exist! -" + file.getAbsolutePath());
            return null;
        }
        byte[] buffer = null;
        try {
            int n;
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (Exception e1) {
            RLog.e(TAG, "file2byte: Exception!", e1);
        }
        return buffer;
    }

    public static byte[] file2byte(Context context, Uri uri) {
        if (FileUtils.uriStartWithFile(uri)) {
            String path = uri.toString().substring(7);
            return FileUtils.file2byte(new File(path));
        }
        if (FileUtils.uriStartWithContent(uri)) {
            return FileUtils.contentFile2byte(context, uri);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] contentFile2byte(Context context, Uri uri) {
        ParcelFileDescriptor r;
        if (context == null || uri == null || !FileUtils.uriStartWithContent(uri)) {
            RLog.e(TAG, "contentFile2byte params error");
            return null;
        }
        try {
            r = context.getContentResolver().openFileDescriptor(uri, "r");
        }
        catch (FileNotFoundException e) {
            RLog.e(TAG, "contentFile2byte file not found uri is " + uri.toString());
            return null;
        }
        byte[] buffer = null;
        FileInputStream fis = null;
        try {
            int n;
            fis = new FileInputStream(r.getFileDescriptor());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (Exception e1) {
            RLog.e(TAG, "file2byte: Exception!", e1);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                RLog.e(TAG, "file2byte fis close", e);
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File byte2File(byte[] buf, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists()) {
                RLog.d(TAG, "byte2File: dir does not exist!");
                boolean successMkdir = dir.mkdirs();
                if (!successMkdir) {
                    RLog.e(TAG, "Created folders unSuccessfully");
                }
            }
            file = new File(dir.getPath() + File.separator + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(buf);
        }
        catch (Exception e) {
            RLog.e(TAG, "byte2File: Exception!", e);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    RLog.e(TAG, "byte2File: IOException!", e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    RLog.e(TAG, "byte2File: IOException!", e);
                }
            }
        }
        return file;
    }

    public static String getCachePath(Context context) {
        return FileUtils.getCachePath(context, "");
    }

    private static boolean hasFilePermission(Context context) {
        return context.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }

    public static String getCachePath(Context context, String dir) {
        File tarDir;
        File cacheDir;
        if (!SavePathUtils.isSavePathEmpty()) {
            return SavePathUtils.getSavePath();
        }
        boolean sdCardExist = false;
        try {
            sdCardExist = "mounted".equals(Environment.getExternalStorageState());
        }
        catch (Exception e) {
            RLog.e(TAG, "getCachePath", e);
        }
        if (Build.VERSION.SDK_INT >= 19 || FileUtils.hasFilePermission(context)) {
            try {
                cacheDir = context.getExternalCacheDir();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                RLog.e(TAG, "getCachePath ArrayIndexOutOfBoundsException", e);
                cacheDir = null;
            }
        } else {
            cacheDir = context.getCacheDir();
        }
        if (!sdCardExist || cacheDir == null || !cacheDir.exists() && !cacheDir.mkdirs()) {
            cacheDir = context.getCacheDir();
        }
        if ((tarDir = new File(cacheDir.getPath() + File.separator + dir)).exists() && tarDir.isFile()) {
            boolean isDelete = tarDir.delete();
            RLog.e(TAG, "getCachePath isDelete:" + isDelete);
        }
        if (!tarDir.exists()) {
            boolean result = tarDir.mkdir();
            RLog.w(TAG, "getCachePath = " + tarDir.getPath() + ", result = " + result);
            if (!result) {
                if (Build.VERSION.SDK_INT >= 23 && FileUtils.hasFilePermission(context)) {
                    tarDir = new File("/sdcard/cache/" + dir);
                    if (!tarDir.exists()) {
                        result = tarDir.mkdirs();
                    }
                } else {
                    File filesDir = context.getFilesDir();
                    tarDir = new File(filesDir, dir);
                    if (!tarDir.exists()) {
                        result = tarDir.mkdirs();
                    }
                }
                RLog.e(TAG, "change path = " + tarDir.getPath() + ", result = " + result);
            }
        }
        return tarDir.getPath();
    }

    public static String getCacheDirsPath(Context context, String dir) {
        File tarDir;
        File cacheDir;
        if (!SavePathUtils.isSavePathEmpty()) {
            return SavePathUtils.getSavePath();
        }
        boolean sdCardExist = false;
        try {
            sdCardExist = "mounted".equals(Environment.getExternalStorageState());
        }
        catch (Exception e) {
            RLog.e(TAG, "getCacheDirsPath ", e);
        }
        if (Build.VERSION.SDK_INT >= 19 || FileUtils.hasFilePermission(context)) {
            try {
                cacheDir = context.getExternalCacheDir();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                RLog.e(TAG, "getCacheDirsPath ArrayIndexOutOfBoundsException", e);
                cacheDir = null;
            }
        } else {
            cacheDir = context.getCacheDir();
        }
        if (!sdCardExist || cacheDir == null || !cacheDir.exists() && !cacheDir.mkdirs()) {
            cacheDir = context.getCacheDir();
        }
        if ((tarDir = new File(cacheDir.getPath() + File.separator + dir)).exists()) {
            if (tarDir.isFile()) {
                boolean isDelete = tarDir.delete();
                RLog.e(TAG, "getCacheDirsPath isDelete:" + isDelete);
            }
        } else {
            boolean successMkdir = tarDir.mkdirs();
            if (!successMkdir) {
                RLog.e(TAG, "getCacheDirsPath created folders unSuccessfully");
            }
        }
        if (!tarDir.exists()) {
            boolean result = tarDir.mkdir();
            RLog.w(TAG, "getCachePath = " + tarDir.getPath() + ", result = " + result);
            if (!result) {
                if (Build.VERSION.SDK_INT >= 23 && FileUtils.hasFilePermission(context)) {
                    tarDir = new File("/sdcard/cache/" + dir);
                    if (!tarDir.exists()) {
                        result = tarDir.mkdirs();
                    }
                } else {
                    File filesDir = context.getFilesDir();
                    tarDir = new File(filesDir, dir);
                    if (!tarDir.exists()) {
                        result = tarDir.mkdirs();
                    }
                }
                RLog.e(TAG, "change path = " + tarDir.getPath() + ", result = " + result);
            }
        }
        return tarDir.getPath();
    }

    public static String getTempFilePath(Context context, int messageId) {
        return FileUtils.getTempFilePath(context, messageId + "");
    }

    public static String getTempFilePath(Context context, String id) {
        SharedPreferences sp = SharedPreferencesUtils.get(context, "Statistics", 0);
        String appKey = sp.getString("appKey", "Null");
        String userId = SystemUtils.getCurrentProcessName(context).equals(context.getPackageName()) ? sp.getString("userId", "Null") : NativeClient.getInstance().getCurrentUserId();
        String subDir = "TempFile" + File.separator + appKey + File.separator + userId;
        String path = FileUtils.getCacheDirsPath(context, subDir) + File.separator + id + ".txt";
        return path;
    }

    public static String getInternalCachePath(Context context, String dir) {
        if (!SavePathUtils.isSavePathEmpty()) {
            return SavePathUtils.getSavePath();
        }
        File cacheDir = new File(context.getCacheDir().getPath() + File.separator + dir);
        if (!cacheDir.exists()) {
            boolean result = cacheDir.mkdir();
            RLog.w(TAG, "getInternalCachePath = " + cacheDir.getPath() + ", result = " + result);
        }
        return cacheDir.getPath();
    }

    @Deprecated
    public static String getMediaDownloadDir(Context context) {
        return LibStorageUtils.getMediaDownloadDir(context);
    }

    @Deprecated
    public static String getMediaDownloadDir(Context context, String dir) {
        return LibStorageUtils.getMediaDownloadDir(context, dir);
    }

    public static long getFileSize(File file) {
        long size = 0L;
        try {
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                size = fis.available();
                if (fis != null) {
                    fis.close();
                }
            } else {
                RLog.d(TAG, "file doesn't exist");
            }
        }
        catch (Exception e) {
            RLog.e(TAG, "getFileSize", e);
        }
        return size;
    }

    public static void saveFile(String str, String filePath) {
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                File dir = new File(file.getParent());
                boolean successMkdir = dir.mkdirs();
                if (!successMkdir) {
                    RLog.e(TAG, "Created folders unSuccessfully");
                }
                boolean isCreateNewFile = file.createNewFile();
                RLog.e(TAG, "saveFile isCreateNewFile" + isCreateNewFile);
            }
            FileOutputStream outStream = new FileOutputStream(file);
            outStream.write(str.getBytes());
            outStream.close();
        }
        catch (Exception e) {
            RLog.e(TAG, "saveFile", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromFile(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            RLog.e(TAG, "getStringFromFile path should not be null!");
            return null;
        }
        File file = new File(path);
        if (!file.exists()) {
            RLog.e(TAG, "getStringFromFile file is not exists,path:" + path);
            return "";
        }
        BufferedReader reader = null;
        StringBuilder content = new StringBuilder();
        try {
            String line;
            FileInputStream in = new FileInputStream(path);
            reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
        }
        catch (IOException e) {
            RLog.e(TAG, "getStringFromFile IOException", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    RLog.e(TAG, "getStringFromFile IOException", e);
                }
            }
        }
        return content.toString();
    }

    public static void removeFile(String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                boolean isDelete = file.delete();
                RLog.e(TAG, "removeFile isDelete:" + isDelete);
            }
        }
        catch (Exception e) {
            RLog.e(TAG, "removeFile Exception", e);
        }
    }

    public static String getTempFileMD5(Context context, int messageId) {
        return FileUtils.getTempFileMD5(context, messageId + "");
    }

    public static String getTempFileMD5(Context context, String tag) {
        if (context == null) {
            return null;
        }
        SharedPreferences sp = SharedPreferencesUtils.get(context, "Statistics", 0);
        String appKey = sp.getString("appKey", "Null");
        String userId = SystemUtils.getCurrentProcessName(context).equals(context.getPackageName()) ? sp.getString("userId", "Null") : NativeClient.getInstance().getCurrentUserId();
        String result = DeviceUtils.ShortMD5(0, appKey, userId, tag);
        return result;
    }

    public static int readPictureDegree(Context context, String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = null;
            if (LibStorageUtils.isBuildAndTargetForQ(context)) {
                if (FileUtils.uriStartWithContent(Uri.parse((String)path))) {
                    ParcelFileDescriptor pfd = context.getContentResolver().openFileDescriptor(Uri.parse((String)path), "r");
                    if (pfd != null && Build.VERSION.SDK_INT >= 24) {
                        exifInterface = new ExifInterface(pfd.getFileDescriptor());
                    }
                } else {
                    exifInterface = new ExifInterface(path);
                }
            } else {
                exifInterface = new ExifInterface(path);
            }
            if (exifInterface == null) {
                return 0;
            }
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (Exception e) {
            RLog.e(TAG, "readPictureDegree error");
        }
        return degree;
    }

    public static boolean isFileExistsWithUri(Context pContext, Uri pUri) {
        if (pUri == null) {
            return false;
        }
        if (FileUtils.uriStartWithFile(pUri)) {
            String subPath = pUri.toString().substring(7);
            return new File(subPath).exists();
        }
        if (FileUtils.uriStartWithContent(pUri)) {
            try {
                return pContext.getContentResolver().openFileDescriptor(pUri, "r") != null;
            }
            catch (FileNotFoundException e) {
                return false;
            }
        }
        if (pUri.toString().startsWith("/")) {
            return new File(pUri.toString()).exists();
        }
        return false;
    }

    public static boolean isValidateLocalUri(Uri pUri) {
        return FileUtils.uriStartWithFile(pUri) || FileUtils.uriStartWithContent(pUri);
    }

    public static boolean uriStartWithFile(Uri pUri) {
        return pUri != null && "file".equals(pUri.getScheme()) && pUri.toString().length() > 7;
    }

    public static boolean uriStartWithContent(Uri srcUri) {
        return srcUri != null && "content".equals(srcUri.getScheme());
    }

    public static String getSuffix(Uri srcUri) {
        if (srcUri == null) {
            return null;
        }
        return FileUtils.getSuffix(srcUri.toString());
    }

    public static String getSuffix(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        int lastDot = path.lastIndexOf(".");
        if (lastDot < 0) {
            return null;
        }
        return path.substring(lastDot + 1);
    }

    public static FileInfo getFileInfoByUri(Context context, Uri uri) {
        if (FileUtils.uriStartWithContent(uri)) {
            return FileUtils.getFileInfoByContent(context, uri);
        }
        if (FileUtils.uriStartWithFile(uri)) {
            return FileUtils.getFileInfoByFile(uri);
        }
        return null;
    }

    private static FileInfo getFileInfoByFile(Uri uri) {
        if (FileUtils.uriStartWithFile(uri)) {
            String filePath = uri.toString().substring(7);
            File file = new File(filePath);
            if (file.exists()) {
                FileInfo fileInfo = new FileInfo();
                String name = file.getName();
                fileInfo.setSize(file.length());
                fileInfo.setName(name);
                int lastDotIndex = name.lastIndexOf(".");
                if (lastDotIndex > 0) {
                    String fileSuffix = file.getName().substring(lastDotIndex + 1);
                    fileInfo.setType(fileSuffix);
                }
                return fileInfo;
            }
            return null;
        }
        RLog.e(TAG, "getDocumentByFile uri is not file");
        return null;
    }

    public static FileInfo getFileInfoByFile(File file) {
        if (file != null) {
            if (file.exists()) {
                FileInfo fileInfo = new FileInfo();
                String name = file.getName();
                fileInfo.setSize(file.length());
                fileInfo.setName(name);
                int lastDotIndex = name.lastIndexOf(".");
                if (lastDotIndex > 0) {
                    String fileSuffix = file.getName().substring(lastDotIndex + 1);
                    fileInfo.setType(fileSuffix);
                }
                return fileInfo;
            }
            RLog.e(TAG, "getFileInfoByFile file is not exist");
            return null;
        }
        RLog.e(TAG, "getFileInfoByFile file is null");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileInfo getFileInfoByContent(Context context, Uri uri) {
        block15: {
            if (FileUtils.uriStartWithContent(uri)) {
                String[] projection = new String[]{"_display_name", "_size", "mime_type"};
                try (Cursor cursor = null;){
                    FileInfo fileInfo = new FileInfo();
                    cursor = context.getContentResolver().query(uri, projection, null, null, null);
                    if (cursor == null) {
                        RLog.e(TAG, "getFileInfoByContent cursor is null");
                        FileInfo fileInfo2 = null;
                        return fileInfo2;
                    }
                    if (cursor.moveToFirst()) {
                        String name = cursor.getString(0);
                        long size = cursor.getLong(1);
                        fileInfo.setName(name);
                        fileInfo.setSize(size);
                        if (!TextUtils.isEmpty((CharSequence)name)) {
                            int lastDotIndex = name.lastIndexOf(".");
                            if (lastDotIndex > 0) {
                                String fileSuffix = name.substring(lastDotIndex + 1);
                                fileInfo.setType(fileSuffix);
                            }
                        } else {
                            RLog.e(TAG, "getFileInfoByContent getName is empty");
                            FileInfo fileInfo3 = null;
                            return fileInfo3;
                        }
                        if (cursor.moveToNext()) {
                            RLog.e(TAG, "uri is error,cursor has second value,uri is" + uri);
                        }
                        FileInfo fileInfo4 = fileInfo;
                        return fileInfo4;
                    }
                    break block15;
                }
            }
            RLog.e(TAG, "getDocumentByContent uri is not content");
            return null;
        }
        return null;
    }
}

