/*
 * Decompiled with CFR 0.152.
 */
package io.rong.common;

import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import java.util.Map;
import java.util.Set;

public class ExpansionUtils {
    private static final String TAG = "ExpansionUtils";
    private static final int EXPANSION_SINGLE_MAX_COUNT = 20;

    public static RongIMClient.ErrorCode filterSendMessage(Message message) {
        Map<String, String> expansion = message.getExpansion();
        if (message.isCanIncludeExpansion()) {
            if (message.getConversationType() != Conversation.ConversationType.PRIVATE && message.getConversationType() != Conversation.ConversationType.GROUP) {
                RLog.e(TAG, "filterSendMessage : only private or group support expansion!");
                return RongIMClient.ErrorCode.RC_MESSAGE_CANT_EXPAND;
            }
            if (ExpansionUtils.judgeKVExceedLimit(expansion) || ExpansionUtils.judgeExpansionExceedLimitSingleMsg(expansion)) {
                RLog.e(TAG, "filterSendMessage : key exceeds 32 bytes or value exceeds 64 bytes !");
                return RongIMClient.ErrorCode.RC_MSG_EXPANSION_SIZE_LIMIT_EXCEED;
            }
            if (ExpansionUtils.judgeKVIllegality(expansion)) {
                RLog.e(TAG, "filterSendMessage : key contains illegal characters!");
                return RongIMClient.ErrorCode.PARAMETER_ERROR;
            }
        } else if (expansion != null && expansion.size() > 0) {
            RLog.e(TAG, "filterSendMessage : isCanIncludeExpansion is false, but expansion is not null!");
            return RongIMClient.ErrorCode.RC_MESSAGE_CANT_EXPAND;
        }
        return null;
    }

    public static boolean judgeKVExceedLimit(Map<String, String> expansionDic) {
        if (expansionDic == null) {
            return false;
        }
        Set<Map.Entry<String, String>> setEntry = expansionDic.entrySet();
        for (Map.Entry<String, String> mapEntry : setEntry) {
            String key = mapEntry.getKey();
            String value = mapEntry.getValue();
            if ((TextUtils.isEmpty((CharSequence)key) || key.length() <= 32) && (TextUtils.isEmpty((CharSequence)value) || value.length() <= 64)) continue;
            RLog.e(TAG, "key exceeds 32 bytes or value exceeds 64 bytes !");
            return true;
        }
        return false;
    }

    public static boolean judgeKVIllegality(Map<String, String> expansionDic) {
        if (expansionDic == null) {
            return false;
        }
        Set<Map.Entry<String, String>> setEntry = expansionDic.entrySet();
        for (Map.Entry<String, String> mapEntry : setEntry) {
            String key = mapEntry.getKey();
            if (key.matches("^[A-Za-z0-9+_=-]+$")) continue;
            RLog.e(TAG, "key contains illegal characters!");
            return true;
        }
        return false;
    }

    private static boolean judgeExpansionExceedLimitSingleMsg(Map<String, String> expansion) {
        if (expansion == null) {
            return false;
        }
        return expansion.size() > 20;
    }
}

