/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import io.rong.common.RLog;
import io.rong.eventbus.EventBus;
import io.rong.imkit.R;
import io.rong.imkit.destruct.DestructManager;
import io.rong.imkit.manager.AudioPlayManager;
import io.rong.imkit.manager.AudioRecordManager;
import io.rong.imkit.manager.IAudioPlayListener;
import io.rong.imkit.model.Event;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Message;
import io.rong.message.VoiceMessage;
import java.lang.ref.WeakReference;

@ProviderTag(messageContent=VoiceMessage.class, showReadState=true)
public class VoiceMessageItemProvider
extends IContainerItemProvider.MessageProvider<VoiceMessage> {
    private static final String TAG = "VoiceMessageItemProvider";

    public VoiceMessageItemProvider(Context context) {
    }

    @Override
    public View newView(Context context, ViewGroup group) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_item_voice_message, null);
        ViewHolder holder = new ViewHolder();
        holder.left = (TextView)view.findViewById(R.id.rc_left);
        holder.right = (TextView)view.findViewById(R.id.rc_right);
        holder.img = (ImageView)view.findViewById(R.id.rc_img);
        holder.unread = (ImageView)view.findViewById(R.id.rc_voice_unread);
        holder.sendFire = (FrameLayout)view.findViewById(R.id.fl_send_fire);
        holder.receiverFire = (FrameLayout)view.findViewById(R.id.fl_receiver_fire);
        holder.receiverFireImg = (ImageView)view.findViewById(R.id.iv_receiver_fire);
        holder.receiverFireText = (TextView)view.findViewById(R.id.tv_receiver_fire);
        view.setTag((Object)holder);
        return view;
    }

    @Override
    public void bindView(View v, int position, VoiceMessage content, UIMessage message) {
        Uri playingUri;
        ViewHolder holder = (ViewHolder)v.getTag();
        holder.receiverFire.setTag((Object)message.getUId());
        if (content.isDestruct()) {
            if (message.getMessageDirection() == Message.MessageDirection.SEND) {
                holder.sendFire.setVisibility(0);
                holder.receiverFire.setVisibility(8);
            } else {
                holder.sendFire.setVisibility(8);
                holder.receiverFire.setVisibility(0);
                DestructManager.getInstance().addListener(message.getUId(), new DestructListener(holder, message), TAG);
                if (message.getMessage().getReadTime() > 0L) {
                    holder.receiverFireText.setVisibility(0);
                    holder.receiverFireImg.setVisibility(8);
                    String unFinishTime = TextUtils.isEmpty((CharSequence)message.getUnDestructTime()) ? DestructManager.getInstance().getUnFinishTime(message.getUId()) : message.getUnDestructTime();
                    holder.receiverFireText.setText((CharSequence)unFinishTime);
                    DestructManager.getInstance().startDestruct(message.getMessage());
                } else {
                    holder.receiverFireText.setVisibility(8);
                    holder.receiverFireImg.setVisibility(0);
                }
            }
        } else {
            holder.sendFire.setVisibility(8);
            holder.receiverFire.setVisibility(8);
        }
        if (message.continuePlayAudio) {
            playingUri = AudioPlayManager.getInstance().getPlayingUri();
            if (playingUri == null || !playingUri.equals((Object)content.getUri())) {
                boolean listened = message.getMessage().getReceivedStatus().isListened();
                AudioPlayManager.getInstance().startPlay(v.getContext(), content.getUri(), new VoiceMessagePlayListener(v.getContext(), message, holder, listened));
            }
        } else {
            playingUri = AudioPlayManager.getInstance().getPlayingUri();
            if (playingUri != null && playingUri.equals((Object)content.getUri())) {
                this.setLayout(v.getContext(), holder, message, true);
                boolean listened = message.getMessage().getReceivedStatus().isListened();
                AudioPlayManager.getInstance().setPlayListener(new VoiceMessagePlayListener(v.getContext(), message, holder, listened));
            } else {
                this.setLayout(v.getContext(), holder, message, false);
            }
        }
    }

    @Override
    public void onItemClick(View view, int position, VoiceMessage content, UIMessage message) {
        RLog.d((String)TAG, (String)("Item index:" + position));
        if (content == null) {
            return;
        }
        ViewHolder holder = (ViewHolder)view.getTag();
        if (AudioPlayManager.getInstance().isPlaying()) {
            if (AudioPlayManager.getInstance().getPlayingUri().equals((Object)content.getUri())) {
                AudioPlayManager.getInstance().stopPlay();
                return;
            }
            AudioPlayManager.getInstance().stopPlay();
        }
        if (!AudioPlayManager.getInstance().isInNormalMode(view.getContext()) && AudioPlayManager.getInstance().isInVOIPMode(view.getContext())) {
            Toast.makeText((Context)view.getContext(), (CharSequence)view.getContext().getString(R.string.rc_voip_occupying), (int)0).show();
            return;
        }
        holder.unread.setVisibility(8);
        boolean listened = message.getMessage().getReceivedStatus().isListened();
        AudioPlayManager.getInstance().startPlay(view.getContext(), content.getUri(), new VoiceMessagePlayListener(view.getContext(), message, holder, listened));
    }

    private void setLayout(Context context, ViewHolder holder, UIMessage message, boolean playing) {
        VoiceMessage content = (VoiceMessage)message.getContent();
        int minWidth = 70;
        int maxWidth = 204;
        float scale = context.getResources().getDisplayMetrics().density;
        minWidth = (int)((float)minWidth * scale + 0.5f);
        maxWidth = (int)((float)maxWidth * scale + 0.5f);
        int duration = AudioRecordManager.getInstance().getMaxVoiceDuration();
        holder.img.getLayoutParams().width = minWidth + (maxWidth - minWidth) / duration * content.getDuration();
        if (message.getMessageDirection() == Message.MessageDirection.SEND) {
            holder.left.setText((CharSequence)String.format("%s\"", content.getDuration()));
            holder.left.setVisibility(0);
            holder.right.setVisibility(8);
            holder.unread.setVisibility(8);
            holder.img.setScaleType(ImageView.ScaleType.FIT_END);
            holder.img.setBackgroundResource(R.drawable.rc_ic_bubble_right);
            AnimationDrawable animationDrawable = (AnimationDrawable)context.getResources().getDrawable(R.drawable.rc_an_voice_sent);
            if (playing) {
                holder.img.setImageDrawable((Drawable)animationDrawable);
                if (animationDrawable != null) {
                    animationDrawable.start();
                }
            } else {
                holder.img.setImageDrawable(holder.img.getResources().getDrawable(R.drawable.rc_ic_voice_sent));
                if (animationDrawable != null) {
                    animationDrawable.stop();
                }
            }
        } else {
            holder.right.setText((CharSequence)String.format("%s\"", content.getDuration()));
            holder.right.setVisibility(0);
            holder.left.setVisibility(8);
            if (!message.getReceivedStatus().isListened()) {
                holder.unread.setVisibility(0);
            } else {
                holder.unread.setVisibility(8);
            }
            holder.img.setBackgroundResource(R.drawable.rc_ic_bubble_left);
            AnimationDrawable animationDrawable = (AnimationDrawable)context.getResources().getDrawable(R.drawable.rc_an_voice_receive);
            if (playing) {
                holder.img.setImageDrawable((Drawable)animationDrawable);
                if (animationDrawable != null) {
                    animationDrawable.start();
                }
            } else {
                holder.img.setImageDrawable(holder.img.getResources().getDrawable(R.drawable.rc_ic_voice_receive));
                if (animationDrawable != null) {
                    animationDrawable.stop();
                }
            }
            holder.img.setScaleType(ImageView.ScaleType.FIT_START);
        }
    }

    @Override
    public Spannable getContentSummary(VoiceMessage data) {
        return null;
    }

    @Override
    public Spannable getContentSummary(Context context, VoiceMessage data) {
        if (data.isDestruct()) {
            return new SpannableString((CharSequence)context.getString(R.string.rc_message_content_burn));
        }
        return new SpannableString((CharSequence)context.getString(R.string.rc_message_content_voice));
    }

    @TargetApi(value=8)
    private boolean muteAudioFocus(Context context, boolean bMute) {
        int result;
        if (context == null) {
            RLog.d((String)TAG, (String)"muteAudioFocus context is null.");
            return false;
        }
        if (Build.VERSION.SDK_INT < 8) {
            RLog.d((String)TAG, (String)"muteAudioFocus Android 2.1 and below can not stop music");
            return false;
        }
        boolean bool2 = false;
        AudioManager am = (AudioManager)context.getSystemService("audio");
        bool2 = bMute ? (result = am.requestAudioFocus(null, 3, 2)) == 1 : (result = am.abandonAudioFocus(null)) == 1;
        RLog.d((String)TAG, (String)("muteAudioFocus pauseMusic bMute=" + bMute + " result=" + bool2));
        return bool2;
    }

    private static class DestructListener
    implements RongIMClient.DestructCountDownTimerListener {
        private WeakReference<ViewHolder> mHolder;
        private UIMessage mUIMessage;

        public DestructListener(ViewHolder pHolder, UIMessage pUIMessage) {
            this.mHolder = new WeakReference<ViewHolder>(pHolder);
            this.mUIMessage = pUIMessage;
        }

        public void onTick(long millisUntilFinished, String messageId) {
            ViewHolder viewHolder;
            if (this.mUIMessage.getUId().equals(messageId) && (viewHolder = (ViewHolder)this.mHolder.get()) != null && messageId.equals(viewHolder.receiverFire.getTag())) {
                viewHolder.receiverFireText.setVisibility(0);
                viewHolder.receiverFireImg.setVisibility(8);
                String unDestructTime = String.valueOf(Math.max(millisUntilFinished, 1L));
                viewHolder.receiverFireText.setText((CharSequence)unDestructTime);
                this.mUIMessage.setUnDestructTime(unDestructTime);
            }
        }

        public void onStop(String messageId) {
            ViewHolder viewHolder;
            if (this.mUIMessage.getUId().equals(messageId) && (viewHolder = (ViewHolder)this.mHolder.get()) != null && messageId.equals(viewHolder.receiverFire.getTag())) {
                viewHolder.receiverFireText.setVisibility(8);
                viewHolder.receiverFireImg.setVisibility(0);
                this.mUIMessage.setUnDestructTime(null);
            }
        }
    }

    private class VoiceMessagePlayListener
    implements IAudioPlayListener {
        private Context context;
        private UIMessage message;
        private ViewHolder holder;
        private boolean listened;

        public VoiceMessagePlayListener(Context context, UIMessage message, ViewHolder holder, boolean listened) {
            this.context = context;
            this.message = message;
            this.holder = holder;
            this.listened = listened;
        }

        @Override
        public void onStart(Uri uri) {
            this.message.continuePlayAudio = false;
            this.message.setListening(true);
            this.message.getReceivedStatus().setListened();
            RongIMClient.getInstance().setMessageReceivedStatus(this.message.getMessageId(), this.message.getReceivedStatus(), null);
            VoiceMessageItemProvider.this.setLayout(this.context, this.holder, this.message, true);
            EventBus.getDefault().post(new Event.AudioListenedEvent(this.message.getMessage()));
            if (this.message.getContent().isDestruct() && this.message.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                DestructManager.getInstance().stopDestruct(this.message.getMessage());
            }
        }

        @Override
        public void onStop(Uri uri) {
            if (this.message.getContent() instanceof VoiceMessage) {
                this.message.setListening(false);
                VoiceMessageItemProvider.this.setLayout(this.context, this.holder, this.message, false);
                if (this.message.getContent().isDestruct() && this.message.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                    DestructManager.getInstance().startDestruct(this.message.getMessage());
                }
            }
        }

        @Override
        public void onComplete(Uri uri) {
            Event.PlayAudioEvent event = Event.PlayAudioEvent.obtain();
            event.messageId = this.message.getMessageId();
            if (this.message.isListening() && this.message.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                try {
                    event.continuously = this.context.getResources().getBoolean(R.bool.rc_play_audio_continuous);
                }
                catch (Resources.NotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (event.continuously && !this.message.getContent().isDestruct()) {
                EventBus.getDefault().post(event);
            }
            this.message.setListening(false);
            VoiceMessageItemProvider.this.setLayout(this.context, this.holder, this.message, false);
            if (this.message.getContent().isDestruct() && this.message.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                DestructManager.getInstance().startDestruct(this.message.getMessage());
            }
        }
    }

    private static class ViewHolder {
        ImageView img;
        TextView left;
        TextView right;
        ImageView unread;
        FrameLayout sendFire;
        FrameLayout receiverFire;
        ImageView receiverFireImg;
        TextView receiverFireText;

        private ViewHolder() {
        }
    }
}

