/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import android.content.Intent;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.destruct.DestructManager;
import io.rong.imkit.emoticon.AndroidEmoji;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.utils.TextViewUtils;
import io.rong.imkit.widget.ILinkClickListener;
import io.rong.imkit.widget.LinkTextViewMovementMethod;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Message;
import io.rong.message.TextMessage;
import java.lang.ref.WeakReference;

@ProviderTag(messageContent=TextMessage.class, showReadState=true)
public class TextMessageItemProvider
extends IContainerItemProvider.MessageProvider<TextMessage> {
    private static final String TAG = "TextMessageItemProvider";
    private static final int TAG_MESSAGE_ID = -1;

    @Override
    public View newView(Context context, ViewGroup group) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_item_destruct_text_message, null);
        ViewHolder holder = new ViewHolder();
        holder.message = (TextView)view.findViewById(16908308);
        holder.unRead = (TextView)view.findViewById(R.id.tv_unread);
        holder.sendFire = (FrameLayout)view.findViewById(R.id.fl_send_fire);
        holder.receiverFire = (FrameLayout)view.findViewById(R.id.fl_receiver_fire);
        holder.receiverFireImg = (ImageView)view.findViewById(R.id.iv_receiver_fire);
        holder.receiverFireText = (TextView)view.findViewById(R.id.tv_receiver_fire);
        view.setTag((Object)holder);
        return view;
    }

    @Override
    public Spannable getContentSummary(TextMessage data) {
        return null;
    }

    @Override
    public Spannable getContentSummary(Context context, TextMessage data) {
        if (data == null) {
            return null;
        }
        if (data.isDestruct()) {
            return new SpannableString((CharSequence)context.getString(R.string.rc_message_content_burn));
        }
        String content = data.getContent();
        if (content != null) {
            if (content.length() > 100) {
                content = content.substring(0, 100);
            }
            return new SpannableString(AndroidEmoji.ensure(content));
        }
        return null;
    }

    @Override
    public void onItemClick(View view, int position, TextMessage content, UIMessage message) {
        ViewHolder holder = (ViewHolder)view.getTag();
        if (content != null && content.isDestruct() && message.getMessage().getReadTime() <= 0L) {
            holder.unRead.setVisibility(8);
            holder.message.setVisibility(0);
            holder.receiverFireText.setVisibility(0);
            holder.receiverFireImg.setVisibility(8);
            this.processTextView(view, position, content, message, holder.message);
            DestructManager.getInstance().startDestruct(message.getMessage());
        }
    }

    @Override
    public void bindView(View v, int position, TextMessage content, UIMessage data) {
        ViewHolder holder = (ViewHolder)v.getTag();
        holder.receiverFire.setTag((Object)data.getUId());
        if (data.getMessageDirection() == Message.MessageDirection.SEND) {
            holder.message.setBackgroundResource(R.drawable.rc_ic_bubble_right);
        } else {
            holder.message.setBackgroundResource(R.drawable.rc_ic_bubble_left);
        }
        if (content.isDestruct()) {
            this.bindFireView(v, position, content, data);
        } else {
            holder.sendFire.setVisibility(8);
            holder.receiverFire.setVisibility(8);
            holder.unRead.setVisibility(8);
            holder.message.setVisibility(0);
            TextView textView = holder.message;
            this.processTextView(v, position, content, data, textView);
        }
    }

    private void processTextView(final View v, int position, TextMessage content, final UIMessage data, final TextView pTextView) {
        pTextView.setTag((Object)data.getMessageId());
        if (data.getContentSpannable() == null) {
            SpannableStringBuilder spannable = TextViewUtils.getSpannable(content.getContent(), new TextViewUtils.RegularCallBack(){

                @Override
                public void finish(final SpannableStringBuilder spannable) {
                    pTextView.post(new Runnable(){

                        @Override
                        public void run() {
                            data.setContentSpannable(spannable);
                            if (pTextView.getTag().equals(data.getMessageId())) {
                                pTextView.setText((CharSequence)data.getContentSpannable());
                            }
                        }
                    });
                }
            });
            data.setContentSpannable(spannable);
        }
        pTextView.setText((CharSequence)data.getContentSpannable());
        pTextView.setMovementMethod((MovementMethod)new LinkTextViewMovementMethod(new ILinkClickListener(){

            @Override
            public boolean onLinkClick(String link) {
                String str;
                RongIM.ConversationBehaviorListener listener = RongContext.getInstance().getConversationBehaviorListener();
                RongIM.ConversationClickListener clickListener = RongContext.getInstance().getConversationClickListener();
                boolean result = false;
                if (listener != null) {
                    result = listener.onMessageLinkClick(v.getContext(), link);
                } else if (clickListener != null) {
                    result = clickListener.onMessageLinkClick(v.getContext(), link, data.getMessage());
                }
                if ((listener == null && clickListener == null || !result) && ((str = link.toLowerCase()).startsWith("http") || str.startsWith("https"))) {
                    Intent intent = new Intent("io.rong.imkit.intent.action.webview");
                    intent.setPackage(v.getContext().getPackageName());
                    intent.putExtra("url", link);
                    v.getContext().startActivity(intent);
                    result = true;
                }
                return result;
            }
        }));
        pTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                v.performClick();
            }
        });
        pTextView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return v.performLongClick();
            }
        });
    }

    private void bindFireView(View pV, int pPosition, TextMessage pContent, UIMessage pData) {
        ViewHolder holder = (ViewHolder)pV.getTag();
        if (pData.getMessageDirection() == Message.MessageDirection.SEND) {
            holder.sendFire.setVisibility(0);
            holder.receiverFire.setVisibility(8);
            holder.unRead.setVisibility(8);
            holder.message.setVisibility(0);
            this.processTextView(pV, pPosition, pContent, pData, holder.message);
        } else {
            holder.sendFire.setVisibility(8);
            holder.receiverFire.setVisibility(0);
            DestructManager.getInstance().addListener(pData.getUId(), new DestructListener(holder, pData), TAG);
            if (pData.getMessage().getReadTime() > 0L) {
                holder.unRead.setVisibility(8);
                holder.message.setVisibility(0);
                holder.receiverFireText.setVisibility(0);
                String unFinishTime = TextUtils.isEmpty((CharSequence)pData.getUnDestructTime()) ? DestructManager.getInstance().getUnFinishTime(pData.getUId()) : pData.getUnDestructTime();
                holder.receiverFireText.setText((CharSequence)unFinishTime);
                holder.receiverFireImg.setVisibility(8);
                this.processTextView(pV, pPosition, pContent, pData, holder.message);
                DestructManager.getInstance().startDestruct(pData.getMessage());
            } else {
                holder.unRead.setVisibility(0);
                holder.message.setVisibility(8);
                holder.receiverFireText.setVisibility(8);
                holder.receiverFireImg.setVisibility(0);
            }
        }
    }

    private static class DestructListener
    implements RongIMClient.DestructCountDownTimerListener {
        private WeakReference<ViewHolder> mHolder;
        private UIMessage mUIMessage;

        public DestructListener(ViewHolder pHolder, UIMessage pUIMessage) {
            this.mHolder = new WeakReference<ViewHolder>(pHolder);
            this.mUIMessage = pUIMessage;
        }

        public void onTick(long millisUntilFinished, String messageId) {
            ViewHolder viewHolder;
            if (this.mUIMessage.getUId().equals(messageId) && (viewHolder = (ViewHolder)this.mHolder.get()) != null && messageId.equals(viewHolder.receiverFire.getTag())) {
                viewHolder.receiverFireText.setVisibility(0);
                viewHolder.receiverFireImg.setVisibility(8);
                String unDestructTime = String.valueOf(Math.max(millisUntilFinished, 1L));
                viewHolder.receiverFireText.setText((CharSequence)unDestructTime);
                this.mUIMessage.setUnDestructTime(unDestructTime);
            }
        }

        public void onStop(String messageId) {
            ViewHolder viewHolder;
            if (this.mUIMessage.getUId().equals(messageId) && (viewHolder = (ViewHolder)this.mHolder.get()) != null && messageId.equals(viewHolder.receiverFire.getTag())) {
                viewHolder.receiverFireText.setVisibility(8);
                viewHolder.receiverFireImg.setVisibility(0);
                this.mUIMessage.setUnDestructTime(null);
            }
        }

        public void setHolder(ViewHolder pHolder) {
            this.mHolder = new WeakReference<ViewHolder>(pHolder);
        }

        public void setUIMessage(UIMessage pUIMessage) {
            this.mUIMessage = pUIMessage;
        }
    }

    private static class ViewHolder {
        TextView message;
        TextView unRead;
        FrameLayout sendFire;
        FrameLayout receiverFire;
        ImageView receiverFireImg;
        TextView receiverFireText;

        private ViewHolder() {
        }
    }
}

