/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.support.v4.content.FileProvider;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.message.utils.BitmapUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class TakingPicturesActivity
extends Activity
implements View.OnClickListener {
    private static final String TAG = "TakingPicturesActivity";
    private static final int REQUEST_CAMERA = 2;
    private static int COMPRESSED_SIZE = 1080;
    private ImageView mImage;
    private Uri mSavedPicUri;

    protected void onCreate(Bundle savedInstanceState) {
        this.requestWindowFeature(1);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.rc_ac_camera);
        Button cancel = (Button)this.findViewById(R.id.rc_back);
        Button send = (Button)this.findViewById(R.id.rc_send);
        this.mImage = (ImageView)this.findViewById(R.id.rc_img);
        cancel.setOnClickListener((View.OnClickListener)this);
        send.setOnClickListener((View.OnClickListener)this);
        RLog.d((String)TAG, (String)("onCreate savedInstanceState : " + savedInstanceState));
        try {
            Resources resources = this.getApplicationContext().getResources();
            COMPRESSED_SIZE = resources.getInteger(resources.getIdentifier("rc_image_size", "integer", this.getApplicationContext().getPackageName()));
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)"onCreate", (Throwable)e);
        }
        if (savedInstanceState == null) {
            this.startCamera();
        } else {
            String str = savedInstanceState.getString("photo_uri");
            if (str != null) {
                this.mSavedPicUri = Uri.parse((String)str);
                try {
                    this.mImage.setImageBitmap(BitmapUtil.getNewResizedBitmap((Context)this, (Uri)this.mSavedPicUri, (int)COMPRESSED_SIZE));
                }
                catch (IOException e) {
                    RLog.e((String)TAG, (String)"onCreate", (Throwable)e);
                }
            }
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    public void onClick(View v) {
        File file = new File(this.mSavedPicUri.getPath());
        if (!file.exists()) {
            this.finish();
        }
        if (v.getId() == R.id.rc_send) {
            if (this.mSavedPicUri != null) {
                Intent data = new Intent();
                data.setData(this.mSavedPicUri);
                this.setResult(-1, data);
            }
            this.finish();
        } else if (v.getId() == R.id.rc_back) {
            this.finish();
        }
    }

    private void startCamera() {
        Uri uri;
        File path = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        if (!path.exists()) {
            path.mkdirs();
        }
        String name = System.currentTimeMillis() + ".jpg";
        File file = new File(path, name);
        this.mSavedPicUri = Uri.fromFile((File)file);
        RLog.d((String)TAG, (String)("startCamera output pic uri =" + this.mSavedPicUri));
        Intent intent = new Intent();
        intent.setAction("android.media.action.IMAGE_CAPTURE");
        List resInfoList = this.getPackageManager().queryIntentActivities(intent, 65536);
        try {
            uri = FileProvider.getUriForFile((Context)this, (String)(this.getPackageName() + this.getString(R.string.rc_authorities_fileprovider)), (File)file);
        }
        catch (Exception e) {
            throw new RuntimeException("Please check IMKit Manifest FileProvider config.");
        }
        for (ResolveInfo resolveInfo : resInfoList) {
            String packageName = resolveInfo.activityInfo.packageName;
            this.grantUriPermission(packageName, uri, 2);
            this.grantUriPermission(packageName, uri, 1);
        }
        intent.putExtra("output", (Parcelable)uri);
        intent.addCategory("android.intent.category.DEFAULT");
        try {
            this.startActivityForResult(intent, 2);
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)"REQUEST_CAMERA SecurityException!!!");
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        RLog.d((String)TAG, (String)("onActivityResult resultCode = " + resultCode + ", intent=" + data));
        if (resultCode != -1) {
            this.finish();
            return;
        }
        if (requestCode == 2) {
            if (this.mSavedPicUri != null) {
                try {
                    this.mImage.setImageBitmap(BitmapUtil.getNewResizedBitmap((Context)this, (Uri)this.mSavedPicUri, (int)1080));
                }
                catch (IOException e) {
                    RLog.e((String)TAG, (String)"onActivityResult", (Throwable)e);
                }
            }
        } else {
            return;
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        Log.e((String)TAG, (String)"onRestoreInstanceState");
        this.mSavedPicUri = Uri.parse((String)savedInstanceState.getString("photo_uri"));
        super.onRestoreInstanceState(savedInstanceState);
    }

    public void onSaveInstanceState(Bundle outState) {
        Log.e((String)TAG, (String)"onSaveInstanceState");
        outState.putString("photo_uri", this.mSavedPicUri.toString());
        super.onSaveInstanceState(outState);
    }
}

