/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Parcelable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import io.rong.imkit.R;
import io.rong.imkit.RongIM;
import io.rong.imkit.destruct.DestructManager;
import io.rong.imkit.manager.SendMediaManager;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.resend.ResendManager;
import io.rong.imkit.utilities.OptionsPopupDialog;
import io.rong.imkit.utilities.PermissionCheckUtil;
import io.rong.imkit.utilities.RongUtils;
import io.rong.imkit.utils.RongOperationPermissionUtils;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imkit.widget.CircleProgressView;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Message;
import io.rong.message.SightMessage;
import java.io.File;
import java.lang.ref.WeakReference;

@ProviderTag(messageContent=SightMessage.class, showProgress=false, showReadState=true)
public class SightMessageItemProvider
extends IContainerItemProvider.MessageProvider<SightMessage> {
    private static final String TAG = "Sight-SightMessageItemProvider";

    @Override
    public View newView(Context context, ViewGroup group) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_item_sight_message, null);
        ViewHolder holder = new ViewHolder();
        holder.operationButton = (RelativeLayout)view.findViewById(R.id.rc_sight_operation);
        holder.operationIcon = (ImageView)view.findViewById(R.id.rc_sight_operation_icon);
        holder.message = (FrameLayout)view.findViewById(R.id.rc_message);
        holder.compressProgress = (ProgressBar)view.findViewById(R.id.compressVideoBar);
        holder.loadingProgress = (CircleProgressView)view.findViewById(R.id.rc_sight_progress);
        holder.thumbImg = (AsyncImageView)view.findViewById(R.id.rc_sight_thumb);
        holder.tagImg = (ImageView)view.findViewById(R.id.rc_sight_tag);
        holder.duration = (TextView)view.findViewById(R.id.rc_sight_duration);
        holder.fireView = (FrameLayout)view.findViewById(R.id.rc_destruct_click);
        holder.sendFire = (FrameLayout)view.findViewById(R.id.fl_send_fire);
        holder.receiverFire = (FrameLayout)view.findViewById(R.id.fl_receiver_fire);
        holder.receiverFireImg = (ImageView)view.findViewById(R.id.iv_receiver_fire);
        holder.receiverFireText = (TextView)view.findViewById(R.id.tv_receiver_fire);
        holder.clickHint = (TextView)view.findViewById(R.id.rc_destruct_click_hint);
        view.setTag((Object)holder);
        return view;
    }

    @Override
    public void onItemClick(View view, int position, SightMessage content, UIMessage uiMessage) {
        if (content != null) {
            if (!RongOperationPermissionUtils.isMediaOperationPermit(view.getContext())) {
                return;
            }
            String[] permissions = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
            if (!PermissionCheckUtil.checkPermissions(view.getContext(), permissions)) {
                Activity activity = (Activity)view.getContext();
                PermissionCheckUtil.requestPermissions(activity, permissions, 100);
                return;
            }
            Uri.Builder builder = new Uri.Builder();
            builder.scheme("rong").authority(view.getContext().getPackageName()).appendPath("sight").appendPath("player");
            String intentUrl = builder.build().toString();
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)intentUrl));
            intent.setPackage(view.getContext().getPackageName());
            intent.putExtra("SightMessage", (Parcelable)content);
            intent.putExtra("Message", (Parcelable)uiMessage.getMessage());
            intent.putExtra("Progress", uiMessage.getProgress());
            if (intent.resolveActivity(view.getContext().getPackageManager()) != null) {
                view.getContext().startActivity(intent);
            } else {
                Toast.makeText((Context)view.getContext(), (CharSequence)"Sight Module does not exist.", (int)0).show();
            }
        }
    }

    @Override
    public void bindView(View v, int position, SightMessage content, UIMessage message) {
        int padding;
        ViewHolder holder = (ViewHolder)v.getTag();
        holder.receiverFire.setTag((Object)message.getUId());
        if (message.getMessageDirection() == Message.MessageDirection.SEND) {
            holder.message.setBackgroundResource(R.drawable.rc_ic_bubble_no_right);
            padding = (int)v.getContext().getResources().getDimension(R.dimen.rc_dimen_size_12);
            holder.duration.setPadding(0, 0, padding, 0);
        } else {
            holder.message.setBackgroundResource(R.drawable.rc_ic_bubble_no_left);
            padding = (int)v.getContext().getResources().getDimension(R.dimen.rc_dimen_size_6);
            holder.duration.setPadding(0, 0, padding, 0);
        }
        int progress = message.getProgress();
        Message.SentStatus status = message.getSentStatus();
        if (content.isDestruct()) {
            holder.fireView.setVisibility(0);
            holder.thumbImg.setVisibility(8);
            if (message.getMessageDirection() == Message.MessageDirection.SEND) {
                holder.sendFire.setVisibility(0);
                holder.receiverFire.setVisibility(8);
                holder.fireView.setBackgroundResource(R.drawable.rc_ic_bubble_no_right);
                Drawable drawable2 = v.getContext().getResources().getDrawable(R.drawable.rc_destruct_video_play);
                drawable2.setBounds(0, 0, RongUtils.dip2px(22.0f), RongUtils.dip2px(22.0f));
                holder.clickHint.setCompoundDrawables(null, drawable2, null, null);
                holder.clickHint.setTextColor(Color.parseColor((String)"#FFFFFF"));
                holder.duration.setTextColor(Color.parseColor((String)"#FFFFFF"));
            } else {
                holder.sendFire.setVisibility(8);
                holder.receiverFire.setVisibility(0);
                holder.fireView.setBackgroundResource(R.drawable.rc_ic_bubble_no_left);
                Drawable drawable3 = v.getContext().getResources().getDrawable(R.drawable.rc_icon_fire_video_play);
                drawable3.setBounds(0, 0, RongUtils.dip2px(22.0f), RongUtils.dip2px(22.0f));
                holder.clickHint.setCompoundDrawables(null, drawable3, null, null);
                holder.clickHint.setTextColor(Color.parseColor((String)"#F4B50B"));
                holder.duration.setTextColor(Color.parseColor((String)"#F4B50B"));
                DestructManager.getInstance().addListener(message.getUId(), new DestructListener(holder, message), TAG);
                if (message.getMessage().getReadTime() > 0L) {
                    holder.receiverFireText.setVisibility(0);
                    holder.receiverFireImg.setVisibility(8);
                    String unFinishTime = TextUtils.isEmpty((CharSequence)message.getUnDestructTime()) ? DestructManager.getInstance().getUnFinishTime(message.getUId()) : message.getUnDestructTime();
                    holder.receiverFireText.setText((CharSequence)unFinishTime);
                    DestructManager.getInstance().startDestruct(message.getMessage());
                } else {
                    holder.receiverFireText.setVisibility(8);
                    holder.receiverFireImg.setVisibility(0);
                }
            }
        } else {
            holder.sendFire.setVisibility(8);
            holder.receiverFire.setVisibility(8);
            holder.fireView.setVisibility(8);
            holder.thumbImg.setVisibility(0);
            holder.thumbImg.setResource(content.getThumbUri());
            holder.duration.setTextColor(Color.parseColor((String)"#FFFFFF"));
        }
        holder.duration.setText((CharSequence)this.getSightDuration(content.getDuration()));
        if (progress > 0 && progress < 100) {
            holder.loadingProgress.setProgress(progress, true);
            holder.tagImg.setVisibility(8);
            holder.loadingProgress.setVisibility(0);
            holder.compressProgress.setVisibility(8);
        } else if (status.equals((Object)Message.SentStatus.SENDING)) {
            holder.tagImg.setVisibility(8);
            holder.loadingProgress.setVisibility(8);
            holder.compressProgress.setVisibility(0);
        } else if (status.equals((Object)Message.SentStatus.FAILED) && ResendManager.getInstance().needResend(message.getMessageId())) {
            holder.tagImg.setVisibility(8);
            holder.loadingProgress.setVisibility(8);
            holder.compressProgress.setVisibility(0);
        } else {
            holder.tagImg.setVisibility(0);
            holder.loadingProgress.setVisibility(8);
            holder.compressProgress.setVisibility(8);
        }
    }

    @Override
    public Spannable getContentSummary(SightMessage data) {
        return null;
    }

    @Override
    public Spannable getContentSummary(Context context, SightMessage data) {
        if (data.isDestruct()) {
            return new SpannableString((CharSequence)context.getString(R.string.rc_message_content_burn));
        }
        return new SpannableString((CharSequence)context.getResources().getString(R.string.rc_message_content_sight));
    }

    @Override
    public void onItemLongClick(View view, int position, SightMessage content, final UIMessage message) {
        if (message.getMessage().getSentStatus().getValue() < Message.SentStatus.SENT.getValue()) {
            String[] items = new String[]{view.getContext().getResources().getString(R.string.rc_dialog_item_message_delete)};
            OptionsPopupDialog.newInstance(view.getContext(), items).setOptionsPopupDialogListener(new OptionsPopupDialog.OnOptionsItemClickedListener(){

                @Override
                public void onOptionsItemClicked(int which) {
                    if (which == 0) {
                        SendMediaManager.getInstance().cancelSendingMedia(message.getConversationType(), message.getTargetId(), message.getMessageId());
                        RongIM.getInstance().cancelSendMediaMessage(message.getMessage(), null);
                        RongIM.getInstance().deleteMessages(new int[]{message.getMessageId()}, null);
                    }
                }
            }).show();
        } else {
            super.onItemLongClick(view, position, content, message);
        }
    }

    private boolean isSightDownloaded(SightMessage sightMessage) {
        if (sightMessage.getLocalPath() != null && !TextUtils.isEmpty((CharSequence)sightMessage.getLocalPath().toString())) {
            String path = sightMessage.getLocalPath().toString();
            if (path.startsWith("file://")) {
                path = path.substring(7);
            }
            File file = new File(path);
            return file.exists();
        }
        return false;
    }

    private void handleSendingView(final UIMessage message, final ViewHolder holder) {
        final Message.SentStatus status = message.getSentStatus();
        if (status.equals((Object)Message.SentStatus.SENDING)) {
            holder.operationButton.setVisibility(0);
            holder.operationIcon.setImageResource(R.drawable.rc_file_icon_cancel);
        } else if (status.equals((Object)Message.SentStatus.CANCELED)) {
            holder.operationButton.setVisibility(0);
            holder.operationIcon.setImageResource(R.drawable.rc_ic_warning);
        } else {
            holder.operationButton.setVisibility(8);
        }
        holder.operationButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (status.equals((Object)Message.SentStatus.SENDING)) {
                    RongIM.getInstance().cancelSendMediaMessage(message.getMessage(), new RongIMClient.OperationCallback(){

                        public void onSuccess() {
                            holder.operationButton.setVisibility(0);
                            holder.operationIcon.setImageResource(R.drawable.rc_ic_warning);
                            holder.tagImg.setVisibility(0);
                            holder.loadingProgress.setVisibility(8);
                            holder.compressProgress.setVisibility(8);
                        }

                        public void onError(RongIMClient.ErrorCode errorCode) {
                        }
                    });
                } else if (message.getSentStatus().equals((Object)Message.SentStatus.CANCELED)) {
                    RongIM.getInstance().deleteMessages(new int[]{message.getMessageId()}, new RongIMClient.ResultCallback<Boolean>(){

                        public void onSuccess(Boolean aBoolean) {
                            if (aBoolean.booleanValue()) {
                                message.getMessage().setMessageId(0);
                                RongIM.getInstance().sendMediaMessage(message.getMessage(), null, null, (IRongCallback.ISendMediaMessageCallback)null);
                            }
                        }

                        public void onError(RongIMClient.ErrorCode e) {
                        }
                    });
                }
            }
        });
    }

    private String getSightDuration(int time) {
        String recordTime;
        if (time <= 0) {
            return "00:00";
        }
        int minute = time / 60;
        if (minute < 60) {
            int second = time % 60;
            recordTime = this.unitFormat(minute) + ":" + this.unitFormat(second);
        } else {
            int hour = minute / 60;
            if (hour > 99) {
                return "99:59:59";
            }
            int second = time - hour * 3600 - (minute %= 60) * 60;
            recordTime = this.unitFormat(hour) + ":" + this.unitFormat(minute) + ":" + this.unitFormat(second);
        }
        return recordTime;
    }

    private String unitFormat(int time) {
        String formatTime = time >= 0 && time < 10 ? "0" + time : "" + time;
        return formatTime;
    }

    private static class DestructListener
    implements RongIMClient.DestructCountDownTimerListener {
        private WeakReference<ViewHolder> mHolder;
        private UIMessage mUIMessage;

        public DestructListener(ViewHolder pHolder, UIMessage pUIMessage) {
            this.mHolder = new WeakReference<ViewHolder>(pHolder);
            this.mUIMessage = pUIMessage;
        }

        public void onTick(long millisUntilFinished, String messageId) {
            ViewHolder viewHolder;
            if (this.mUIMessage.getUId().equals(messageId) && (viewHolder = (ViewHolder)this.mHolder.get()) != null && messageId.equals(viewHolder.receiverFire.getTag())) {
                viewHolder.receiverFireText.setVisibility(0);
                viewHolder.receiverFireImg.setVisibility(8);
                String unDestructTime = String.valueOf(Math.max(millisUntilFinished, 1L));
                viewHolder.receiverFireText.setText((CharSequence)unDestructTime);
                this.mUIMessage.setUnDestructTime(unDestructTime);
            }
        }

        public void onStop(String messageId) {
            ViewHolder viewHolder;
            if (this.mUIMessage.getUId().equals(messageId) && (viewHolder = (ViewHolder)this.mHolder.get()) != null && messageId.equals(viewHolder.receiverFire.getTag())) {
                viewHolder.receiverFireText.setVisibility(8);
                viewHolder.receiverFireImg.setVisibility(0);
                this.mUIMessage.setUnDestructTime(null);
            }
        }
    }

    private static class ViewHolder {
        RelativeLayout operationButton;
        ImageView operationIcon;
        FrameLayout message;
        AsyncImageView thumbImg;
        ImageView tagImg;
        ProgressBar compressProgress;
        CircleProgressView loadingProgress;
        TextView duration;
        FrameLayout fireView;
        FrameLayout sendFire;
        FrameLayout receiverFire;
        ImageView receiverFireImg;
        TextView receiverFireText;
        TextView clickHint;

        private ViewHolder() {
        }
    }
}

