/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.rong.common.RLog;
import io.rong.eventbus.EventBus;
import io.rong.imkit.R;
import io.rong.imkit.RongIM;
import io.rong.imkit.model.Event;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.recallEdit.RecallEditCountDownCallBack;
import io.rong.imkit.recallEdit.RecallEditManager;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.model.UserInfo;
import io.rong.message.RecallNotificationMessage;
import java.lang.ref.WeakReference;

@ProviderTag(messageContent=RecallNotificationMessage.class, showPortrait=false, showProgress=false, showWarning=false, centerInHorizontal=true, showSummaryWithName=false)
public class RecallMessageItemProvider
extends IContainerItemProvider.MessageProvider<RecallNotificationMessage> {
    public static final String TAG = RecallMessageItemProvider.class.getSimpleName();

    @Override
    public void onItemClick(View view, int position, RecallNotificationMessage content, UIMessage message) {
    }

    @Override
    public void bindView(View v, int position, RecallNotificationMessage content, final UIMessage message) {
        Object tag = v.getTag();
        if (tag instanceof ViewHolder && content != null) {
            ViewHolder viewHolder = (ViewHolder)tag;
            viewHolder.contentTextView.setText((CharSequence)this.getInformation(content));
            long validTime = v.getContext().getResources().getInteger(R.integer.rc_message_recall_edit_interval);
            long countDownTime = System.currentTimeMillis() - content.getRecallActionTime();
            if (!TextUtils.isEmpty((CharSequence)viewHolder.messageId)) {
                RecallEditManager.getInstance().cancelCountDown(viewHolder.messageId);
            }
            viewHolder.messageId = String.valueOf(message.getMessageId());
            if (content.getRecallActionTime() > 0L && countDownTime < validTime * 1000L) {
                viewHolder.editTextView.setVisibility(0);
                RecallEditManager.getInstance().startCountDown(message.getMessage(), validTime * 1000L - countDownTime, new RecallEditCountDownListener(viewHolder));
                viewHolder.editTextView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        EventBus.getDefault().post(new Event.RecallMessageEditClickEvent(message.getMessage()));
                    }
                });
            } else {
                viewHolder.editTextView.setVisibility(8);
            }
        }
    }

    @Override
    public void onItemLongClick(View view, int position, RecallNotificationMessage content, UIMessage message) {
    }

    @Override
    public Spannable getContentSummary(RecallNotificationMessage data) {
        return null;
    }

    @Override
    public Spannable getContentSummary(Context context, RecallNotificationMessage data) {
        if (data != null) {
            return new SpannableString((CharSequence)this.getInformation(data));
        }
        return null;
    }

    @Override
    public View newView(Context context, ViewGroup group) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_item_information_notification_message, null);
        ViewHolder viewHolder = new ViewHolder();
        viewHolder.contentTextView = (TextView)view.findViewById(R.id.rc_msg);
        viewHolder.contentTextView.setMovementMethod(LinkMovementMethod.getInstance());
        viewHolder.editTextView = (TextView)view.findViewById(R.id.rc_edit);
        view.setTag((Object)viewHolder);
        return view;
    }

    private String getInformation(RecallNotificationMessage content) {
        String information;
        String operatorId = content.getOperatorId();
        if (TextUtils.isEmpty((CharSequence)operatorId)) {
            RLog.e((String)TAG, (String)"RecallMessageItemProvider bindView - operatorId is empty");
            information = RongIM.getInstance().getApplicationContext().getString(R.string.rc_recalled_a_message);
        } else {
            UserInfo userInfo;
            information = content.isAdmin() ? RongIM.getInstance().getApplicationContext().getString(R.string.rc_admin_recalled_message) : (operatorId.equals(RongIM.getInstance().getCurrentUserId()) ? RongIM.getInstance().getApplicationContext().getString(R.string.rc_you_recalled_a_message) : ((userInfo = RongUserInfoManager.getInstance().getUserInfo(operatorId)) != null && userInfo.getName() != null ? userInfo.getName() + RongIM.getInstance().getApplicationContext().getString(R.string.rc_recalled_a_message) : operatorId + RongIM.getInstance().getApplicationContext().getString(R.string.rc_recalled_a_message)));
        }
        return information;
    }

    private static class RecallEditCountDownListener
    implements RecallEditCountDownCallBack {
        private WeakReference<ViewHolder> mHolder;

        public RecallEditCountDownListener(ViewHolder holder) {
            this.mHolder = new WeakReference<ViewHolder>(holder);
        }

        @Override
        public void onFinish(String messageId) {
            ViewHolder viewHolder = (ViewHolder)this.mHolder.get();
            if (viewHolder != null && messageId.equals(viewHolder.messageId)) {
                viewHolder.editTextView.setVisibility(8);
            }
        }
    }

    private static class ViewHolder {
        TextView contentTextView;
        TextView editTextView;
        String messageId;

        private ViewHolder() {
        }
    }
}

