/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import io.rong.imkit.model.UIMessage;

public class MessageItemLongClickAction {
    private String title;
    private int titleResId;
    public int priority;
    public MessageItemLongClickListener listener;
    public Filter filter;

    private MessageItemLongClickAction(int titleResId, String title, MessageItemLongClickListener listener, Filter filter) {
        this.titleResId = titleResId;
        this.title = title;
        this.listener = listener;
        this.filter = filter;
    }

    public String getTitle(Context context) {
        if (context != null && this.titleResId > 0) {
            return context.getResources().getString(this.titleResId);
        }
        return this.title;
    }

    public boolean filter(UIMessage message) {
        return this.filter == null || this.filter.filter(message);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageItemLongClickAction that = (MessageItemLongClickAction)o;
        if (this.titleResId != that.titleResId) {
            return false;
        }
        return this.title != null ? this.title.equals(that.title) : that.title == null;
    }

    public int hashCode() {
        int result = this.title != null ? this.title.hashCode() : 0;
        result = 31 * result + this.titleResId;
        return result;
    }

    public static interface Filter {
        public boolean filter(UIMessage var1);
    }

    public static interface MessageItemLongClickListener {
        public boolean onMessageItemLongClick(Context var1, UIMessage var2);
    }

    public static class Builder {
        private String title;
        private int titleResId;
        private MessageItemLongClickListener listener;
        private Filter filter;
        private int priority;

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder titleResId(int resId) {
            this.titleResId = resId;
            return this;
        }

        public Builder actionListener(MessageItemLongClickListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder showFilter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public MessageItemLongClickAction build() {
            MessageItemLongClickAction action = new MessageItemLongClickAction(this.titleResId, this.title, this.listener, this.filter);
            action.priority = this.priority;
            return action;
        }
    }
}

