/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.text.Spannable;
import android.text.SpannableString;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.plugin.location.AMapPreviewActivity;
import io.rong.imkit.plugin.location.AMapPreviewActivity2D;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.model.Message;
import io.rong.message.LocationMessage;

@ProviderTag(messageContent=LocationMessage.class, showReadState=true)
public class LocationMessageItemProvider
extends IContainerItemProvider.MessageProvider<LocationMessage> {
    private static final String TAG = "LocationMessageItemProvider";

    @Override
    public View newView(Context context, ViewGroup group) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_item_location_message, null);
        ViewHolder holder = new ViewHolder();
        holder.img = (AsyncImageView)view.findViewById(R.id.rc_img);
        holder.title = (TextView)view.findViewById(R.id.rc_content);
        holder.mLayout = (FrameLayout)view.findViewById(R.id.rc_layout);
        view.setTag((Object)holder);
        return view;
    }

    @Override
    public void onItemClick(View view, int position, LocationMessage content, UIMessage message) {
        try {
            String clsName = "com.amap.api.netlocation.AMapNetworkLocationClient";
            Class<?> locationCls = Class.forName(clsName);
            Intent intent = view.getContext().getResources().getBoolean(R.bool.rc_location_2D) ? new Intent(view.getContext(), AMapPreviewActivity2D.class) : new Intent(view.getContext(), AMapPreviewActivity.class);
            intent.putExtra("location", (Parcelable)message.getContent());
            intent.setFlags(0x10000000);
            view.getContext().startActivity(intent);
        }
        catch (Exception e) {
            RLog.i((String)TAG, (String)"Not default AMap Location");
            RLog.e((String)TAG, (String)"onItemClick", (Throwable)e);
        }
    }

    @Override
    public void bindView(View v, int position, LocationMessage content, UIMessage uiMsg) {
        ViewHolder holder = (ViewHolder)v.getTag();
        Uri uri = content.getImgUri();
        RLog.d((String)TAG, (String)("uri = " + uri));
        if (uri == null || !"file".equals(uri.getScheme())) {
            holder.img.setDefaultDrawable();
        } else {
            holder.img.setResource(uri);
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(holder.title.getLayoutParams().width, -2);
        params.gravity = 80;
        if (uiMsg.getMessageDirection() == Message.MessageDirection.SEND) {
            holder.mLayout.setBackgroundResource(R.drawable.rc_ic_bubble_no_right);
            params.leftMargin = 0;
            params.rightMargin = (int)(3.5 * (double)v.getResources().getDisplayMetrics().density);
            holder.title.setLayoutParams((ViewGroup.LayoutParams)params);
        } else {
            params.leftMargin = (int)(6.0f * v.getResources().getDisplayMetrics().density);
            params.rightMargin = 0;
            holder.title.setLayoutParams((ViewGroup.LayoutParams)params);
            holder.mLayout.setBackgroundResource(R.drawable.rc_ic_bubble_no_left);
        }
        holder.title.setText((CharSequence)content.getPoi());
    }

    @Override
    public Spannable getContentSummary(LocationMessage data) {
        return null;
    }

    @Override
    public Spannable getContentSummary(Context context, LocationMessage data) {
        String text = context.getResources().getString(R.string.rc_message_content_location);
        return new SpannableString((CharSequence)text);
    }

    private static class ViewHolder {
        AsyncImageView img;
        TextView title;
        FrameLayout mLayout;

        private ViewHolder() {
        }
    }
}

