/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import io.rong.imkit.R;
import io.rong.imkit.destruct.DestructManager;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.resend.ResendManager;
import io.rong.imkit.utilities.RongUtils;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Message;
import io.rong.message.ImageMessage;
import java.lang.ref.WeakReference;

@ProviderTag(messageContent=ImageMessage.class, showProgress=false, showReadState=true)
public class ImageMessageItemProvider
extends IContainerItemProvider.MessageProvider<ImageMessage> {
    private static final String TAG = "ImageMessageItemProvider";

    @Override
    public View newView(Context context, ViewGroup group) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_item_image_message, null);
        ViewHolder holder = new ViewHolder();
        holder.message = (TextView)view.findViewById(R.id.rc_msg);
        holder.img = (AsyncImageView)view.findViewById(R.id.rc_img);
        holder.fireView = (FrameLayout)view.findViewById(R.id.rc_destruct_click);
        holder.sendFire = (FrameLayout)view.findViewById(R.id.fl_send_fire);
        holder.receiverFire = (FrameLayout)view.findViewById(R.id.fl_receiver_fire);
        holder.receiverFireImg = (ImageView)view.findViewById(R.id.iv_receiver_fire);
        holder.receiverFireText = (TextView)view.findViewById(R.id.tv_receiver_fire);
        holder.clickHint = (TextView)view.findViewById(R.id.rc_destruct_click_hint);
        view.setTag((Object)holder);
        return view;
    }

    @Override
    public void onItemClick(View view, int position, ImageMessage content, UIMessage message) {
        if (content != null) {
            Intent intent = new Intent("io.rong.imkit.intent.action.picturepagerview");
            intent.setPackage(view.getContext().getPackageName());
            intent.putExtra("message", (Parcelable)message.getMessage());
            view.getContext().startActivity(intent);
        }
    }

    @Override
    public void bindView(View v, int position, ImageMessage content, UIMessage message) {
        ViewHolder holder = (ViewHolder)v.getTag();
        holder.receiverFire.setTag((Object)message.getUId());
        if (content.isDestruct()) {
            this.bindFireView(v, position, content, message);
            return;
        }
        if (message.getMessageDirection() == Message.MessageDirection.SEND) {
            v.setBackgroundResource(R.drawable.rc_ic_bubble_no_right);
        } else {
            v.setBackgroundResource(R.drawable.rc_ic_bubble_no_left);
        }
        holder.sendFire.setVisibility(8);
        holder.receiverFire.setVisibility(8);
        holder.fireView.setVisibility(8);
        holder.img.setVisibility(0);
        holder.img.setResource(content.getThumUri());
        int progress = message.getProgress();
        Message.SentStatus status = message.getSentStatus();
        if (status != null && (status.equals((Object)Message.SentStatus.SENDING) && progress < 100 || status.equals((Object)Message.SentStatus.FAILED) && ResendManager.getInstance().needResend(message.getMessageId()))) {
            holder.message.setText((CharSequence)(progress + "%"));
            holder.message.setVisibility(0);
        } else {
            holder.message.setVisibility(8);
        }
    }

    private void bindFireView(View v, int position, ImageMessage content, UIMessage message) {
        ViewHolder holder = (ViewHolder)v.getTag();
        holder.img.setVisibility(8);
        holder.fireView.setVisibility(0);
        if (message.getMessageDirection() == Message.MessageDirection.SEND) {
            holder.sendFire.setVisibility(0);
            holder.receiverFire.setVisibility(8);
            holder.fireView.setBackgroundResource(R.drawable.rc_ic_bubble_no_right);
            Drawable drawable2 = v.getContext().getResources().getDrawable(R.drawable.rc_fire_sender_album);
            drawable2.setBounds(0, 0, RongUtils.dip2px(31.0f), RongUtils.dip2px(26.0f));
            holder.clickHint.setCompoundDrawables(null, drawable2, null, null);
            holder.clickHint.setTextColor(Color.parseColor((String)"#FFFFFF"));
        } else {
            holder.sendFire.setVisibility(8);
            holder.receiverFire.setVisibility(0);
            holder.fireView.setBackgroundResource(R.drawable.rc_ic_bubble_no_left);
            Drawable drawable3 = v.getContext().getResources().getDrawable(R.drawable.rc_fire_receiver_album);
            drawable3.setBounds(0, 0, RongUtils.dip2px(31.0f), RongUtils.dip2px(26.0f));
            holder.clickHint.setCompoundDrawables(null, drawable3, null, null);
            holder.clickHint.setTextColor(Color.parseColor((String)"#F4B50B"));
            DestructManager.getInstance().addListener(message.getUId(), new DestructListener(holder, message), TAG);
            if (message.getMessage().getReadTime() > 0L) {
                holder.receiverFireText.setVisibility(0);
                holder.receiverFireImg.setVisibility(8);
                String unFinishTime = TextUtils.isEmpty((CharSequence)message.getUnDestructTime()) ? DestructManager.getInstance().getUnFinishTime(message.getUId()) : message.getUnDestructTime();
                holder.receiverFireText.setText((CharSequence)unFinishTime);
                DestructManager.getInstance().startDestruct(message.getMessage());
            } else {
                holder.receiverFireText.setVisibility(8);
                holder.receiverFireImg.setVisibility(0);
            }
        }
    }

    @Override
    public Spannable getContentSummary(ImageMessage data) {
        return null;
    }

    @Override
    public Spannable getContentSummary(Context context, ImageMessage data) {
        if (data.isDestruct()) {
            return new SpannableString((CharSequence)context.getString(R.string.rc_message_content_burn));
        }
        return new SpannableString((CharSequence)context.getString(R.string.rc_message_content_image));
    }

    private static class DestructListener
    implements RongIMClient.DestructCountDownTimerListener {
        private WeakReference<ViewHolder> mHolder;
        private UIMessage mUIMessage;

        public DestructListener(ViewHolder pHolder, UIMessage pUIMessage) {
            this.mHolder = new WeakReference<ViewHolder>(pHolder);
            this.mUIMessage = pUIMessage;
        }

        public void onTick(long millisUntilFinished, String messageId) {
            ViewHolder viewHolder;
            if (this.mUIMessage.getUId().equals(messageId) && (viewHolder = (ViewHolder)this.mHolder.get()) != null && messageId.equals(viewHolder.receiverFire.getTag())) {
                viewHolder.receiverFireText.setVisibility(0);
                viewHolder.receiverFireImg.setVisibility(8);
                String unDestructTime = String.valueOf(Math.max(millisUntilFinished, 1L));
                viewHolder.receiverFireText.setText((CharSequence)unDestructTime);
                this.mUIMessage.setUnDestructTime(unDestructTime);
            }
        }

        public void onStop(String messageId) {
            ViewHolder viewHolder;
            if (this.mUIMessage.getUId().equals(messageId) && (viewHolder = (ViewHolder)this.mHolder.get()) != null && messageId.equals(viewHolder.receiverFire.getTag())) {
                viewHolder.receiverFireText.setVisibility(8);
                viewHolder.receiverFireImg.setVisibility(0);
                this.mUIMessage.setUnDestructTime(null);
            }
        }
    }

    private static class ViewHolder {
        AsyncImageView img;
        TextView message;
        FrameLayout fireView;
        FrameLayout sendFire;
        FrameLayout receiverFire;
        ImageView receiverFireImg;
        TextView receiverFireText;
        TextView clickHint;

        private ViewHolder() {
        }
    }
}

