/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.os.Parcelable;
import android.text.Spannable;
import android.view.View;
import android.view.ViewGroup;
import io.rong.imkit.R;
import io.rong.imkit.RongMessageItemLongClickActionManager;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.utilities.OptionsPopupDialog;
import io.rong.imkit.widget.provider.MessageItemLongClickAction;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.UserInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public interface IContainerItemProvider<T> {
    public View newView(Context var1, ViewGroup var2);

    public void bindView(View var1, int var2, T var3);

    public static interface ConversationProvider<T extends Parcelable>
    extends IContainerItemProvider<T> {
        public String getTitle(String var1);

        public Uri getPortraitUri(String var1);
    }

    public static abstract class MessageProvider<K extends MessageContent>
    implements IContainerItemProvider<UIMessage>,
    Cloneable {
        @Override
        public final void bindView(View v, int position, UIMessage data) {
            this.bindView(v, position, data.getContent(), data);
        }

        public abstract void bindView(View var1, int var2, K var3, UIMessage var4);

        public Spannable getContentSummary(Context context, K data) {
            return this.getContentSummary(data);
        }

        public Spannable getSummary(UIMessage data) {
            return this.getContentSummary(data.getContent());
        }

        public abstract Spannable getContentSummary(K var1);

        public abstract void onItemClick(View var1, int var2, K var3, UIMessage var4);

        public void onItemLongClick(final View view, final int position, K content, final UIMessage message) {
            final List<MessageItemLongClickAction> messageItemLongClickActions = RongMessageItemLongClickActionManager.getInstance().getMessageItemLongClickActions(message);
            Collections.sort(messageItemLongClickActions, new Comparator<MessageItemLongClickAction>(){

                @Override
                public int compare(MessageItemLongClickAction lhs, MessageItemLongClickAction rhs) {
                    return rhs.priority - lhs.priority;
                }
            });
            ArrayList<String> titles = new ArrayList<String>();
            for (MessageItemLongClickAction action : messageItemLongClickActions) {
                titles.add(action.getTitle(view.getContext()));
            }
            int size = titles.size();
            OptionsPopupDialog dialog = OptionsPopupDialog.newInstance(view.getContext(), titles.toArray(new String[size])).setOptionsPopupDialogListener(new OptionsPopupDialog.OnOptionsItemClickedListener(){

                @Override
                public void onOptionsItemClicked(int which) {
                    if (!((MessageItemLongClickAction)messageItemLongClickActions.get((int)which)).listener.onMessageItemLongClick(view.getContext(), message)) {
                        MessageProvider.this.onItemLongClickAction(view, position, message);
                    }
                }
            });
            RongMessageItemLongClickActionManager.getInstance().setLongClickDialog(dialog);
            RongMessageItemLongClickActionManager.getInstance().setLongClickMessage(message.getMessage());
            dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    RongMessageItemLongClickActionManager.getInstance().setLongClickDialog(null);
                    RongMessageItemLongClickActionManager.getInstance().setLongClickMessage(null);
                }
            });
            dialog.show();
        }

        public void onItemLongClickAction(View view, int position, UIMessage message) {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public String getPushContent(Context context, UIMessage message) {
            String userName = "";
            UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(message.getSenderUserId());
            if (userInfo != null) {
                userName = userInfo.getName();
            }
            return context.getString(R.string.rc_user_recalled_message, new Object[]{userName});
        }
    }
}

