/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import io.rong.common.RLog;
import io.rong.eventbus.EventBus;
import io.rong.imkit.R;
import io.rong.imkit.RongIM;
import io.rong.imkit.destruct.DestructManager;
import io.rong.imkit.manager.AudioPlayManager;
import io.rong.imkit.manager.AudioRecordManager;
import io.rong.imkit.manager.IAudioPlayListener;
import io.rong.imkit.model.Event;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.common.NetUtils;
import io.rong.imlib.model.Message;
import io.rong.message.HQVoiceMessage;
import java.io.File;
import java.lang.ref.WeakReference;

@ProviderTag(messageContent=HQVoiceMessage.class, showReadState=true)
public class HQVoiceMessageItemProvider
extends IContainerItemProvider.MessageProvider<HQVoiceMessage> {
    private static final String TAG = "HQVoiceMessageItemProvider";

    @Override
    public View newView(Context context, ViewGroup group) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_item_hq_voice_message, null);
        ViewHolder holder = new ViewHolder();
        holder.left = (TextView)view.findViewById(R.id.rc_left);
        holder.right = (TextView)view.findViewById(R.id.rc_right);
        holder.img = (ImageView)view.findViewById(R.id.rc_img);
        holder.unread = (ImageView)view.findViewById(R.id.rc_voice_unread);
        holder.downloadError = (ImageView)view.findViewById(R.id.rc_voice_download_error);
        holder.downloadProcessing = (ProgressBar)view.findViewById(R.id.rc_download_progress);
        holder.sendFire = (FrameLayout)view.findViewById(R.id.fl_send_fire);
        holder.receiverFire = (FrameLayout)view.findViewById(R.id.fl_receiver_fire);
        holder.receiverFireImg = (ImageView)view.findViewById(R.id.iv_receiver_fire);
        holder.receiverFireText = (TextView)view.findViewById(R.id.tv_receiver_fire);
        view.setTag((Object)holder);
        return view;
    }

    @Override
    public void bindView(View v, int position, HQVoiceMessage content, UIMessage message) {
        Uri playingUri;
        ViewHolder holder = (ViewHolder)v.getTag();
        holder.receiverFire.setTag((Object)message.getUId());
        if (content.isDestruct()) {
            if (message.getMessageDirection() == Message.MessageDirection.SEND) {
                holder.sendFire.setVisibility(0);
                holder.receiverFire.setVisibility(8);
            } else {
                holder.sendFire.setVisibility(8);
                holder.receiverFire.setVisibility(0);
                DestructManager.getInstance().addListener(message.getUId(), new DestructListener(holder, message), TAG);
                if (message.getMessage().getReadTime() > 0L) {
                    holder.receiverFireText.setVisibility(0);
                    holder.receiverFireImg.setVisibility(8);
                    String unFinishTime = TextUtils.isEmpty((CharSequence)message.getUnDestructTime()) ? DestructManager.getInstance().getUnFinishTime(message.getUId()) : message.getUnDestructTime();
                    holder.receiverFireText.setText((CharSequence)unFinishTime);
                    DestructManager.getInstance().startDestruct(message.getMessage());
                } else {
                    holder.receiverFireText.setVisibility(8);
                    holder.receiverFireImg.setVisibility(0);
                }
            }
        } else {
            holder.sendFire.setVisibility(8);
            holder.receiverFire.setVisibility(8);
        }
        if (message.continuePlayAudio) {
            playingUri = AudioPlayManager.getInstance().getPlayingUri();
            if (playingUri == null || !playingUri.equals((Object)content.getLocalPath())) {
                boolean listened = message.getMessage().getReceivedStatus().isListened();
                AudioPlayManager.getInstance().startPlay(v.getContext(), content.getLocalPath(), new VoiceMessagePlayListener(v.getContext(), message, holder, listened));
            }
        } else {
            playingUri = AudioPlayManager.getInstance().getPlayingUri();
            if (playingUri != null && playingUri.equals((Object)content.getLocalPath())) {
                this.setLayout(v.getContext(), holder, message, true);
                boolean listened = message.getMessage().getReceivedStatus().isListened();
                AudioPlayManager.getInstance().setPlayListener(new VoiceMessagePlayListener(v.getContext(), message, holder, listened));
            } else {
                this.setLayout(v.getContext(), holder, message, false);
            }
        }
    }

    @Override
    public void onItemClick(View view, int position, HQVoiceMessage content, UIMessage message) {
        if (content == null) {
            return;
        }
        RLog.d((String)TAG, (String)("Item index:" + position + " content.getLocalPath():" + content.getLocalPath()));
        ViewHolder holder = (ViewHolder)view.getTag();
        if (AudioPlayManager.getInstance().isPlaying()) {
            if (AudioPlayManager.getInstance().getPlayingUri().equals((Object)content.getLocalPath())) {
                AudioPlayManager.getInstance().stopPlay();
                return;
            }
            AudioPlayManager.getInstance().stopPlay();
        }
        if (!AudioPlayManager.getInstance().isInNormalMode(view.getContext()) && AudioPlayManager.getInstance().isInVOIPMode(view.getContext())) {
            Toast.makeText((Context)view.getContext(), (CharSequence)view.getContext().getString(R.string.rc_voip_occupying), (int)0).show();
            return;
        }
        boolean listened = message.getMessage().getReceivedStatus().isListened();
        this.playOrDownloadHQVoiceMsg(view, content, message, holder, listened);
    }

    private void playOrDownloadHQVoiceMsg(View view, HQVoiceMessage content, UIMessage message, ViewHolder holder, boolean listened) {
        boolean ifDownloadHQVoiceMsg;
        boolean bl = ifDownloadHQVoiceMsg = content.getLocalPath() == null || TextUtils.isEmpty((CharSequence)content.getLocalPath().toString());
        if (message.getMessageDirection() == Message.MessageDirection.RECEIVE) {
            boolean bl2 = ifDownloadHQVoiceMsg = content.getLocalPath() == null || TextUtils.isEmpty((CharSequence)content.getLocalPath().toString()) || !this.isFileExists(content.getLocalPath().toString());
        }
        if (ifDownloadHQVoiceMsg) {
            this.downloadHQVoiceMsg(view, message, holder, listened);
        } else {
            this.playHQVoiceMessage(view, content, message, holder, listened);
        }
    }

    private void downloadHQVoiceMsg(final View view, final UIMessage uiMessage, final ViewHolder holder, final boolean listened) {
        RongIM.getInstance().downloadMediaMessage(uiMessage.getMessage(), new IRongCallback.IDownloadMediaMessageCallback(){

            public void onSuccess(Message message) {
                RLog.d((String)HQVoiceMessageItemProvider.TAG, (String)"playOrDownloadHQVoiceMsg onSuccess");
                holder.downloadError.setVisibility(8);
                holder.downloadProcessing.setVisibility(8);
                HQVoiceMessageItemProvider.this.playHQVoiceMessage(view, (HQVoiceMessage)message.getContent(), uiMessage, holder, listened);
            }

            public void onProgress(Message message, int progress) {
                holder.downloadProcessing.setVisibility(0);
            }

            public void onError(Message message, RongIMClient.ErrorCode code) {
                RLog.d((String)HQVoiceMessageItemProvider.TAG, (String)"playOrDownloadHQVoiceMsg onError");
                holder.downloadError.setVisibility(0);
                holder.downloadProcessing.setVisibility(8);
            }

            public void onCanceled(Message message) {
            }
        });
    }

    private void playHQVoiceMessage(View view, HQVoiceMessage content, UIMessage message, ViewHolder holder, boolean listened) {
        holder.unread.setVisibility(8);
        AudioPlayManager.getInstance().startPlay(view.getContext(), content.getLocalPath(), new VoiceMessagePlayListener(view.getContext(), message, holder, listened));
    }

    private boolean isFileExists(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        if (filePath.startsWith("file://")) {
            filePath = filePath.substring(7);
        }
        File file = new File(filePath);
        return file.exists();
    }

    private void setLayout(Context context, ViewHolder holder, UIMessage message, boolean playing) {
        HQVoiceMessage content = (HQVoiceMessage)message.getContent();
        int minWidth = 70;
        int maxWidth = 204;
        float scale = context.getResources().getDisplayMetrics().density;
        minWidth = (int)((float)minWidth * scale + 0.5f);
        maxWidth = (int)((float)maxWidth * scale + 0.5f);
        int duration = AudioRecordManager.getInstance().getMaxVoiceDuration();
        holder.img.getLayoutParams().width = minWidth + (maxWidth - minWidth) / duration * content.getDuration();
        if (message.getMessageDirection() == Message.MessageDirection.SEND) {
            holder.left.setText((CharSequence)String.format("%s\"", content.getDuration()));
            holder.left.setVisibility(0);
            holder.right.setVisibility(8);
            holder.unread.setVisibility(8);
            holder.downloadError.setVisibility(8);
            holder.downloadProcessing.setVisibility(8);
            holder.img.setScaleType(ImageView.ScaleType.FIT_END);
            holder.img.setBackgroundResource(R.drawable.rc_ic_bubble_right);
            AnimationDrawable animationDrawable = (AnimationDrawable)context.getResources().getDrawable(R.drawable.rc_an_voice_sent);
            if (playing) {
                holder.img.setImageDrawable((Drawable)animationDrawable);
                if (animationDrawable != null) {
                    animationDrawable.start();
                }
            } else {
                holder.img.setImageDrawable(holder.img.getResources().getDrawable(R.drawable.rc_ic_voice_sent));
                if (animationDrawable != null) {
                    animationDrawable.stop();
                }
            }
        } else {
            holder.right.setText((CharSequence)String.format("%s\"", content.getDuration()));
            holder.right.setVisibility(0);
            holder.left.setVisibility(8);
            RLog.d((String)TAG, (String)("message.getExtra() = " + message.getExtra()));
            holder.downloadProcessing.setVisibility(0);
            holder.downloadError.setVisibility(8);
            if (((HQVoiceMessage)message.getContent()).getLocalPath() != null) {
                holder.downloadProcessing.setVisibility(8);
                holder.downloadError.setVisibility(8);
            } else if (!NetUtils.isNetWorkAvailable((Context)context)) {
                holder.downloadError.setVisibility(0);
                holder.downloadProcessing.setVisibility(8);
            }
            if (!message.getReceivedStatus().isListened() && ((HQVoiceMessage)message.getContent()).getLocalPath() != null) {
                holder.unread.setVisibility(0);
            } else {
                holder.unread.setVisibility(8);
            }
            holder.img.setBackgroundResource(R.drawable.rc_ic_bubble_left);
            AnimationDrawable animationDrawable = (AnimationDrawable)context.getResources().getDrawable(R.drawable.rc_an_voice_receive);
            if (playing) {
                holder.img.setImageDrawable((Drawable)animationDrawable);
                if (animationDrawable != null) {
                    animationDrawable.start();
                }
            } else {
                holder.img.setImageDrawable(holder.img.getResources().getDrawable(R.drawable.rc_ic_voice_receive));
                if (animationDrawable != null) {
                    animationDrawable.stop();
                }
            }
            holder.img.setScaleType(ImageView.ScaleType.FIT_START);
        }
    }

    @Override
    public Spannable getContentSummary(HQVoiceMessage data) {
        return null;
    }

    @Override
    public Spannable getContentSummary(Context context, HQVoiceMessage data) {
        if (data.isDestruct()) {
            return new SpannableString((CharSequence)context.getString(R.string.rc_message_content_burn));
        }
        return new SpannableString((CharSequence)context.getString(R.string.rc_message_content_voice));
    }

    private static class DestructListener
    implements RongIMClient.DestructCountDownTimerListener {
        private WeakReference<ViewHolder> mHolder;
        private UIMessage mUIMessage;

        DestructListener(ViewHolder pHolder, UIMessage pUIMessage) {
            this.mHolder = new WeakReference<ViewHolder>(pHolder);
            this.mUIMessage = pUIMessage;
        }

        public void onTick(long millisUntilFinished, String messageId) {
            ViewHolder viewHolder;
            if (this.mUIMessage.getUId().equals(messageId) && (viewHolder = (ViewHolder)this.mHolder.get()) != null && messageId.equals(viewHolder.receiverFire.getTag())) {
                viewHolder.receiverFireText.setVisibility(0);
                viewHolder.receiverFireImg.setVisibility(8);
                String unDestructTime = String.valueOf(Math.max(millisUntilFinished, 1L));
                viewHolder.receiverFireText.setText((CharSequence)unDestructTime);
                this.mUIMessage.setUnDestructTime(unDestructTime);
            }
        }

        public void onStop(String messageId) {
            ViewHolder viewHolder;
            if (this.mUIMessage.getUId().equals(messageId) && (viewHolder = (ViewHolder)this.mHolder.get()) != null && messageId.equals(viewHolder.receiverFire.getTag())) {
                viewHolder.receiverFireText.setVisibility(8);
                viewHolder.receiverFireImg.setVisibility(0);
                this.mUIMessage.setUnDestructTime(null);
            }
        }
    }

    private class VoiceMessagePlayListener
    implements IAudioPlayListener {
        private Context context;
        private UIMessage message;
        private ViewHolder holder;
        private boolean listened;

        VoiceMessagePlayListener(Context context, UIMessage message, ViewHolder holder, boolean listened) {
            this.context = context;
            this.message = message;
            this.holder = holder;
            this.listened = listened;
        }

        @Override
        public void onStart(Uri uri) {
            this.message.continuePlayAudio = false;
            this.message.setListening(true);
            this.message.getReceivedStatus().setListened();
            RongIMClient.getInstance().setMessageReceivedStatus(this.message.getMessageId(), this.message.getReceivedStatus(), null);
            HQVoiceMessageItemProvider.this.setLayout(this.context, this.holder, this.message, true);
            EventBus.getDefault().post(new Event.AudioListenedEvent(this.message.getMessage()));
            if (this.message.getContent().isDestruct() && this.message.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                DestructManager.getInstance().stopDestruct(this.message.getMessage());
                EventBus.getDefault().post(new Event.changeDestructionReadTimeEvent(this.message.getMessage()));
            }
        }

        @Override
        public void onStop(Uri uri) {
            if (this.message.getContent() instanceof HQVoiceMessage) {
                this.message.setListening(false);
                HQVoiceMessageItemProvider.this.setLayout(this.context, this.holder, this.message, false);
                if (this.message.getContent().isDestruct() && this.message.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                    DestructManager.getInstance().startDestruct(this.message.getMessage());
                }
            }
        }

        @Override
        public void onComplete(Uri uri) {
            Event.PlayAudioEvent event = Event.PlayAudioEvent.obtain();
            event.messageId = this.message.getMessageId();
            if (this.message.isListening() && this.message.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                try {
                    event.continuously = this.context.getResources().getBoolean(R.bool.rc_play_audio_continuous);
                }
                catch (Resources.NotFoundException e) {
                    RLog.e((String)HQVoiceMessageItemProvider.TAG, (String)"VoiceMessagePlayListener.onComplete", (Throwable)e);
                }
            }
            if (event.continuously && !this.message.getContent().isDestruct()) {
                EventBus.getDefault().post(event);
            }
            this.message.setListening(false);
            HQVoiceMessageItemProvider.this.setLayout(this.context, this.holder, this.message, false);
            if (this.message.getContent().isDestruct() && this.message.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                DestructManager.getInstance().startDestruct(this.message.getMessage());
            }
        }
    }

    private static class ViewHolder {
        ImageView img;
        TextView left;
        TextView right;
        ImageView unread;
        ImageView downloadError;
        ProgressBar downloadProcessing;
        FrameLayout sendFire;
        FrameLayout receiverFire;
        ImageView receiverFireImg;
        TextView receiverFireText;

        private ViewHolder() {
        }
    }
}

