/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import io.rong.imkit.R;
import io.rong.imkit.RongIM;
import io.rong.imkit.destruct.DestructManager;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.resend.ResendManager;
import io.rong.imkit.utilities.PermissionCheckUtil;
import io.rong.imkit.utilities.RongUtils;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imkit.widget.CircleProgressView;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Message;
import io.rong.message.GIFMessage;
import java.lang.ref.WeakReference;

@ProviderTag(messageContent=GIFMessage.class, showProgress=false, showReadState=true)
public class GIFMessageItemProvider
extends IContainerItemProvider.MessageProvider<GIFMessage> {
    private static final String TAG = "GIFMessageItemProvider";

    @Override
    public View newView(Context context, ViewGroup group) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_item_gif_message, null);
        ViewHolder holder = new ViewHolder();
        holder.img = (AsyncImageView)view.findViewById(R.id.rc_img);
        holder.preProgress = (ProgressBar)view.findViewById(R.id.rc_pre_progress);
        holder.loadingProgress = (CircleProgressView)view.findViewById(R.id.rc_gif_progress);
        holder.startDownLoad = (ImageView)view.findViewById(R.id.rc_start_download);
        holder.downLoadFailed = (ImageView)view.findViewById(R.id.rc_download_failed);
        holder.length = (TextView)view.findViewById(R.id.rc_length);
        holder.fireView = (FrameLayout)view.findViewById(R.id.rc_destruct_click);
        holder.sendFire = (FrameLayout)view.findViewById(R.id.fl_send_fire);
        holder.receiverFire = (FrameLayout)view.findViewById(R.id.fl_receiver_fire);
        holder.receiverFireImg = (ImageView)view.findViewById(R.id.iv_receiver_fire);
        holder.receiverFireText = (TextView)view.findViewById(R.id.tv_receiver_fire);
        holder.clickHint = (TextView)view.findViewById(R.id.rc_destruct_click_hint);
        view.setTag((Object)holder);
        return view;
    }

    @Override
    public void onItemClick(View view, int position, GIFMessage content, UIMessage message) {
        ViewHolder holder = (ViewHolder)view.getTag();
        if (holder.startDownLoad.getVisibility() == 0) {
            holder.startDownLoad.setVisibility(8);
            if (this.checkPermission(view.getContext())) {
                this.downLoad(message.getMessage(), holder);
            } else {
                holder.downLoadFailed.setVisibility(0);
                holder.length.setVisibility(0);
                holder.length.setText((CharSequence)this.formatSize(content.getGifDataSize()));
                Toast.makeText((Context)view.getContext(), (int)R.string.rc_ac_file_download_request_permission, (int)0).show();
            }
        } else if (holder.downLoadFailed.getVisibility() == 0) {
            holder.downLoadFailed.setVisibility(8);
            if (this.checkPermission(view.getContext())) {
                this.downLoad(message.getMessage(), holder);
            } else {
                holder.downLoadFailed.setVisibility(0);
                holder.length.setVisibility(0);
                holder.length.setText((CharSequence)this.formatSize(content.getGifDataSize()));
                Toast.makeText((Context)view.getContext(), (int)R.string.rc_ac_file_download_request_permission, (int)0).show();
            }
        } else if (holder.preProgress.getVisibility() != 0 && holder.loadingProgress.getVisibility() != 0 && content != null) {
            Intent intent = new Intent("io.rong.imkit.intent.action.gifrview");
            intent.setPackage(view.getContext().getPackageName());
            intent.putExtra("message", (Parcelable)message.getMessage());
            view.getContext().startActivity(intent);
        }
    }

    @Override
    public void bindView(View v, int position, GIFMessage content, UIMessage message) {
        ViewHolder holder = (ViewHolder)v.getTag();
        holder.receiverFire.setTag((Object)message.getUId());
        holder.startDownLoad.setVisibility(8);
        holder.downLoadFailed.setVisibility(8);
        holder.preProgress.setVisibility(8);
        holder.loadingProgress.setVisibility(8);
        holder.length.setVisibility(8);
        int[] paramsValue = this.getParamsValue(v.getContext(), content.getWidth(), content.getHeight());
        holder.img.setLayoutParam(paramsValue[0], paramsValue[1]);
        holder.img.setImageDrawable(v.getContext().getResources().getDrawable(R.drawable.def_gif_bg));
        int progress = message.getProgress();
        if (message.getMessageDirection() == Message.MessageDirection.SEND) {
            Message.SentStatus status = message.getSentStatus();
            if (progress > 0 && progress < 100 || status.equals((Object)Message.SentStatus.FAILED) && ResendManager.getInstance().needResend(message.getMessageId())) {
                holder.loadingProgress.setProgress(progress, true);
                holder.loadingProgress.setVisibility(0);
                holder.preProgress.setVisibility(8);
            } else if (status.equals((Object)Message.SentStatus.SENDING)) {
                holder.loadingProgress.setVisibility(8);
            } else if (progress == -1) {
                holder.loadingProgress.setVisibility(8);
                holder.preProgress.setVisibility(8);
                holder.downLoadFailed.setVisibility(0);
                holder.length.setVisibility(0);
            } else {
                holder.loadingProgress.setVisibility(8);
                holder.preProgress.setVisibility(8);
            }
        } else if (message.getReceivedStatus().isDownload()) {
            if (progress > 0 && progress < 100) {
                holder.loadingProgress.setProgress(progress, true);
                holder.loadingProgress.setVisibility(0);
                holder.preProgress.setVisibility(8);
                holder.startDownLoad.setVisibility(8);
            } else if (progress == 100) {
                holder.loadingProgress.setVisibility(8);
                holder.preProgress.setVisibility(8);
                holder.length.setVisibility(8);
                holder.startDownLoad.setVisibility(8);
            } else if (progress == -1) {
                holder.loadingProgress.setVisibility(8);
                holder.preProgress.setVisibility(8);
                holder.downLoadFailed.setVisibility(0);
                holder.length.setVisibility(0);
                holder.startDownLoad.setVisibility(8);
            } else {
                holder.loadingProgress.setVisibility(8);
                holder.preProgress.setVisibility(0);
                holder.length.setVisibility(0);
                holder.startDownLoad.setVisibility(8);
            }
        } else {
            holder.loadingProgress.setVisibility(8);
            holder.preProgress.setVisibility(8);
            holder.length.setVisibility(8);
            holder.startDownLoad.setVisibility(8);
            if (progress == -1) {
                holder.downLoadFailed.setVisibility(0);
                holder.length.setVisibility(0);
                holder.length.setText((CharSequence)this.formatSize(content.getGifDataSize()));
            }
        }
        if (content.isDestruct()) {
            Drawable drawable2;
            if (message.getMessageDirection() == Message.MessageDirection.SEND) {
                holder.sendFire.setVisibility(0);
                holder.receiverFire.setVisibility(8);
                holder.fireView.setBackgroundResource(R.drawable.rc_ic_bubble_no_right);
                drawable2 = v.getContext().getResources().getDrawable(R.drawable.rc_fire_sender_album);
                drawable2.setBounds(0, 0, RongUtils.dip2px(40.0f), RongUtils.dip2px(34.0f));
                holder.clickHint.setCompoundDrawables(null, drawable2, null, null);
                holder.clickHint.setTextColor(Color.parseColor((String)"#FFFFFF"));
            } else {
                holder.sendFire.setVisibility(8);
                holder.receiverFire.setVisibility(0);
                holder.fireView.setBackgroundResource(R.drawable.rc_ic_bubble_no_left);
                drawable2 = v.getContext().getResources().getDrawable(R.drawable.rc_fire_receiver_album);
                drawable2.setBounds(0, 0, RongUtils.dip2px(40.0f), RongUtils.dip2px(34.0f));
                holder.clickHint.setCompoundDrawables(null, drawable2, null, null);
                holder.clickHint.setTextColor(Color.parseColor((String)"#F4B50B"));
                DestructManager.getInstance().addListener(message.getUId(), new DestructListener(holder, message), TAG);
                if (message.getMessage().getReadTime() > 0L) {
                    holder.receiverFireText.setVisibility(0);
                    holder.receiverFireImg.setVisibility(8);
                    String unFinishTime = TextUtils.isEmpty((CharSequence)message.getUnDestructTime()) ? DestructManager.getInstance().getUnFinishTime(message.getUId()) : message.getUnDestructTime();
                    holder.receiverFireText.setText((CharSequence)unFinishTime);
                    DestructManager.getInstance().startDestruct(message.getMessage());
                } else {
                    holder.receiverFireText.setVisibility(8);
                    holder.receiverFireImg.setVisibility(0);
                }
            }
        } else {
            holder.receiverFire.setVisibility(8);
            holder.sendFire.setVisibility(8);
        }
        if (content.getLocalPath() != null) {
            if (content.isDestruct()) {
                holder.fireView.setVisibility(0);
                holder.img.setVisibility(8);
            } else {
                holder.fireView.setVisibility(8);
                holder.img.setVisibility(0);
                this.loadGif(v, content.getLocalUri(), holder);
            }
        } else {
            int size = v.getContext().getResources().getInteger(R.integer.rc_gifmsg_auto_download_size);
            if (content.getGifDataSize() <= (long)(size * 1024)) {
                if (this.checkPermission(v.getContext())) {
                    if (!message.getReceivedStatus().isDownload()) {
                        message.getReceivedStatus().setDownload();
                        this.downLoad(message.getMessage(), holder);
                    }
                } else if (progress != -1) {
                    holder.startDownLoad.setVisibility(0);
                    holder.length.setVisibility(0);
                    holder.length.setText((CharSequence)this.formatSize(content.getGifDataSize()));
                }
            } else if (progress > 0 && progress < 100) {
                holder.startDownLoad.setVisibility(8);
                holder.length.setVisibility(0);
                holder.length.setText((CharSequence)this.formatSize(content.getGifDataSize()));
            } else if (progress != -1) {
                holder.startDownLoad.setVisibility(0);
                holder.preProgress.setVisibility(8);
                holder.loadingProgress.setVisibility(8);
                holder.downLoadFailed.setVisibility(8);
                holder.length.setVisibility(0);
                holder.length.setText((CharSequence)this.formatSize(content.getGifDataSize()));
            }
        }
    }

    @Override
    public Spannable getContentSummary(GIFMessage data) {
        return null;
    }

    @Override
    public Spannable getContentSummary(Context context, GIFMessage data) {
        if (data.isDestruct()) {
            return new SpannableString((CharSequence)context.getString(R.string.rc_message_content_burn));
        }
        return new SpannableString((CharSequence)context.getString(R.string.rc_message_content_image));
    }

    private void downLoad(Message downloadMsg, ViewHolder holder) {
        holder.preProgress.setVisibility(0);
        RongIM.getInstance().downloadMediaMessage(downloadMsg, null);
    }

    private void loadGif(View v, Uri uri, ViewHolder holder) {
        ((RequestBuilder)Glide.with((Context)v.getContext()).asGif().diskCacheStrategy(DiskCacheStrategy.RESOURCE)).load(uri.getPath()).listener((RequestListener)new RequestListener<GifDrawable>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<GifDrawable> target, boolean isFirstResource) {
                return false;
            }

            public boolean onResourceReady(GifDrawable resource, Object model, Target<GifDrawable> target, DataSource dataSource, boolean isFirstResource) {
                return false;
            }
        }).into((ImageView)holder.img);
    }

    private String formatSize(long length) {
        if (length > 0x100000L) {
            float size = (float)Math.round((float)length / 1048576.0f * 100.0f) / 100.0f;
            return size + "M";
        }
        if (length > 1024L) {
            float size = (float)Math.round((float)length / 1024.0f * 100.0f) / 100.0f;
            return size + "KB";
        }
        return length + "B";
    }

    private int[] getParamsValue(Context context, int width, int height) {
        int finalHeight;
        float scale;
        int finalWidth;
        int maxWidth = GIFMessageItemProvider.dip2px(context, 120.0f);
        int minValue = GIFMessageItemProvider.dip2px(context, 80.0f);
        if (width > maxWidth) {
            finalWidth = maxWidth;
            scale = (float)width / (float)maxWidth;
            finalHeight = Math.round((float)height / scale);
            if (finalHeight < minValue) {
                finalHeight = minValue;
            }
        } else if (width < minValue) {
            finalWidth = minValue;
            scale = (float)width / (float)minValue;
            finalHeight = Math.round((float)height * scale);
            if (finalHeight < minValue) {
                finalHeight = minValue;
            }
        } else {
            finalWidth = Math.round(height);
            finalHeight = Math.round(width);
        }
        int[] params = new int[]{finalWidth, finalHeight};
        return params;
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    private boolean checkPermission(Context context) {
        String[] permission2 = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
        return PermissionCheckUtil.checkPermissions(context, permission2);
    }

    @Override
    public void onItemLongClick(View view, int position, GIFMessage content, UIMessage message) {
        ViewHolder holder = (ViewHolder)view.getTag();
        if (holder.startDownLoad.getVisibility() == 0 || holder.downLoadFailed.getVisibility() == 0 || holder.loadingProgress.getVisibility() == 0) {
            return;
        }
        super.onItemLongClick(view, position, content, message);
    }

    private static class DestructListener
    implements RongIMClient.DestructCountDownTimerListener {
        private WeakReference<ViewHolder> mHolder;
        private UIMessage mUIMessage;

        public DestructListener(ViewHolder pHolder, UIMessage pUIMessage) {
            this.mHolder = new WeakReference<ViewHolder>(pHolder);
            this.mUIMessage = pUIMessage;
        }

        public void onTick(long millisUntilFinished, String messageId) {
            ViewHolder viewHolder;
            if (this.mUIMessage.getUId().equals(messageId) && (viewHolder = (ViewHolder)this.mHolder.get()) != null && messageId.equals(viewHolder.receiverFire.getTag())) {
                viewHolder.receiverFireText.setVisibility(0);
                viewHolder.receiverFireImg.setVisibility(8);
                String unDestructTime = String.valueOf(Math.max(millisUntilFinished, 1L));
                viewHolder.receiverFireText.setText((CharSequence)unDestructTime);
                this.mUIMessage.setUnDestructTime(unDestructTime);
            }
        }

        public void onStop(String messageId) {
            ViewHolder viewHolder;
            if (this.mUIMessage.getUId().equals(messageId) && (viewHolder = (ViewHolder)this.mHolder.get()) != null && messageId.equals(viewHolder.receiverFire.getTag())) {
                viewHolder.receiverFireText.setVisibility(8);
                viewHolder.receiverFireImg.setVisibility(0);
                this.mUIMessage.setUnDestructTime(null);
            }
        }
    }

    private static class ViewHolder {
        AsyncImageView img;
        ProgressBar preProgress;
        CircleProgressView loadingProgress;
        ImageView startDownLoad;
        ImageView downLoadFailed;
        TextView length;
        FrameLayout fireView;
        FrameLayout sendFire;
        FrameLayout receiverFire;
        ImageView receiverFireImg;
        TextView receiverFireText;
        TextView clickHint;

        private ViewHolder() {
        }
    }
}

