/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import io.rong.common.LibStorageUtils;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongExtension;
import io.rong.imkit.RongIM;
import io.rong.imkit.activity.FileManagerActivity;
import io.rong.imkit.model.FileInfo;
import io.rong.imkit.plugin.IPluginModule;
import io.rong.imkit.plugin.IPluginRequestPermissionResultCallback;
import io.rong.imkit.utilities.PermissionCheckUtil;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import io.rong.message.FileMessage;
import java.util.HashSet;

public class FilePlugin
implements IPluginModule,
IPluginRequestPermissionResultCallback {
    private static final String TAG = "FileInputProvider";
    private static final int REQUEST_FILE = 100;
    private static final int REQUEST_FILE_Q = 101;
    private static final int TIME_DELAY = 400;
    private Conversation.ConversationType conversationType;
    private String targetId;

    @Override
    public Drawable obtainDrawable(Context context) {
        return ContextCompat.getDrawable((Context)context, (int)R.drawable.rc_ic_files_selector);
    }

    @Override
    public String obtainTitle(Context context) {
        return context.getString(R.string.rc_plugins_files);
    }

    @Override
    public void onClick(Fragment currentFragment, RongExtension extension) {
        this.conversationType = extension.getConversationType();
        this.targetId = extension.getTargetId();
        if (LibStorageUtils.isBuildAndTargetForQ((Context)currentFragment.getContext())) {
            Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT");
            intent.addCategory("android.intent.category.OPENABLE");
            intent.setType("*/*");
            extension.startActivityForPluginResult(intent, 101, this);
        } else {
            String[] permissions = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
            if (PermissionCheckUtil.checkPermissions(currentFragment.getContext(), permissions)) {
                Intent intent = new Intent((Context)currentFragment.getActivity(), FileManagerActivity.class);
                extension.startActivityForPluginResult(intent, 100, this);
            } else {
                extension.requestPermissionForPluginResult(permissions, 255, this);
            }
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 100) {
            if (data != null) {
                HashSet selectedFileInfos = (HashSet)data.getSerializableExtra("sendSelectedFiles");
                SendMediaMessageThread thread = new SendMediaMessageThread(this.conversationType, this.targetId, selectedFileInfos);
                thread.start();
            }
        } else if (requestCode == 101 && data != null) {
            Uri uri = data.getData();
            SendMediaMessageThreadForQ thread = new SendMediaMessageThreadForQ(this.conversationType, this.targetId, uri);
            thread.start();
        }
    }

    @Override
    public boolean onRequestPermissionResult(Fragment currentFragment, RongExtension extension, int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (PermissionCheckUtil.checkPermissions((Context)currentFragment.getActivity(), permissions)) {
            Intent intent = new Intent((Context)currentFragment.getActivity(), FileManagerActivity.class);
            extension.startActivityForPluginResult(intent, 100, this);
        } else {
            extension.showRequestPermissionFailedAlter(PermissionCheckUtil.getNotGrantedPermissionMsg((Context)currentFragment.getActivity(), permissions, grantResults));
        }
        return true;
    }

    private static class SendMediaMessageThread
    extends Thread {
        private Conversation.ConversationType conversationType;
        private String targetId;
        private HashSet<FileInfo> selectedFileInfos;

        private SendMediaMessageThread(Conversation.ConversationType conversationType, String targetId, HashSet<FileInfo> selectedFileInfos) {
            this.conversationType = conversationType;
            this.targetId = targetId;
            this.selectedFileInfos = selectedFileInfos;
        }

        @Override
        public void run() {
            for (FileInfo fileInfo : this.selectedFileInfos) {
                Uri filePath = Uri.parse((String)("file://" + fileInfo.getFilePath()));
                FileMessage fileMessage = FileMessage.obtain((Uri)filePath);
                if (fileMessage == null) continue;
                fileMessage.setType(fileInfo.getSuffix());
                Message message = Message.obtain((String)this.targetId, (Conversation.ConversationType)this.conversationType, (MessageContent)fileMessage);
                RongIM.getInstance().sendMediaMessage(message, null, null, (IRongCallback.ISendMediaMessageCallback)null);
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException e) {
                    RLog.e((String)FilePlugin.TAG, (String)("sendMediaMessage e:" + e.toString()));
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static class SendMediaMessageThreadForQ
    extends Thread {
        private Conversation.ConversationType conversationType;
        private String targetId;
        private Uri uri;

        private SendMediaMessageThreadForQ(Conversation.ConversationType conversationType, String targetId, Uri uri) {
            this.conversationType = conversationType;
            this.targetId = targetId;
            this.uri = uri;
        }

        @Override
        public void run() {
            FileMessage fileMessage = FileMessage.obtain((Context)RongIM.getInstance().getApplicationContext(), (Uri)this.uri);
            if (fileMessage != null) {
                Message message = Message.obtain((String)this.targetId, (Conversation.ConversationType)this.conversationType, (MessageContent)fileMessage);
                RongIM.getInstance().sendMediaMessage(message, null, null, (IRongCallback.ISendMediaMessageCallback)null);
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException e) {
                    RLog.e((String)FilePlugin.TAG, (String)("sendMediaMessage e:" + e.toString()));
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

