/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.text.Spannable;
import android.text.SpannableString;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import io.rong.imkit.R;
import io.rong.imkit.RongIM;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.resend.ResendManager;
import io.rong.imkit.utils.FileTypeUtils;
import io.rong.imkit.widget.EllipsizeTextView;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Message;
import io.rong.message.FileMessage;

@ProviderTag(messageContent=FileMessage.class, showProgress=false, showReadState=true)
public class FileMessageItemProvider
extends IContainerItemProvider.MessageProvider<FileMessage> {
    private static final String TAG = "FileMessageItemProvider";

    @Override
    public View newView(Context context, ViewGroup group) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_item_file_message, null);
        ViewHolder holder = new ViewHolder();
        holder.message = (LinearLayout)view.findViewById(R.id.rc_message);
        holder.fileTypeImage = (ImageView)view.findViewById(R.id.rc_msg_iv_file_type_image);
        holder.fileName = (EllipsizeTextView)view.findViewById(R.id.rc_msg_tv_file_name);
        holder.fileSize = (TextView)view.findViewById(R.id.rc_msg_tv_file_size);
        holder.fileUploadProgress = (ProgressBar)view.findViewById(R.id.rc_msg_pb_file_upload_progress);
        holder.cancelButton = (RelativeLayout)view.findViewById(R.id.rc_btn_cancel);
        holder.canceledMessage = (TextView)view.findViewById(R.id.rc_msg_canceled);
        view.setTag((Object)holder);
        return view;
    }

    @Override
    public void bindView(View v, int position, FileMessage content, final UIMessage message) {
        final ViewHolder holder = (ViewHolder)v.getTag();
        if (message.getMessageDirection() == Message.MessageDirection.SEND) {
            holder.message.setBackgroundResource(R.drawable.rc_ic_bubble_right_file);
        } else {
            holder.message.setBackgroundResource(R.drawable.rc_ic_bubble_left_file);
        }
        holder.fileName.setAdaptiveText(content.getName());
        long fileSizeBytes = content.getSize();
        holder.fileSize.setText((CharSequence)FileTypeUtils.formatFileSize(fileSizeBytes));
        holder.fileTypeImage.setImageResource(FileTypeUtils.fileTypeImageId(v.getContext(), content.getName()));
        if (message.getSentStatus().equals((Object)Message.SentStatus.SENDING) && message.getProgress() < 100) {
            holder.fileUploadProgress.setVisibility(0);
            holder.cancelButton.setVisibility(0);
            holder.canceledMessage.setVisibility(4);
            holder.fileUploadProgress.setProgress(message.getProgress());
        } else if (message.getSentStatus().equals((Object)Message.SentStatus.FAILED) && ResendManager.getInstance().needResend(message.getMessageId())) {
            holder.fileUploadProgress.setVisibility(0);
            holder.cancelButton.setVisibility(8);
            holder.canceledMessage.setVisibility(4);
            holder.fileUploadProgress.setProgress(message.getProgress());
        } else {
            if (message.getSentStatus().equals((Object)Message.SentStatus.CANCELED)) {
                holder.canceledMessage.setVisibility(0);
            } else {
                holder.canceledMessage.setVisibility(4);
            }
            holder.fileUploadProgress.setVisibility(4);
            holder.cancelButton.setVisibility(8);
        }
        holder.cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RongIM.getInstance().cancelSendMediaMessage(message.getMessage(), new RongIMClient.OperationCallback(){

                    public void onSuccess() {
                        ResendManager.getInstance().removeResendMessage(message.getMessageId());
                        holder.canceledMessage.setVisibility(0);
                        holder.fileUploadProgress.setVisibility(4);
                        holder.cancelButton.setVisibility(8);
                    }

                    public void onError(RongIMClient.ErrorCode errorCode) {
                    }
                });
            }
        });
    }

    @Override
    public Spannable getContentSummary(FileMessage data) {
        return null;
    }

    @Override
    public Spannable getContentSummary(Context context, FileMessage data) {
        StringBuilder summaryPhrase = new StringBuilder();
        String fileName = data.getName();
        summaryPhrase.append(context.getString(R.string.rc_message_content_file)).append(" ").append(fileName);
        return new SpannableString((CharSequence)summaryPhrase);
    }

    @Override
    public void onItemClick(View view, int position, FileMessage content, UIMessage message) {
        Intent intent = new Intent("io.rong.imkit.intent.action.openfile");
        intent.setPackage(view.getContext().getPackageName());
        intent.putExtra("FileMessage", (Parcelable)content);
        intent.putExtra("Message", (Parcelable)message.getMessage());
        intent.putExtra("Progress", message.getProgress());
        view.getContext().startActivity(intent);
    }

    private static class ViewHolder {
        RelativeLayout cancelButton;
        LinearLayout message;
        EllipsizeTextView fileName;
        TextView fileSize;
        TextView canceledMessage;
        ImageView fileTypeImage;
        ProgressBar fileUploadProgress;

        private ViewHolder() {
        }
    }
}

