/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.rong.imkit.R;
import io.rong.imkit.RongIM;
import io.rong.imkit.message.CombineMessage;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.utils.CombineMessageUtils;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import java.io.File;
import java.util.List;

@ProviderTag(messageContent=CombineMessage.class, showReadState=true)
public class CombineMessageItemProvider
extends IContainerItemProvider.MessageProvider<CombineMessage> {
    @Override
    public View newView(Context context, ViewGroup group) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_item_combine_message, null);
        ViewHolder holder = new ViewHolder();
        holder.message = (LinearLayout)view.findViewById(R.id.rc_message);
        holder.title = (TextView)view.findViewById(R.id.title);
        holder.summary = (TextView)view.findViewById(R.id.summary);
        view.setTag((Object)holder);
        return view;
    }

    @Override
    public void bindView(View v, int position, CombineMessage content, UIMessage message) {
        ViewHolder holder = (ViewHolder)v.getTag();
        if (message.getMessageDirection() == Message.MessageDirection.SEND) {
            holder.message.setBackgroundResource(R.drawable.rc_ic_bubble_right);
        } else {
            holder.message.setBackgroundResource(R.drawable.rc_ic_bubble_left);
        }
        String title = this.getTitle(content);
        content.setTitle(title);
        holder.title.setText((CharSequence)content.getTitle());
        StringBuilder summary = new StringBuilder();
        List<String> summarys = content.getSummaryList();
        for (int i = 0; i < summarys.size() && i < 4; ++i) {
            if (i == 0) {
                summary = new StringBuilder(summarys.get(i));
                continue;
            }
            summary.append("\n").append(summarys.get(i));
        }
        holder.summary.setText((CharSequence)summary.toString());
    }

    private String getTitle(CombineMessage content) {
        String title = "";
        Context context = RongIM.getInstance().getApplicationContext();
        if (Conversation.ConversationType.GROUP.equals((Object)content.getConversationType())) {
            title = context.getString(R.string.rc_combine_group_chat);
        } else {
            List<String> nameList = content.getNameList();
            if (nameList == null) {
                return title;
            }
            if (nameList.size() == 1) {
                title = String.format(context.getString(R.string.rc_combine_the_group_chat_of), nameList.get(0));
            } else if (nameList.size() == 2) {
                title = String.format(context.getString(R.string.rc_combine_the_group_chat_of), nameList.get(0) + " " + context.getString(R.string.rc_combine_and) + " " + nameList.get(1));
            }
        }
        if (TextUtils.isEmpty((CharSequence)title)) {
            title = context.getString(R.string.rc_combine_chat_history);
        }
        return title;
    }

    @Override
    public Spannable getContentSummary(CombineMessage data) {
        return null;
    }

    @Override
    public Spannable getContentSummary(Context context, CombineMessage data) {
        return new SpannableString((CharSequence)context.getString(R.string.rc_message_content_combine));
    }

    @Override
    public void onItemClick(View view, int position, CombineMessage content, UIMessage message) {
        String type = "local";
        Uri uri = content.getLocalPath();
        if (!(uri != null && new File(uri.toString().substring(7)).exists() || content.getMediaUrl() == null)) {
            String filePath = CombineMessageUtils.getInstance().getCombineFilePath(content.getMediaUrl().toString());
            if (new File(filePath).exists()) {
                uri = Uri.parse((String)("file://" + filePath));
            } else {
                uri = content.getMediaUrl();
                type = "media";
            }
        }
        if (uri == null) {
            Context context = view.getContext();
            new AlertDialog.Builder(context).setMessage((CharSequence)context.getString(R.string.rc_combine_history_deleted)).setPositiveButton((CharSequence)context.getString(R.string.rc_dialog_ok), null).show();
            return;
        }
        Intent intent = new Intent("io.rong.imkit.intent.action.combinewebview");
        intent.setPackage(view.getContext().getPackageName());
        intent.addFlags(0x10000000);
        intent.putExtra("messageId", message.getMessageId());
        intent.putExtra("uri", uri.toString());
        intent.putExtra("type", type);
        intent.putExtra("title", content.getTitle());
        view.getContext().startActivity(intent);
    }

    private static class ViewHolder {
        LinearLayout message;
        TextView title;
        TextView summary;

        private ViewHolder() {
        }
    }
}

