/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.rong.imkit.R;
import io.rong.imkit.activity.CSLeaveMessageActivity;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.CustomServiceConfig;
import io.rong.message.CSPullLeaveMessage;

@ProviderTag(messageContent=CSPullLeaveMessage.class, showPortrait=false, showProgress=false, showWarning=false, centerInHorizontal=true, showSummaryWithName=false)
public class CSPullLeaveMsgItemProvider
extends IContainerItemProvider.MessageProvider<CSPullLeaveMessage> {
    @Override
    public void bindView(View v, int position, CSPullLeaveMessage csPullLeaveMessage, final UIMessage message) {
        String content;
        ViewHolder viewHolder = (ViewHolder)v.getTag();
        if (csPullLeaveMessage != null && !TextUtils.isEmpty((CharSequence)(content = csPullLeaveMessage.getContent()))) {
            SpannableStringBuilder builder = new SpannableStringBuilder();
            String filter = v.getResources().getString(R.string.rc_cs_leave_message);
            int startPos = content.indexOf(filter);
            if (startPos >= 0) {
                SpannableString filterString = new SpannableString((CharSequence)content.substring(startPos, startPos + filter.length()));
                filterString.setSpan((Object)new ForegroundColorSpan(v.getContext().getResources().getColor(R.color.rc_voice_color)), 0, filterString.length(), 33);
                filterString.setSpan((Object)new Clickable(new View.OnClickListener(){

                    public void onClick(View v) {
                        CSPullLeaveMsgItemProvider.this.onLeaveMessageClicked(v, message);
                    }
                }), 0, filterString.length(), 17);
                String preText = content.substring(0, startPos);
                String endText = content.substring(startPos + filter.length());
                if (!preText.endsWith(" ")) {
                    builder.append((CharSequence)preText).append((CharSequence)" ").append((CharSequence)filterString).append((CharSequence)endText);
                } else {
                    builder.append((CharSequence)preText).append((CharSequence)filterString).append((CharSequence)endText);
                }
            } else {
                builder.append((CharSequence)content);
            }
            viewHolder.contentTextView.setText((CharSequence)builder);
        }
    }

    private void onLeaveMessageClicked(View v, UIMessage message) {
        if (message.getCsConfig() != null && message.getCsConfig().leaveMessageConfigType.equals((Object)CustomServiceConfig.CSLeaveMessageType.WEB)) {
            String action = "io.rong.imkit.intent.action.webview";
            Intent intent = new Intent(action);
            intent.setPackage(v.getContext().getPackageName());
            intent.addFlags(0x10000000);
            if (message.getCsConfig().uri != null) {
                intent.putExtra("url", message.getCsConfig().uri.toString());
            }
            v.getContext().startActivity(intent);
        } else if (message.getCsConfig() != null) {
            Intent intent = new Intent(v.getContext(), CSLeaveMessageActivity.class);
            intent.putExtra("targetId", message.getTargetId());
            Bundle bundle = new Bundle();
            bundle.putParcelableArrayList("itemList", message.getCsConfig().leaveMessageNativeInfo);
            intent.putExtras(bundle);
            v.getContext().startActivity(intent);
        }
    }

    @Override
    public Spannable getContentSummary(CSPullLeaveMessage data) {
        return null;
    }

    @Override
    public void onItemClick(View view, int position, CSPullLeaveMessage content, UIMessage message) {
    }

    @Override
    public void onItemLongClick(View view, int position, CSPullLeaveMessage content, UIMessage message) {
    }

    @Override
    public View newView(Context context, ViewGroup group) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_item_information_notification_message, null);
        ViewHolder viewHolder = new ViewHolder();
        viewHolder.contentTextView = (TextView)view.findViewById(R.id.rc_msg);
        viewHolder.contentTextView.setMovementMethod(LinkMovementMethod.getInstance());
        view.setTag((Object)viewHolder);
        return view;
    }

    class Clickable
    extends ClickableSpan
    implements View.OnClickListener {
        private final View.OnClickListener mListener;

        public Clickable(View.OnClickListener listener) {
            this.mListener = listener;
        }

        public void onClick(View view) {
            this.mListener.onClick(view);
        }
    }

    private static class ViewHolder {
        TextView contentTextView;

        private ViewHolder() {
        }
    }
}

