/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.model.ConversationProviderTag;
import io.rong.imkit.model.UIConversation;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imkit.widget.ProviderContainerView;
import io.rong.imkit.widget.adapter.ConversationListAdapter;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.model.Conversation;

public class SubConversationListAdapter
extends ConversationListAdapter {
    private LayoutInflater mInflater;
    private Context mContext;

    @Override
    public long getItemId(int position) {
        UIConversation conversation = (UIConversation)this.getItem(position);
        if (conversation == null) {
            return 0L;
        }
        return conversation.hashCode();
    }

    public SubConversationListAdapter(Context context) {
        super(context);
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)this.mContext);
    }

    @Override
    protected View newView(Context context, int position, ViewGroup group) {
        View result = this.mInflater.inflate(R.layout.rc_item_conversation, group, false);
        ViewHolder holder = new ViewHolder();
        holder.layout = this.findViewById(result, R.id.rc_item_conversation);
        holder.leftImageLayout = this.findViewById(result, R.id.rc_item1);
        holder.rightImageLayout = this.findViewById(result, R.id.rc_item2);
        holder.leftUnReadView = this.findViewById(result, R.id.rc_unread_view_left);
        holder.rightUnReadView = this.findViewById(result, R.id.rc_unread_view_right);
        holder.leftImageView = (AsyncImageView)((Object)this.findViewById(result, R.id.rc_left));
        holder.rightImageView = (AsyncImageView)((Object)this.findViewById(result, R.id.rc_right));
        holder.contentView = (ProviderContainerView)((Object)this.findViewById(result, R.id.rc_content));
        holder.unReadMsgCount = (TextView)this.findViewById(result, R.id.rc_unread_message);
        holder.unReadMsgCountRight = (TextView)this.findViewById(result, R.id.rc_unread_message_right);
        holder.unReadMsgCountIcon = (ImageView)this.findViewById(result, R.id.rc_unread_message_icon);
        holder.unReadMsgCountRightIcon = (ImageView)this.findViewById(result, R.id.rc_unread_message_icon_right);
        result.setTag((Object)holder);
        return result;
    }

    @Override
    protected void bindView(View v, int position, UIConversation data) {
        ViewHolder holder = (ViewHolder)v.getTag();
        IContainerItemProvider.ConversationProvider provider = RongContext.getInstance().getConversationTemplate(data.getConversationType().getName());
        View view = holder.contentView.inflate(provider);
        provider.bindView(view, position, data);
        if (data.isTop()) {
            holder.layout.setBackgroundColor(this.mContext.getResources().getColor(R.color.rc_conversation_top_bg));
        } else {
            holder.layout.setBackgroundColor(this.mContext.getResources().getColor(R.color.rc_text_color_primary_inverse));
        }
        ConversationProviderTag tag = RongContext.getInstance().getConversationProviderTag(data.getConversationType().getName());
        int defaultId = data.getConversationType() == Conversation.ConversationType.GROUP ? R.drawable.rc_default_group_portrait : (data.getConversationType() == Conversation.ConversationType.DISCUSSION ? R.drawable.rc_default_discussion_portrait : R.drawable.rc_default_portrait);
        if (tag.portraitPosition() == 1) {
            holder.leftImageLayout.setVisibility(0);
            if (data.getIconUrl() != null) {
                holder.leftImageView.setAvatar(data.getIconUrl().toString(), defaultId);
            } else {
                holder.leftImageView.setAvatar(null, defaultId);
            }
            if (data.getUnReadMessageCount() > 0) {
                holder.unReadMsgCountIcon.setVisibility(0);
                this.setUnReadViewLayoutParams(holder.leftUnReadView, data.getUnReadType());
                if (data.getUnReadType().equals((Object)UIConversation.UnreadRemindType.REMIND_WITH_COUNTING)) {
                    holder.unReadMsgCount.setVisibility(0);
                    if (data.getUnReadMessageCount() > 99) {
                        holder.unReadMsgCount.setText((CharSequence)this.mContext.getResources().getString(R.string.rc_message_unread_count));
                    } else {
                        holder.unReadMsgCount.setText((CharSequence)Integer.toString(data.getUnReadMessageCount()));
                    }
                    holder.unReadMsgCountIcon.setImageResource(R.drawable.rc_unread_count_bg);
                } else {
                    holder.unReadMsgCount.setVisibility(8);
                    holder.unReadMsgCountIcon.setImageResource(R.drawable.rc_unread_remind_without_count);
                }
            } else {
                holder.unReadMsgCountIcon.setVisibility(8);
                holder.unReadMsgCount.setVisibility(8);
            }
            holder.rightImageLayout.setVisibility(8);
        } else if (tag.portraitPosition() == 2) {
            holder.rightImageLayout.setVisibility(0);
            if (data.getIconUrl() != null) {
                holder.rightImageView.setAvatar(data.getIconUrl().toString(), defaultId);
            } else {
                holder.rightImageView.setAvatar(null, defaultId);
            }
            if (data.getUnReadMessageCount() > 0) {
                holder.unReadMsgCountRight.setVisibility(0);
                holder.unReadMsgCountIcon.setVisibility(0);
                this.setUnReadViewLayoutParams(holder.rightUnReadView, data.getUnReadType());
                if (data.getUnReadType().equals((Object)UIConversation.UnreadRemindType.REMIND_WITH_COUNTING)) {
                    if (data.getUnReadMessageCount() > 99) {
                        holder.unReadMsgCountRight.setText((CharSequence)this.mContext.getResources().getString(R.string.rc_message_unread_count));
                    } else {
                        holder.unReadMsgCountRight.setText((CharSequence)Integer.toString(data.getUnReadMessageCount()));
                    }
                    holder.unReadMsgCountIcon.setImageResource(R.drawable.rc_unread_count_bg);
                } else {
                    holder.unReadMsgCountIcon.setImageResource(R.drawable.rc_unread_remind_without_count);
                }
            }
            holder.leftImageLayout.setVisibility(8);
        } else if (tag.portraitPosition() == 3) {
            holder.rightImageLayout.setVisibility(8);
            holder.leftImageLayout.setVisibility(8);
        } else {
            throw new IllegalArgumentException("the portrait position is wrong!");
        }
    }

    class ViewHolder {
        View layout;
        View leftImageLayout;
        View rightImageLayout;
        View leftUnReadView;
        View rightUnReadView;
        AsyncImageView leftImageView;
        AsyncImageView rightImageView;
        ProviderContainerView contentView;
        TextView unReadMsgCount;
        TextView unReadMsgCountRight;
        ImageView unReadMsgCountRightIcon;
        ImageView unReadMsgCountIcon;

        ViewHolder() {
        }
    }
}

