/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.support.v4.widget.SwipeRefreshLayout;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.AbsListView;
import android.widget.ListView;
import io.rong.imkit.R;

public class RongSwipeRefreshLayout
extends SwipeRefreshLayout {
    private int mScaledTouchSlop;
    private View mFooterView;
    private ListView mListView;
    private OnLoadListener mOnLoadListener;
    private OnFlushListener mFlushListener;
    public boolean isRefreshFinish;
    public boolean isLoadMoreFinish;
    private boolean condition4 = false;
    private boolean condition5 = false;
    private boolean loadMoreEnabled = true;
    private boolean refreshEnabled = true;
    private boolean autoLoading;
    private float mDownY;
    private float mUpY;

    public RongSwipeRefreshLayout(Context context) {
        this(context, null);
    }

    public RongSwipeRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        this.mFooterView = View.inflate((Context)context, (int)R.layout.view_footer, null);
        this.mScaledTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mListView == null) {
            if (this.getChildCount() > 0 && this.getChildAt(0) instanceof ListView) {
                this.mListView = (ListView)this.getChildAt(0);
                this.setListViewOnScroll();
            }
            this.setOnRefresh();
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.mDownY = ev.getY();
                break;
            }
            case 2: {
                this.mUpY = ev.getY();
                if (!this.canLoadMore() || this.autoLoading) break;
                this.loadData();
                break;
            }
        }
        if (this.refreshEnabled) {
            if (this.isLoadMoreFinish) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private boolean canLoadMore() {
        boolean condition1 = this.mDownY - this.mUpY >= (float)this.mScaledTouchSlop;
        boolean condition2 = !this.isLoadMoreFinish;
        boolean condition3 = !this.isRefreshFinish;
        return condition1 && condition2 && condition3 && this.condition4 && this.condition5 && this.loadMoreEnabled;
    }

    private void loadData() {
        this.setLoadMoreFinish(true);
        if (this.mOnLoadListener != null) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    RongSwipeRefreshLayout.this.mOnLoadListener.onLoad();
                }
            }, 3000L);
        } else {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    RongSwipeRefreshLayout.this.setLoadMoreFinish(false);
                }
            }, 2000L);
        }
    }

    public void setAutoLoading(boolean autoLoading) {
        this.autoLoading = autoLoading;
    }

    public void setRefreshing(boolean flushing) {
        this.isRefreshFinish = flushing;
        super.setRefreshing(flushing);
    }

    public void setLoadMoreFinish(boolean loading) {
        this.isLoadMoreFinish = loading;
        if (this.isLoadMoreFinish) {
            if (this.mListView != null) {
                this.mListView.addFooterView(this.mFooterView);
                if (Build.VERSION.SDK_INT < 19) {
                    this.mListView.setAdapter(this.mListView.getAdapter());
                }
                if (this.mListView.getAdapter() != null) {
                    this.mListView.smoothScrollToPosition(this.mListView.getAdapter().getCount() - 1);
                }
            }
        } else {
            if (this.mListView != null && this.mListView.getFooterViewsCount() > 0) {
                this.mListView.removeFooterView(this.mFooterView);
            }
            this.mDownY = 0.0f;
            this.mUpY = 0.0f;
        }
    }

    private void setListViewOnScroll() {
        this.mListView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                if (RongSwipeRefreshLayout.this.canLoadMore() && RongSwipeRefreshLayout.this.autoLoading) {
                    RongSwipeRefreshLayout.this.loadData();
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                View lastVisibleItemView;
                RongSwipeRefreshLayout.this.condition4 = false;
                RongSwipeRefreshLayout.this.condition5 = false;
                if (firstVisibleItem + visibleItemCount == totalItemCount && (lastVisibleItemView = RongSwipeRefreshLayout.this.mListView.getChildAt(RongSwipeRefreshLayout.this.mListView.getChildCount() - 1)) != null && lastVisibleItemView.getBottom() == RongSwipeRefreshLayout.this.mListView.getHeight()) {
                    RongSwipeRefreshLayout.this.condition4 = true;
                }
                if (totalItemCount > visibleItemCount) {
                    RongSwipeRefreshLayout.this.condition5 = true;
                }
            }
        });
    }

    private void setOnRefresh() {
        if (!this.isLoadMoreFinish) {
            this.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

                public void onRefresh() {
                    RongSwipeRefreshLayout.this.setRefreshing(true);
                    if (RongSwipeRefreshLayout.this.mFlushListener != null) {
                        RongSwipeRefreshLayout.this.mFlushListener.onFlush();
                    } else {
                        new Handler().postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                RongSwipeRefreshLayout.this.setRefreshing(false);
                            }
                        }, 2000L);
                    }
                }
            });
        } else {
            this.setRefreshing(false);
        }
    }

    public void setCanRefresh(boolean enabled) {
        this.refreshEnabled = enabled;
        this.setEnabled(enabled);
    }

    public void setCanLoading(boolean enabled) {
        this.loadMoreEnabled = enabled;
    }

    public void setOnLoadListener(OnLoadListener listener) {
        this.mOnLoadListener = listener;
    }

    public void setOnFlushListener(OnFlushListener listener) {
        this.mFlushListener = listener;
    }

    public static interface OnFlushListener {
        public void onFlush();
    }

    public static interface OnLoadListener {
        public void onLoad();
    }
}

