/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ProviderContainerView
extends FrameLayout {
    Map<Class<? extends IContainerItemProvider>, AtomicInteger> mViewCounterMap;
    Map<Class<? extends IContainerItemProvider>, View> mContentViewMap;
    View mInflateView;
    int mMaxContainSize = 3;

    public ProviderContainerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!this.isInEditMode()) {
            this.init(attrs);
        }
    }

    private void init(AttributeSet attrs) {
        this.mViewCounterMap = new HashMap<Class<? extends IContainerItemProvider>, AtomicInteger>();
        this.mContentViewMap = new HashMap<Class<? extends IContainerItemProvider>, View>();
    }

    public <T extends IContainerItemProvider> View inflate(T t) {
        View result = null;
        if (this.mInflateView != null) {
            this.mInflateView.setVisibility(8);
        }
        if (this.mContentViewMap.containsKey(t.getClass())) {
            this.mInflateView = result = this.mContentViewMap.get(t.getClass());
            AtomicInteger atomicInteger = this.mViewCounterMap.get(t.getClass());
            if (atomicInteger != null) {
                atomicInteger.incrementAndGet();
            }
        }
        if (result != null) {
            if (result.getVisibility() == 8) {
                result.setVisibility(0);
            }
            return result;
        }
        this.recycle();
        result = t.newView(this.getContext(), (ViewGroup)this);
        if (result != null) {
            super.addView(result);
            this.mContentViewMap.put(t.getClass(), result);
            this.mViewCounterMap.put(t.getClass(), new AtomicInteger());
        }
        this.mInflateView = result;
        return result;
    }

    public View getCurrentInflateView() {
        return this.mInflateView;
    }

    public void containerViewLeft() {
        if (this.mInflateView == null) {
            return;
        }
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mInflateView.getLayoutParams();
        params.gravity = 19;
    }

    public void containerViewRight() {
        if (this.mInflateView == null) {
            return;
        }
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mInflateView.getLayoutParams();
        params.gravity = 21;
    }

    public void containerViewCenter() {
        if (this.mInflateView == null) {
            return;
        }
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mInflateView.getLayoutParams();
        params.gravity = 17;
    }

    private void recycle() {
        if (this.mInflateView == null) {
            return;
        }
        int count = this.getChildCount();
        if (count >= this.mMaxContainSize) {
            Map.Entry<Class<? extends IContainerItemProvider>, AtomicInteger> min = null;
            for (Map.Entry<Class<? extends IContainerItemProvider>, AtomicInteger> item : this.mViewCounterMap.entrySet()) {
                if (min == null) {
                    min = item;
                }
                min = min.getValue().get() > item.getValue().get() ? item : min;
            }
            if (min == null) {
                return;
            }
            this.mViewCounterMap.remove(min.getKey());
            View view = this.mContentViewMap.remove(min.getKey());
            this.removeView(view);
        }
    }
}

