/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.actions.IClickActions;
import io.rong.imkit.fragment.ConversationFragment;
import io.rong.imkit.utils.ForwardManager;
import io.rong.imkit.widget.BottomMenuDialog;
import io.rong.imlib.model.Message;
import java.util.ArrayList;
import java.util.List;

public class ForwardClickActions
implements IClickActions {
    private static final String TAG = ForwardClickActions.class.getSimpleName();
    private BottomMenuDialog dialog;

    @Override
    public Drawable obtainDrawable(Context context) {
        return context.getResources().getDrawable(R.drawable.rc_selector_multi_forward);
    }

    @Override
    public void onClick(final Fragment fragment) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null || activity.isFinishing()) {
            RLog.e((String)TAG, (String)"onClick activity is null or finishing.");
            return;
        }
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
        }
        this.dialog = new BottomMenuDialog((Context)activity);
        this.dialog.setConfirmListener(new View.OnClickListener(){

            @TargetApi(value=23)
            public void onClick(View arg0) {
                if (ForwardClickActions.this.dialog != null) {
                    ForwardClickActions.this.dialog.dismiss();
                }
                ForwardClickActions.this.startSelectConversationActivity(fragment, 0);
            }
        });
        this.dialog.setMiddleListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                if (ForwardClickActions.this.dialog != null) {
                    ForwardClickActions.this.dialog.dismiss();
                }
                ForwardClickActions.this.startSelectConversationActivity(fragment, 1);
            }
        });
        this.dialog.setCancelListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ForwardClickActions.this.dialog != null) {
                    ForwardClickActions.this.dialog.dismiss();
                }
            }
        });
        this.dialog.show();
    }

    private void startSelectConversationActivity(Fragment pFragment, int index) {
        ConversationFragment fragment = (ConversationFragment)pFragment;
        List<Message> messages = ForwardManager.filterMessagesList(fragment.getContext(), fragment.getCheckedMessages(), index);
        if (messages.size() == 0) {
            RLog.e((String)TAG, (String)"startSelectConversationActivity the size of messages is 0!");
            return;
        }
        ArrayList<Integer> messageIds = new ArrayList<Integer>();
        for (Message msg : messages) {
            messageIds.add(msg.getMessageId());
        }
        Intent intent = fragment.getSelectIntentForForward();
        intent.putExtra("index", index);
        intent.putIntegerArrayListExtra("messageIds", messageIds);
        fragment.startActivityForResult(intent, 104);
    }
}

