/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.text.Layout;
import android.text.Spannable;
import android.text.TextPaint;
import android.text.style.URLSpan;
import android.util.AttributeSet;
import android.widget.TextView;
import io.rong.imkit.R;

public class AutoLinkTextView
extends TextView {
    private int mMaxWidth;

    public AutoLinkTextView(Context context) {
        super(context);
    }

    public AutoLinkTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initWidth(context, attrs);
        this.setAutoLinkMask(7);
    }

    public AutoLinkTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initWidth(context, attrs);
        this.setAutoLinkMask(7);
    }

    @TargetApi(value=21)
    public AutoLinkTextView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initWidth(context, attrs);
        this.setAutoLinkMask(7);
    }

    private void initWidth(Context context, AttributeSet attrs) {
        TypedArray array2 = context.obtainStyledAttributes(attrs, R.styleable.AutoLinkTextView);
        this.mMaxWidth = array2.getDimensionPixelSize(R.styleable.AutoLinkTextView_RCMaxWidth, 0);
        this.setMaxWidth(this.mMaxWidth);
        array2.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        Layout layout2 = this.getLayout();
        float width = 0.0f;
        for (int i = 0; i < layout2.getLineCount(); ++i) {
            width = Math.max(width, layout2.getLineWidth(i));
        }
        width += (float)(this.getCompoundPaddingLeft() + this.getCompoundPaddingRight());
        if (this.getBackground() != null) {
            width = Math.max(width, (float)this.getBackground().getIntrinsicWidth());
        }
        if (this.mMaxWidth != 0) {
            width = Math.min(width, (float)this.mMaxWidth);
        }
        this.setMeasuredDimension((int)Math.ceil(width), this.getMeasuredHeight());
    }

    public void stripUnderlines() {
        AutoLinkTextView textView = this;
        if (textView.getText() instanceof Spannable) {
            URLSpan[] spans;
            Spannable s = (Spannable)textView.getText();
            for (URLSpan span : spans = (URLSpan[])s.getSpans(0, s.length(), URLSpan.class)) {
                int start = s.getSpanStart((Object)span);
                int end = s.getSpanEnd((Object)span);
                s.removeSpan((Object)span);
                span = new URLSpanNoUnderline(span.getURL());
                s.setSpan((Object)span, start, end, 0);
            }
        }
    }

    public static class URLSpanNoUnderline
    extends URLSpan {
        public URLSpanNoUnderline(String url) {
            super(url);
        }

        public void updateDrawState(@NonNull TextPaint ds) {
            super.updateDrawState(ds);
            ds.setUnderlineText(false);
        }
    }
}

