/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.voiceMessageDownload;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.imkit.RongIM;
import io.rong.imkit.utilities.PermissionCheckUtil;
import io.rong.imkit.voiceMessageDownload.AutoDownloadEntry;
import io.rong.imkit.voiceMessageDownload.AutoDownloadNetWorkChangeReceiver;
import io.rong.imkit.voiceMessageDownload.AutoDownloadQueue;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.common.NetUtils;
import io.rong.imlib.model.Message;
import io.rong.message.HQVoiceMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class HQVoiceMsgDownloadManager {
    private static final String TAG = HQVoiceMsgDownloadManager.class.getSimpleName();
    private Context mContext;
    private final AutoDownloadQueue autoDownloadQueue = new AutoDownloadQueue();
    private ExecutorService executorService;
    private static final int REQUEST_MSG_DOWNLOAD_PERMISSION = 1001;
    private Future<?> future = null;
    private List<AutoDownloadEntry> errorList = null;

    private HQVoiceMsgDownloadManager() {
    }

    public void init(Context context) {
        AutoDownloadNetWorkChangeReceiver autoDownloadNetWorkChangeReceiver = new AutoDownloadNetWorkChangeReceiver();
        this.mContext = context.getApplicationContext();
        this.executorService = Executors.newSingleThreadExecutor();
        this.errorList = new ArrayList<AutoDownloadEntry>();
        try {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            context.getApplicationContext().registerReceiver((BroadcastReceiver)autoDownloadNetWorkChangeReceiver, intentFilter);
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)"registerReceiver Exception", (Throwable)e);
        }
        this.downloadHQVoiceMessage();
    }

    public static HQVoiceMsgDownloadManager getInstance() {
        return HQVoiceMsgDownloadManagerHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Fragment fragment, AutoDownloadEntry autoDownloadEntry) {
        HQVoiceMessage hqVoiceMessage;
        if (autoDownloadEntry == null) {
            return;
        }
        Message message = autoDownloadEntry.getMessage();
        if (!(message.getContent() instanceof HQVoiceMessage) || this.ifMsgInHashMap(message) && fragment != null) {
            return;
        }
        String[] permission2 = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
        if (fragment != null && fragment.isAdded() && !PermissionCheckUtil.checkPermissions((Context)fragment.getActivity(), permission2)) {
            PermissionCheckUtil.requestPermissions(fragment, permission2, 1001);
        }
        if ((hqVoiceMessage = (HQVoiceMessage)message.getContent()).getLocalPath() != null && !TextUtils.isEmpty((CharSequence)hqVoiceMessage.getLocalPath().toString())) {
            return;
        }
        AutoDownloadQueue autoDownloadQueue = this.autoDownloadQueue;
        synchronized (autoDownloadQueue) {
            boolean isEmpty = this.autoDownloadQueue.isEmpty();
            this.autoDownloadQueue.enqueue(autoDownloadEntry);
            if (isEmpty) {
                this.autoDownloadQueue.notify();
            }
            if (this.future.isDone() && NetUtils.isNetWorkAvailable((Context)this.mContext)) {
                this.downloadHQVoiceMessage();
            }
        }
    }

    private void enqueue(AutoDownloadEntry autoDownloadEntry) {
        this.enqueue(null, autoDownloadEntry);
    }

    private Message dequeue() {
        return this.autoDownloadQueue.dequeue();
    }

    private void removeUidInHashMap(String uid) {
        this.autoDownloadQueue.getAutoDownloadEntryHashMap().remove(uid);
    }

    private boolean ifMsgInHashMap(Message message) {
        return this.autoDownloadQueue.ifMsgInHashMap(message);
    }

    private AutoDownloadEntry getMsgEntry(Message message) {
        if (message == null) {
            return null;
        }
        AutoDownloadEntry autoDownloadEntry = null;
        if (this.autoDownloadQueue.getAutoDownloadEntryHashMap().containsKey(message.getUId())) {
            autoDownloadEntry = this.autoDownloadQueue.getAutoDownloadEntryHashMap().get(message.getUId());
        }
        return autoDownloadEntry;
    }

    private void downloadHQVoiceMessage() {
        this.future = this.executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    AutoDownloadQueue autoDownloadQueue = HQVoiceMsgDownloadManager.this.autoDownloadQueue;
                    synchronized (autoDownloadQueue) {
                        if (HQVoiceMsgDownloadManager.this.autoDownloadQueue.isEmpty()) {
                            try {
                                HQVoiceMsgDownloadManager.this.autoDownloadQueue.wait();
                            }
                            catch (InterruptedException e) {
                                RLog.e((String)TAG, (String)("downloadHQVoiceMessage e:" + e.toString()));
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                    Message message = HQVoiceMsgDownloadManager.this.dequeue();
                    RongIM.getInstance().downloadMediaMessage(message, new IRongCallback.IDownloadMediaMessageCallback(){

                        public void onSuccess(Message message) {
                            RLog.d((String)TAG, (String)"downloadMediaMessage success");
                            if (HQVoiceMsgDownloadManager.this.errorList != null) {
                                HQVoiceMsgDownloadManager.this.errorList.remove(HQVoiceMsgDownloadManager.this.getMsgEntry(message));
                            }
                            HQVoiceMsgDownloadManager.this.removeUidInHashMap(message.getUId());
                        }

                        public void onProgress(Message message, int progress) {
                            RLog.d((String)TAG, (String)"downloadMediaMessage onProgress");
                        }

                        public void onError(Message message, RongIMClient.ErrorCode code) {
                            if (HQVoiceMsgDownloadManager.this.errorList != null && !HQVoiceMsgDownloadManager.this.errorList.contains(HQVoiceMsgDownloadManager.this.getMsgEntry(message))) {
                                HQVoiceMsgDownloadManager.this.errorList.add(HQVoiceMsgDownloadManager.this.getMsgEntry(message));
                                RLog.i((String)TAG, (String)("onError = " + code.getValue() + " errorList size = " + HQVoiceMsgDownloadManager.this.errorList.size()));
                            }
                        }

                        public void onCanceled(Message message) {
                        }
                    });
                }
            }
        });
    }

    void pauseDownloadService() {
    }

    public void resumeDownloadService() {
        if (this.errorList == null || this.errorList.size() == 0) {
            return;
        }
        if (this.future.isDone() && NetUtils.isNetWorkAvailable((Context)this.mContext)) {
            this.downloadHQVoiceMessage();
        }
        for (int i = this.errorList.size() - 1; i >= 0; --i) {
            this.enqueue(this.errorList.get(i));
        }
    }

    private static class HQVoiceMsgDownloadManagerHolder {
        @SuppressLint(value={"StaticFieldLeak"})
        private static HQVoiceMsgDownloadManager instance = new HQVoiceMsgDownloadManager();

        private HQVoiceMsgDownloadManagerHolder() {
        }
    }
}

