/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.voiceMessageDownload;

import io.rong.imkit.voiceMessageDownload.AutoDownloadEntry;
import io.rong.imlib.model.Message;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

class AutoDownloadQueue {
    private ConcurrentLinkedQueue<AutoDownloadEntry> highPriority = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<AutoDownloadEntry> normalPriority = new ConcurrentLinkedQueue();
    private HashMap<String, AutoDownloadEntry> autoDownloadEntryHashMap = new HashMap();
    private static final int MAX_QUEUE_COUNT = 100;

    AutoDownloadQueue() {
    }

    void enqueue(AutoDownloadEntry autoDownloadEntry) {
        int doubleQueueSize;
        Message message = autoDownloadEntry.getMessage();
        if (autoDownloadEntry.getPriority() == AutoDownloadEntry.DownloadPriority.NORMAL) {
            this.normalPriority.add(autoDownloadEntry);
        } else if (autoDownloadEntry.getPriority() == AutoDownloadEntry.DownloadPriority.HIGH) {
            this.highPriority.add(autoDownloadEntry);
        }
        if (!this.autoDownloadEntryHashMap.containsKey(message.getUId())) {
            this.autoDownloadEntryHashMap.put(message.getUId(), autoDownloadEntry);
        }
        if ((doubleQueueSize = this.normalPriority.size() + this.highPriority.size()) > 100) {
            if (!this.normalPriority.isEmpty()) {
                this.autoDownloadEntryHashMap.remove(this.normalPriority.poll().getMessage().getUId());
            } else {
                AutoDownloadEntry highItem = this.highPriority.poll();
                if (highItem != null) {
                    this.autoDownloadEntryHashMap.remove(highItem.getMessage().getUId());
                }
            }
        }
    }

    boolean ifMsgInHashMap(Message message) {
        return this.autoDownloadEntryHashMap.containsKey(message.getUId());
    }

    Message dequeue() {
        if (!this.highPriority.isEmpty()) {
            return this.highPriority.poll().getMessage();
        }
        if (!this.normalPriority.isEmpty()) {
            return this.normalPriority.poll().getMessage();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.highPriority.isEmpty() && this.normalPriority.isEmpty();
    }

    HashMap<String, AutoDownloadEntry> getAutoDownloadEntryHashMap() {
        return this.autoDownloadEntryHashMap;
    }
}

