/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import android.content.Context;
import io.rong.imkit.R;
import io.rong.imkit.RongIM;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeUtils {
    public static String formatData(long timeMillis) {
        Context context = RongIM.getInstance().getApplicationContext();
        if (context == null || timeMillis == 0L) {
            return "";
        }
        int targetDay = (int)(timeMillis / 86400000L);
        int nowDay = (int)(System.currentTimeMillis() / 86400000L);
        String result = targetDay == nowDay ? TimeUtils.formatDate(timeMillis, "HH:mm") : (targetDay + 1 == nowDay ? context.getResources().getString(R.string.rc_yesterday_format) : TimeUtils.formatDate(timeMillis, "yyyy-MM-dd"));
        return result;
    }

    public static String formatTime(long timeMillis) {
        Context context = RongIM.getInstance().getApplicationContext();
        if (context == null || timeMillis == 0L) {
            return "";
        }
        int targetDay = (int)(timeMillis / 86400000L);
        int nowDay = (int)(System.currentTimeMillis() / 86400000L);
        String result = targetDay == nowDay ? TimeUtils.formatDate(timeMillis, "HH:mm") : (targetDay + 1 == nowDay ? context.getResources().getString(R.string.rc_yesterday_format) : TimeUtils.formatDate(timeMillis, "yyyy-MM-dd HH:mm"));
        return result;
    }

    private static String formatDate(long timeMillis, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(timeMillis));
    }
}

