/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.URLSpan;
import android.text.util.Linkify;
import io.rong.imkit.emoticon.AndroidEmoji;
import io.rong.imkit.widget.AutoLinkTextView;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class TextViewUtils {
    private static final int CONTENT_LIMIT_LENGTH = 150;
    private static RegularExecutor regularExecutor = new RegularExecutor();

    public static SpannableStringBuilder getSpannable(String content, final RegularCallBack callBack) {
        if (content == null) {
            return new SpannableStringBuilder((CharSequence)"");
        }
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)content);
        final SpannableStringBuilder emojiSpannable = AndroidEmoji.replaceEmojiWithText((Spannable)spannable);
        AndroidEmoji.ensure((Spannable)emojiSpannable);
        if (spannable.length() < 150) {
            TextViewUtils.regularContent(emojiSpannable);
        } else {
            regularExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    TextViewUtils.regularContent(emojiSpannable);
                    callBack.finish(emojiSpannable);
                }
            });
        }
        return emojiSpannable;
    }

    private static void regularContent(SpannableStringBuilder spannable) {
        URLSpan[] spans;
        Linkify.addLinks((Spannable)spannable, (int)7);
        for (URLSpan span : spans = (URLSpan[])spannable.getSpans(0, spannable.length(), URLSpan.class)) {
            int start = spannable.getSpanStart((Object)span);
            int end = spannable.getSpanEnd((Object)span);
            spannable.removeSpan((Object)span);
            span = new AutoLinkTextView.URLSpanNoUnderline(span.getURL());
            spannable.setSpan((Object)span, start, end, 0);
        }
    }

    public static interface RegularCallBack {
        public void finish(SpannableStringBuilder var1);
    }

    private static class RegularExecutor
    implements Executor {
        private final Executor mCompressExecutor = Executors.newCachedThreadPool();

        @Override
        public void execute(Runnable command) {
            this.mCompressExecutor.execute(command);
        }
    }
}

