/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import android.content.Context;
import io.rong.common.utils.SSLUtils;
import io.rong.imageloader.core.assist.ContentLengthInputStream;
import io.rong.imageloader.core.download.BaseImageDownloader;
import io.rong.imageloader.utils.IoUtils;
import io.rong.imlib.common.NetUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class RongAuthImageDownloader
extends BaseImageDownloader {
    private static final String TAG = RongAuthImageDownloader.class.getSimpleName();

    public RongAuthImageDownloader(Context context) {
        super(context);
    }

    public RongAuthImageDownloader(Context context, int connectTimeout, int readTimeout) {
        super(context, connectTimeout, readTimeout);
    }

    @Override
    protected InputStream getStreamFromNetwork(String imageUri, Object extra) throws IOException {
        InputStream imageStream;
        HttpURLConnection conn = null;
        try {
            conn = NetUtils.createURLConnection((String)imageUri);
            conn.setConnectTimeout(this.connectTimeout);
            conn.setReadTimeout(this.readTimeout);
            if (conn instanceof HttpsURLConnection) {
                HostnameVerifier hostVerifier;
                SSLContext sslContext = SSLUtils.getSSLContext();
                if (sslContext != null) {
                    ((HttpsURLConnection)conn).setSSLSocketFactory(sslContext.getSocketFactory());
                }
                if ((hostVerifier = SSLUtils.getHostVerifier()) != null) {
                    ((HttpsURLConnection)conn).setHostnameVerifier(hostVerifier);
                }
            }
            conn.connect();
            if (conn.getResponseCode() >= 300 && conn.getResponseCode() < 400) {
                String redirectUrl = conn.getHeaderField("Location");
                conn = (HttpURLConnection)new URL(redirectUrl).openConnection();
                conn.setConnectTimeout(this.connectTimeout);
                conn.setReadTimeout(this.readTimeout);
                if (conn instanceof HttpsURLConnection) {
                    HostnameVerifier hostVerifier;
                    SSLContext sslContext = SSLUtils.getSSLContext();
                    if (sslContext != null) {
                        ((HttpsURLConnection)conn).setSSLSocketFactory(sslContext.getSocketFactory());
                    }
                    if ((hostVerifier = SSLUtils.getHostVerifier()) != null) {
                        ((HttpsURLConnection)conn).setHostnameVerifier(hostVerifier);
                    }
                }
                conn.connect();
            }
            imageStream = conn.getInputStream();
        }
        catch (IOException e) {
            if (conn != null && conn.getContentLength() > 0 && conn.getContentType().contains("image/")) {
                imageStream = conn.getErrorStream();
            }
            if (conn != null) {
                IoUtils.readAndCloseStream(conn.getErrorStream());
            }
            throw e;
        }
        if (!this.shouldBeProcessed(conn)) {
            IoUtils.closeSilently(imageStream);
            throw new IOException("Image request failed with response code " + conn.getResponseCode());
        }
        return new ContentLengthInputStream(new BufferedInputStream(imageStream, 32768), conn.getContentLength());
    }
}

