/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;

public class ImageDownloadManager {
    private static final String TAG = ImageDownloadManager.class.getSimpleName();
    private static ImageDownloadManager instance;
    private static Context mContext;
    private DownloadManager downloadManager;
    private String savePath = "download";
    private long taskId;
    private String imageString;
    private DownloadStatusListener downloadStatusListener;
    private BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            ImageDownloadManager.this.checkDownloadStatus();
        }
    };

    private ImageDownloadManager() {
        if (mContext == null) {
            throw new NullPointerException("mContext is empty ,need invoke init!");
        }
        this.downloadManager = (DownloadManager)mContext.getSystemService("download");
    }

    public static void init(Context context) {
        mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageDownloadManager getInstance() {
        if (instance != null) return instance;
        Class<ImageDownloadManager> clazz = ImageDownloadManager.class;
        synchronized (ImageDownloadManager.class) {
            if (instance != null) return instance;
            instance = new ImageDownloadManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void downloadImage(String remotePath, DownloadStatusListener downloadStatusListener) {
        if (TextUtils.isEmpty((CharSequence)remotePath) && downloadStatusListener == null) {
            throw new NullPointerException("parameter is error");
        }
        this.downloadStatusListener = downloadStatusListener;
        if (!this.canDownloadManagerState()) {
            Log.e((String)TAG, (String)"DownloadManager is disable or Device ROM remove it");
            downloadStatusListener.downloadFailed(DownloadStatusError.DEVICE_DISABLE);
            return;
        }
        this.imageString = remotePath.substring(remotePath.length() - 7);
        String path = mContext.getExternalFilesDir(this.savePath) + "/" + this.imageString + ".jpg";
        if (new File(path).exists()) {
            downloadStatusListener.downloadSuccess(path, null);
            return;
        }
        try {
            DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)remotePath));
            request.setDestinationInExternalFilesDir(mContext, this.savePath, this.imageString + ".jpg");
            this.setTaskId(this.downloadManager.enqueue(request));
            mContext.registerReceiver(this.receiver, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)"Can only download HTTP/HTTPS URIs");
            downloadStatusListener.downloadFailed(DownloadStatusError.DOWNLOAD_FAILED);
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"The external storage directory cannot be found or created");
            downloadStatusListener.downloadFailed(DownloadStatusError.DOWNLOAD_FAILED);
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)"downloadImage securityException");
            downloadStatusListener.downloadFailed(DownloadStatusError.DOWNLOAD_FAILED);
        }
    }

    private void checkDownloadStatus() {
        DownloadManager.Query query = new DownloadManager.Query();
        query.setFilterById(new long[]{this.getTaskId()});
        Cursor c = this.downloadManager.query(query);
        if (c.moveToFirst()) {
            int status = c.getInt(c.getColumnIndex("status"));
            switch (status) {
                case 4: {
                    Log.e((String)TAG, (String)"STATUS_PAUSED");
                    break;
                }
                case 1: {
                    Log.e((String)TAG, (String)"STATUS_PENDING");
                    break;
                }
                case 2: {
                    Log.e((String)TAG, (String)"STATUS_RUNNING");
                    break;
                }
                case 8: {
                    String path = mContext.getExternalFilesDir(this.savePath) + "/" + this.imageString + ".jpg";
                    this.downloadStatusListener.downloadSuccess("file://" + path, null);
                    mContext.unregisterReceiver(this.receiver);
                    Log.e((String)TAG, (String)("STATUS_SUCCESSFUL PATH: " + path));
                    break;
                }
                case 16: {
                    this.downloadStatusListener.downloadFailed(DownloadStatusError.DOWNLOAD_FAILED);
                    Log.e((String)TAG, (String)"STATUS_FAILED");
                }
            }
        }
    }

    private boolean canDownloadManagerState() {
        try {
            int state = mContext.getPackageManager().getApplicationEnabledSetting("com.android.providers.downloads");
            if (state == 2 || state == 3 || state == 4) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private long getTaskId() {
        return this.taskId;
    }

    private void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public static enum DownloadStatusError {
        DEVICE_DISABLE,
        DOWNLOAD_FAILED;

    }

    public static interface DownloadStatusListener {
        public void downloadSuccess(String var1, Bitmap var2);

        public void downloadFailed(DownloadStatusError var1);
    }
}

