/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.Spannable;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.message.CombineMessage;
import io.rong.imkit.model.GroupUserInfo;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.utils.CombineMessageUtils;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Group;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.UserInfo;
import io.rong.message.ImageMessage;
import io.rong.message.LocationMessage;
import io.rong.message.MediaMessageContent;
import io.rong.message.ReferenceMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ForwardManager {
    private static final String TAG = ForwardManager.class.getSimpleName();
    private static final int TIME_DELAY = 400;
    private static final int SUMMARY_MAX_SIZE = 4;
    private ExecutorService executor = this.getExecutor();

    private ForwardManager() {
    }

    public static ForwardManager getInstance() {
        return SingletonHolder.sInstance;
    }

    public static void forwardMessage(Activity activity, ArrayList<Conversation> conversations) {
        Intent intent = new Intent();
        intent.putExtra("index", activity.getIntent().getIntExtra("index", 0));
        intent.putIntegerArrayListExtra("messageIds", activity.getIntent().getIntegerArrayListExtra("messageIds"));
        intent.putParcelableArrayListExtra("conversations", conversations);
        activity.setResult(-1, intent);
        activity.finish();
    }

    public static List<Message> filterMessagesList(Context context, List<Message> messages, int index) {
        ArrayList<Message> forwardMessagesList = new ArrayList<Message>();
        if (context == null) {
            RLog.e((String)TAG, (String)"filterMessagesList context is null");
            return forwardMessagesList;
        }
        for (Message message : messages) {
            if (!ForwardManager.allowForward(message, index)) {
                String msg = context.getString(R.string.rc_combine_unsupported);
                if (index == 0) {
                    msg = context.getString(R.string.rc_combine_unsupported_step);
                }
                new AlertDialog.Builder(context).setMessage((CharSequence)msg).setPositiveButton((CharSequence)context.getString(R.string.rc_dialog_ok), null).show();
                forwardMessagesList.clear();
                return forwardMessagesList;
            }
            forwardMessagesList.add(message);
        }
        Collections.sort(forwardMessagesList, new Comparator<Message>(){

            @Override
            public int compare(Message o1, Message o2) {
                return (int)(o1.getSentTime() - o2.getSentTime());
            }
        });
        return forwardMessagesList;
    }

    private static boolean allowForward(Message message, int index) {
        if (message == null) {
            RLog.d((String)TAG, (String)"Forwarding is not allowed, message is null");
            return false;
        }
        if (message.getSentStatus() == Message.SentStatus.SENDING || message.getSentStatus() == Message.SentStatus.FAILED || message.getSentStatus() == Message.SentStatus.CANCELED) {
            RLog.d((String)TAG, (String)("Forwarding is not allowed, status:" + message.getSentStatus()));
            return false;
        }
        MessageContent messageContent = message.getContent();
        if (messageContent == null) {
            RLog.d((String)TAG, (String)("Forwarding is not allowed, message:" + message));
            return false;
        }
        if (messageContent.isDestruct()) {
            RLog.d((String)TAG, (String)"Destruct message not allow forward");
            return false;
        }
        MessageTag tag = messageContent.getClass().getAnnotation(MessageTag.class);
        if (tag == null) {
            RLog.d((String)TAG, (String)"Forwarding is not allowed, tag is null");
            return false;
        }
        String messageTag = tag.value();
        boolean allow = false;
        if (index == 0) {
            allow = ForwardManager.allowForwardForStep(messageTag);
        } else if (index == 1) {
            allow = ForwardManager.allowForwardForCombine(messageTag);
        }
        RLog.d((String)TAG, (String)("Forwarding allowed:" + allow + ", type:" + tag.value()));
        return allow;
    }

    private static boolean allowForwardForStep(String tag) {
        switch (tag) {
            case "RC:TxtMsg": 
            case "RC:VcMsg": 
            case "RC:HQVCMsg": 
            case "RC:SightMsg": 
            case "RC:ImgMsg": 
            case "RC:GIFMsg": 
            case "RC:FileMsg": 
            case "RC:ImgTextMsg": 
            case "RC:StkMsg": 
            case "RC:CardMsg": 
            case "RC:LBSMsg": 
            case "RC:CombineMsg": 
            case "RC:ReferenceMsg": {
                return true;
            }
        }
        return false;
    }

    private static boolean allowForwardForCombine(String tag) {
        switch (tag) {
            case "RC:TxtMsg": 
            case "RC:VcMsg": 
            case "RC:HQVCMsg": 
            case "RC:SightMsg": 
            case "RC:ImgMsg": 
            case "RC:GIFMsg": 
            case "RC:FileMsg": 
            case "RC:ImgTextMsg": 
            case "RC:StkMsg": 
            case "RC:CardMsg": 
            case "RC:LBSMsg": 
            case "RC:CombineMsg": 
            case "RC:VSTMsg": 
            case "RC:VCSummary": {
                return true;
            }
        }
        return false;
    }

    public void forwardMessages(int index, List<Conversation> conversations, List<Integer> messageIds, List<Message> messages) {
        ArrayList<Message> forwardMessages = new ArrayList<Message>();
        for (Message msg : messages) {
            if (!messageIds.contains(msg.getMessageId())) continue;
            forwardMessages.add(msg);
        }
        this.forwardMessages(index, conversations, forwardMessages);
    }

    private void forwardMessages(final int index, final List<Conversation> conversations, final List<Message> messages) {
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (index == 0) {
                    ForwardManager.this.forwardMessageByStep(conversations, messages);
                } else if (index == 1) {
                    ForwardManager.this.forwardMessageByCombine(conversations, messages);
                }
            }
        });
    }

    private void forwardMessageByStep(List<Conversation> conversations, List<Message> messages) {
        for (Conversation conversation : conversations) {
            for (Message msg : messages) {
                this.startForwardMessageByStep(conversation.getTargetId(), conversation.getConversationType(), msg);
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException e) {
                    RLog.e((String)TAG, (String)("forwardMessageByStep e:" + e.toString()));
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void startForwardMessageByStep(String id2, Conversation.ConversationType type, Message fwdMessage) {
        MessageContent messageContent = fwdMessage.getContent();
        messageContent.setUserInfo(null);
        messageContent.setMentionedInfo(null);
        Message message = Message.obtain((String)id2, (Conversation.ConversationType)type, (MessageContent)messageContent);
        if (messageContent instanceof ImageMessage) {
            ImageMessage imageMessage = (ImageMessage)messageContent;
            if (imageMessage.getRemoteUri() != null && !imageMessage.getRemoteUri().toString().startsWith("file")) {
                RongIM.getInstance().sendMessage(message, null, null, null);
            } else {
                RongIM.getInstance().sendImageMessage(message, null, null, (RongIMClient.SendImageMessageCallback)null);
            }
        } else if (messageContent instanceof LocationMessage) {
            RongIM.getInstance().sendLocationMessage(message, null, null, null);
        } else if (messageContent instanceof ReferenceMessage) {
            RongIM.getInstance().sendMessage(message, null, null, null);
        } else if (messageContent instanceof MediaMessageContent) {
            MediaMessageContent mediaMessageContent = (MediaMessageContent)messageContent;
            if (mediaMessageContent.getMediaUrl() != null) {
                RongIM.getInstance().sendMessage(message, null, null, null);
            } else {
                RongIM.getInstance().sendMediaMessage(message, null, null, (IRongCallback.ISendMediaMessageCallback)null);
            }
        } else {
            RongIM.getInstance().sendMessage(message, null, null, null);
        }
    }

    private void forwardMessageByCombine(List<Conversation> conversations, List<Message> messages) {
        Uri uri = CombineMessageUtils.getInstance().getUrlFromMessageList(messages);
        Conversation.ConversationType type = messages.get(0).getConversationType();
        CombineMessage combine = CombineMessage.obtain(uri);
        combine.setConversationType(type);
        combine.setNameList(this.getNameList(messages, type));
        combine.setTitle(this.getTitle(combine));
        combine.setSummaryList(this.getSummaryList(messages));
        for (int i = 0; i < conversations.size(); ++i) {
            Conversation conversation = conversations.get(i);
            Message message = Message.obtain((String)conversation.getTargetId(), (Conversation.ConversationType)conversation.getConversationType(), (MessageContent)combine);
            RongIM.getInstance().sendMediaMessage(message, null, null, (IRongCallback.ISendMediaMessageCallback)null);
            try {
                Thread.sleep(400L);
                continue;
            }
            catch (InterruptedException e) {
                RLog.e((String)TAG, (String)("forwardMessageByStep e:" + e.toString()));
                Thread.currentThread().interrupt();
            }
        }
    }

    private String getTitle(CombineMessage content) {
        Context context = RongIM.getInstance().getApplicationContext();
        if (context == null) {
            return "";
        }
        String title = context.getString(R.string.rc_combine_chat_history);
        if (Conversation.ConversationType.GROUP.equals((Object)content.getConversationType())) {
            title = context.getString(R.string.rc_combine_group_chat);
        } else if (Conversation.ConversationType.PRIVATE.equals((Object)content.getConversationType())) {
            List<String> nameList = content.getNameList();
            if (nameList == null) {
                return title;
            }
            if (nameList.size() == 1) {
                title = String.format(context.getString(R.string.rc_combine_the_group_chat_of), nameList.get(0));
            } else if (nameList.size() == 2) {
                title = String.format(context.getString(R.string.rc_combine_the_group_chat_of), nameList.get(0) + " " + context.getString(R.string.rc_combine_and) + " " + nameList.get(1));
            }
        }
        return title;
    }

    private List<String> getNameList(List<Message> messages, Conversation.ConversationType type) {
        ArrayList<String> names = new ArrayList<String>();
        if (Conversation.ConversationType.GROUP.equals((Object)type)) {
            String name;
            Group group = RongUserInfoManager.getInstance().getGroupInfo(messages.get(0).getTargetId());
            if (group != null && !TextUtils.isEmpty((CharSequence)(name = group.getName())) && !names.contains(name)) {
                names.add(name);
            }
        } else {
            for (Message msg : messages) {
                if (names.size() == 2) {
                    return names;
                }
                UserInfo info = RongUserInfoManager.getInstance().getUserInfo(msg.getSenderUserId());
                if (info == null) {
                    RLog.d((String)TAG, (String)("getNameList name is null, msg:" + msg));
                    break;
                }
                String name = info.getName();
                if (TextUtils.isEmpty((CharSequence)name) || names.contains(name)) continue;
                names.add(name);
            }
        }
        return names;
    }

    private List<String> getSummaryList(List<Message> messages) {
        ArrayList<String> summaryList = new ArrayList<String>();
        Conversation.ConversationType type = messages.get(0).getConversationType();
        for (int i = 0; i < messages.size() && i < 4; ++i) {
            GroupUserInfo groupUserInfo;
            Message message = messages.get(i);
            MessageContent content = message.getContent();
            UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(message.getSenderUserId());
            String userName = "";
            if (type.equals((Object)Conversation.ConversationType.GROUP) && (groupUserInfo = RongUserInfoManager.getInstance().getGroupUserInfo(message.getTargetId(), message.getSenderUserId())) != null) {
                userName = groupUserInfo.getNickname();
            }
            if (TextUtils.isEmpty((CharSequence)userName) && userInfo != null) {
                userName = userInfo.getName();
            }
            String text = "";
            MessageTag tag = content.getClass().getAnnotation(MessageTag.class);
            String tagValue = tag != null ? tag.value() : null;
            Context context = RongIM.getInstance().getApplicationContext();
            if (context != null) {
                if ("RC:CardMsg".equals(tagValue)) {
                    text = context.getString(R.string.rc_message_content_card);
                } else if ("RC:StkMsg".equals(tagValue)) {
                    text = context.getString(R.string.rc_message_content_sticker);
                } else if ("RC:VCSummary".equals(tagValue) || "RC:VSTMsg".equals(tagValue)) {
                    text = context.getString(R.string.rc_message_content_vst);
                } else if ("RCJrmf:RpMsg".equals(tagValue)) {
                    text = context.getString(R.string.rc_message_content_rp);
                } else {
                    Spannable spannable = RongContext.getInstance().getMessageTemplate(content.getClass()).getContentSummary(RongIM.getInstance().getApplicationContext(), content);
                    text = spannable.toString();
                }
            }
            summaryList.add(userName + " : " + text);
        }
        return summaryList;
    }

    private ExecutorService getExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        return this.executor;
    }

    private static class SingletonHolder {
        static ForwardManager sInstance = new ForwardManager();

        private SingletonHolder() {
        }
    }
}

