/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.support.v4.content.FileProvider;
import android.support.v4.os.EnvironmentCompat;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongIM;
import io.rong.imkit.model.FileInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class FileTypeUtils {
    private static final String TAG = FileTypeUtils.class.getSimpleName();
    public static final FileFilter ALL_FOLDER_AND_FILES_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return !pathname.isHidden();
        }
    };
    public static final int KILOBYTE = 1024;
    public static final int MEGABYTE = 0x100000;
    public static final int GIGABYTE = 0x40000000;

    public static int fileTypeImageId(Context context, String fileName) {
        if (context == null) {
            return R.drawable.rc_file_icon_file;
        }
        int id2 = FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_image_file_suffix)) ? R.drawable.rc_file_icon_picture : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_file_file_suffix)) ? R.drawable.rc_file_icon_file : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_video_file_suffix)) ? R.drawable.rc_file_icon_video : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_audio_file_suffix)) ? R.drawable.rc_file_icon_audio : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_word_file_suffix)) ? R.drawable.rc_file_icon_word : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_excel_file_suffix)) ? R.drawable.rc_file_icon_excel : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_ppt_file_suffix)) ? R.drawable.rc_file_icon_ppt : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_pdf_file_suffix)) ? R.drawable.rc_file_icon_pdf : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_apk_file_suffix)) ? R.drawable.rc_file_icon_apk : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_key_file_suffix)) ? R.drawable.rc_file_icon_key : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_numbers_file_suffix)) ? R.drawable.rc_file_icon_numbers : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_pages_file_suffix)) ? R.drawable.rc_file_icon_pages : R.drawable.rc_file_icon_else)))))))))));
        return id2;
    }

    private static boolean checkSuffix(String fileName, String[] fileSuffix) {
        for (String suffix : fileSuffix) {
            if (fileName == null || !fileName.toLowerCase().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static Intent getOpenFileIntent(String fileName, String fileSavePath) {
        Intent intent = new Intent("android.intent.action.VIEW");
        if (RongIM.getInstance().getApplicationContext() == null) {
            return null;
        }
        String type = FileTypeUtils.getIntentType(RongIM.getInstance().getApplicationContext(), intent, fileName);
        if (type != null && fileSavePath != null && FileTypeUtils.isIntentHandlerAvailable(RongIM.getInstance().getApplicationContext(), intent)) {
            Uri uri = FileProvider.getUriForFile((Context)RongIM.getInstance().getApplicationContext(), (String)(RongIM.getInstance().getApplicationContext().getPackageName() + RongIM.getInstance().getApplicationContext().getResources().getString(R.string.rc_authorities_fileprovider)), (File)new File(fileSavePath));
            intent.setDataAndType(uri, type);
            return intent;
        }
        return null;
    }

    public static Intent getOpenFileIntent(Context context, String fileName, Uri uri) {
        if (context == null) {
            return null;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        String type = FileTypeUtils.getIntentType(context, intent, fileName);
        if (type != null && uri != null && FileTypeUtils.isIntentHandlerAvailable(context, intent)) {
            if (FileUtils.uriStartWithContent((Uri)uri)) {
                intent.setDataAndType(uri, type);
            } else {
                String path = uri.toString();
                if (FileUtils.uriStartWithFile((Uri)uri)) {
                    path = path.substring(7);
                }
                Uri fileUri = FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + context.getResources().getString(R.string.rc_authorities_fileprovider)), (File)new File(path));
                intent.setDataAndType(fileUri, type);
            }
            return intent;
        }
        return null;
    }

    private static String getIntentType(Context context, Intent intent, String fileName) {
        String type = null;
        if (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_image_file_suffix))) {
            intent.addCategory("android.intent.category.DEFAULT");
            intent.addFlags(0x10000000);
            type = "image/*";
        }
        if (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_file_file_suffix))) {
            intent.addCategory("android.intent.category.DEFAULT");
            intent.addFlags(0x10000000);
            type = "text/plain";
        }
        if (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_video_file_suffix))) {
            intent.addFlags(0x4000000);
            intent.putExtra("oneshot", 0);
            intent.putExtra("configchange", 0);
            type = "video/*";
        }
        if (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_audio_file_suffix))) {
            intent.addFlags(0x4000000);
            intent.putExtra("oneshot", 0);
            intent.putExtra("configchange", 0);
            type = "audio/*";
        }
        if (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_word_file_suffix))) {
            intent.addCategory("android.intent.category.DEFAULT");
            intent.addFlags(0x10000000);
            type = "application/msword";
        }
        if (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_excel_file_suffix))) {
            intent.addCategory("android.intent.category.DEFAULT");
            intent.addFlags(0x10000000);
            type = "application/vnd.ms-excel";
        }
        if (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_pdf_file_suffix))) {
            intent.addCategory("android.intent.category.DEFAULT");
            intent.addFlags(0x10000000);
            type = "application/pdf";
        }
        if (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_ppt_file_suffix))) {
            intent.addCategory("android.intent.category.DEFAULT");
            intent.addFlags(0x10000000);
            type = "application/vnd.ms-powerpoint";
        }
        return type;
    }

    private static boolean isIntentHandlerAvailable(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        List infoList = packageManager.queryIntentActivities(intent, 65536);
        return infoList.size() > 0;
    }

    public static List<FileInfo> getTextFilesInfo(Context context, File fileDir) {
        ArrayList<FileInfo> textFilesInfo = new ArrayList<FileInfo>();
        if (context == null) {
            return textFilesInfo;
        }
        FileTypeFilter fileFilter = new FileTypeFilter(context.getResources().getStringArray(R.array.rc_file_file_suffix));
        FileTypeUtils.getFileInfos(fileDir, fileFilter, textFilesInfo);
        return textFilesInfo;
    }

    private static void getFileInfos(File fileDir, FileFilter fileFilter, List<FileInfo> fileInfos) {
        File[] listFiles = fileDir.listFiles(fileFilter);
        if (listFiles != null) {
            for (File file : listFiles) {
                if (file.isDirectory()) {
                    FileTypeUtils.getFileInfos(file, fileFilter, fileInfos);
                    continue;
                }
                if (file.length() == 0L) continue;
                FileInfo fileInfo = FileTypeUtils.getFileInfoFromFile(file);
                fileInfos.add(fileInfo);
            }
        }
    }

    public static List<FileInfo> getVideoFilesInfo(Context context, File fileDir) {
        ArrayList<FileInfo> videoFilesInfo = new ArrayList<FileInfo>();
        if (context == null) {
            return videoFilesInfo;
        }
        FileTypeFilter fileFilter = new FileTypeFilter(context.getResources().getStringArray(R.array.rc_video_file_suffix));
        FileTypeUtils.getFileInfos(fileDir, fileFilter, videoFilesInfo);
        return videoFilesInfo;
    }

    public static List<FileInfo> getAudioFilesInfo(Context context, File fileDir) {
        ArrayList<FileInfo> audioFilesInfo = new ArrayList<FileInfo>();
        if (context == null) {
            return audioFilesInfo;
        }
        FileTypeFilter fileFilter = new FileTypeFilter(context.getResources().getStringArray(R.array.rc_audio_file_suffix));
        FileTypeUtils.getFileInfos(fileDir, fileFilter, audioFilesInfo);
        return audioFilesInfo;
    }

    public static List<FileInfo> getOtherFilesInfo(Context context, File fileDir) {
        ArrayList<FileInfo> otherFilesInfo = new ArrayList<FileInfo>();
        if (context == null) {
            return otherFilesInfo;
        }
        FileTypeFilter fileFilter = new FileTypeFilter(context.getResources().getStringArray(R.array.rc_other_file_suffix));
        FileTypeUtils.getFileInfos(fileDir, fileFilter, otherFilesInfo);
        return otherFilesInfo;
    }

    public static List<FileInfo> getFileInfosFromFileArray(File[] files) {
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        for (File file : files) {
            FileInfo fileInfo = FileTypeUtils.getFileInfoFromFile(file);
            fileInfos.add(fileInfo);
        }
        return fileInfos;
    }

    private static FileInfo getFileInfoFromFile(File file) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFileName(file.getName());
        fileInfo.setFilePath(file.getPath());
        fileInfo.setDirectory(file.isDirectory());
        if (file.isDirectory()) {
            fileInfo.setFileSize(FileTypeUtils.getNumFilesInFolder(fileInfo));
        } else {
            fileInfo.setFileSize(file.length());
        }
        int lastDotIndex = file.getName().lastIndexOf(".");
        if (lastDotIndex > 0) {
            String fileSuffix = file.getName().substring(lastDotIndex + 1);
            fileInfo.setSuffix(fileSuffix);
        }
        return fileInfo;
    }

    public static int getNumFilesInFolder(FileInfo fileInfo) {
        if (!fileInfo.isDirectory()) {
            return 0;
        }
        File[] files = new File(fileInfo.getFilePath()).listFiles(ALL_FOLDER_AND_FILES_FILTER);
        if (files == null) {
            return 0;
        }
        return files.length;
    }

    public static int getFileIconResource(Context context, FileInfo file) {
        if (file.isDirectory()) {
            return R.drawable.rc_ad_list_folder_icon;
        }
        return FileTypeUtils.getFileTypeImageId(context, file.getFileName());
    }

    private static int getFileTypeImageId(Context context, String fileName) {
        int id2 = FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_file_file_suffix)) ? R.drawable.rc_ad_list_file_icon : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_video_file_suffix)) ? R.drawable.rc_ad_list_video_icon : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_audio_file_suffix)) ? R.drawable.rc_ad_list_audio_icon : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_ppt_file_suffix)) ? R.drawable.rc_ad_list_ppt_icon : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_pdf_file_suffix)) ? R.drawable.rc_ad_list_pdf_icon : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_image_file_suffix)) ? R.drawable.rc_file_icon_picture : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_apk_file_suffix)) ? R.drawable.rc_file_icon_apk : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_word_file_suffix)) ? R.drawable.rc_file_icon_word : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_excel_file_suffix)) ? R.drawable.rc_file_icon_excel : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_key_file_suffix)) ? R.drawable.rc_ad_list_key_icon : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_numbers_file_suffix)) ? R.drawable.rc_ad_list_numbers_icon : (FileTypeUtils.checkSuffix(fileName, context.getResources().getStringArray(R.array.rc_pages_file_suffix)) ? R.drawable.rc_ad_list_pages_icon : R.drawable.rc_ad_list_other_icon)))))))))));
        return id2;
    }

    public static String formatFileSize(long size) {
        if (size < 1024L) {
            return String.format("%d B", (int)size);
        }
        if (size < 0x100000L) {
            return String.format("%.2f KB", Float.valueOf((float)size / 1024.0f));
        }
        if (size < 0x40000000L) {
            return String.format("%.2f MB", Float.valueOf((float)size / 1048576.0f));
        }
        return String.format("%.2f G", Float.valueOf((float)size / 1.0737418E9f));
    }

    public String getSDCardPath() {
        String SDCardPath = null;
        String SDCardDefaultPath = Environment.getExternalStorageDirectory().getAbsolutePath();
        if (SDCardDefaultPath.endsWith("/")) {
            SDCardDefaultPath = SDCardDefaultPath.substring(0, SDCardDefaultPath.length() - 1);
        }
        try {
            String line;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("mount");
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((line = bufferedReader.readLine()) != null) {
                String temp;
                String[] array2;
                if (!line.toLowerCase().contains("sdcard") || !line.contains(".android_secure") || (array2 = line.split(" ")).length <= 1 || SDCardDefaultPath.equals(temp = array2[1].replace("/.android_secure", ""))) continue;
                SDCardPath = temp;
            }
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)"getSDCardPath", (Throwable)e);
        }
        return SDCardPath;
    }

    public static String[] getExternalStorageDirectories(Context context) {
        int i;
        ArrayList<String> results = new ArrayList<String>();
        if (Build.VERSION.SDK_INT >= 19) {
            File[] externalDirs;
            for (File file : externalDirs = context.getExternalFilesDirs(null)) {
                if (file == null) continue;
                String path = file.getPath().split("/Android")[0];
                boolean addPath = Build.VERSION.SDK_INT >= 21 ? Environment.isExternalStorageRemovable((File)file) : "mounted".equals(EnvironmentCompat.getStorageState((File)file));
                if (!addPath) continue;
                results.add(path);
            }
        }
        if (results.isEmpty()) {
            String[] lines;
            String reg = "(?i).*vold.*(vfat|ntfs|exfat|fat32|ext3|ext4).*rw.*";
            StringBuilder s = new StringBuilder();
            try {
                Process process = new ProcessBuilder(new String[0]).command("mount").redirectErrorStream(true).start();
                process.waitFor();
                InputStream is = process.getInputStream();
                byte[] buffer = new byte[1024];
                while (is.read(buffer) != -1) {
                    s.append(new String(buffer));
                }
                is.close();
            }
            catch (Exception e) {
                RLog.e((String)TAG, (String)"getExternalStorageDirectories", (Throwable)e);
            }
            for (String line : lines = s.toString().split("\n")) {
                String[] parts;
                if (line.toLowerCase(Locale.US).contains("asec") || !line.matches(reg)) continue;
                for (String part : parts = line.split(" ")) {
                    if (!part.startsWith("/") || part.toLowerCase(Locale.US).contains("vold")) continue;
                    results.add(part);
                }
            }
        }
        if (Build.VERSION.SDK_INT >= 23) {
            for (i = 0; i < results.size(); ++i) {
                if (((String)results.get(i)).toLowerCase().matches(".*[0-9a-f]{4}[-][0-9a-f]{4}")) continue;
                results.remove(i--);
            }
        } else {
            for (i = 0; i < results.size(); ++i) {
                if (((String)results.get(i)).toLowerCase().contains("ext") || ((String)results.get(i)).toLowerCase().contains("sdcard")) continue;
                results.remove(i--);
            }
        }
        String[] storageDirectories = new String[results.size()];
        for (int i2 = 0; i2 < results.size(); ++i2) {
            storageDirectories[i2] = (String)results.get(i2);
        }
        return storageDirectories;
    }

    public static class FileNameComparator
    implements Comparator<FileInfo> {
        protected static final int FIRST = -1;
        protected static final int SECOND = 1;

        @Override
        public int compare(FileInfo lhs, FileInfo rhs) {
            if (lhs.isDirectory() || rhs.isDirectory()) {
                if (lhs.isDirectory() == rhs.isDirectory()) {
                    return lhs.getFileName().compareToIgnoreCase(rhs.getFileName());
                }
                if (lhs.isDirectory()) {
                    return -1;
                }
                return 1;
            }
            return lhs.getFileName().compareToIgnoreCase(rhs.getFileName());
        }
    }

    public static final class FileTypeFilter
    implements FileFilter {
        private String[] filesSuffix;

        public FileTypeFilter(String[] fileSuffix) {
            this.filesSuffix = fileSuffix;
        }

        @Override
        public boolean accept(File pathname) {
            return !pathname.isHidden() && (pathname.isDirectory() || FileTypeUtils.checkSuffix(pathname.getName(), this.filesSuffix));
        }
    }
}

