/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.text.Spannable;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.message.CombineMessage;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.utilities.RongUtils;
import io.rong.imkit.utils.FileTypeUtils;
import io.rong.imkit.utils.RongDateUtils;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.UserInfo;
import io.rong.message.FileMessage;
import io.rong.message.GIFMessage;
import io.rong.message.ImageMessage;
import io.rong.message.LocationMessage;
import io.rong.message.SightMessage;
import io.rong.message.TextMessage;
import io.rong.message.utils.BitmapUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CombineMessageUtils {
    private static final String TAG = CombineMessageUtils.class.getSimpleName();
    private static final String COMBINE_FILE_PATH = "combine";
    private static final String COMBINE_FILE_SUFFIX = ".html";
    private static final int IMAGE_WIDTH = 100;
    private static final int IMAGE_HEIGHT = 100;
    private static final String JSON_FILE_NAME = "combine.json";
    private static final String BASE64_PRE = "data:image/jpeg;base64,";
    private static final String NO_USER = "rong-none-user";
    private static final String TAG_BASE_HEAD = "baseHead";
    private static final String TAG_TIME = "time";
    private static final String TAG_TXT = "RC:TxtMsg";
    private static final String TAG_GIF = "RC:GIFMsg";
    private static final String TAG_VC = "RC:VcMsg";
    private static final String TAG_HQVC = "RC:HQVCMsg";
    private static final String TAG_CARD = "RC:CardMsg";
    private static final String TAG_STK = "RC:StkMsg";
    private static final String TAG_IMG_TEXT = "RC:ImgTextMsg";
    private static final String TAG_SIGHT = "RC:SightMsg";
    private static final String TAG_IMG = "RC:ImgMsg";
    private static final String TAG_COMBINE = "RC:CombineMsg";
    private static final String TAG_MSG_COMBINE_BODY = "CombineMsgBody";
    private static final String TAG_FILE = "RC:FileMsg";
    private static final String TAG_LBS = "RC:LBSMsg";
    private static final String TAG_VCSUMMARY = "RC:VCSummary";
    private static final String TAG_VST = "RC:VSTMsg";
    private static final String TAG_RP = "RCJrmf:RpMsg";
    private static final String TAG_BASE_BOTTOM = "baseBottom";
    private static final String MSG_BASE_HEAD_STYLE = "{%style%}";
    private static final String MSG_TIME = "{%time%}";
    private static final String MSG_SHOW_USER = "{%showUser%}";
    private static final String MSG_PORTRAIT = "{%portrait%}";
    private static final String MSG_USER_NAMEM = "{%userName%}";
    private static final String MSG_SEND_TIME = "{%sendTime%}";
    private static final String MSG_TEXT = "{%text%}";
    private static final String MSG_IMAG_URL = "{%imgUrl%}";
    private static final String MSG_FILE_NAME = "{%fileName%}";
    private static final String MSG_SIZE = "{%size%}";
    private static final String MSG_FILE_SIZE = "{%fileSize%}";
    private static final String MSG_FILE_URL = "{%fileUrl%}";
    private static final String MSG_FILE_TYPE = "{%fileType%}";
    private static final String MSG_FILE_ICON = "{%fileIcon%}";
    private static final String MSG_TITLE = "{%title%}";
    private static final String MSG_COMBINE_BODY = "{%combineBody%}";
    private static final String MSG_FOOT = "{%foot%}";
    private static final String MSG_LOCATION_NAME = "{%locationName%}";
    private static final String MSG_LATITUDE = "{%latitude%}";
    private static final String MSG_LONGITTUDE = "{%longitude%}";
    private static final String MSG_IMAGE_BASE64 = "{%imageBase64%}";
    private static final String MSG_DURATION = "{%duration%}";
    private Map<String, String> DATA = new HashMap<String, String>();
    private Uri URI = null;
    private Boolean isSameDay;
    private Boolean isSameYear;
    private String style = "";

    private CombineMessageUtils() {
    }

    public static CombineMessageUtils getInstance() {
        return Holder.Utils;
    }

    Uri getUrlFromMessageList(List<Message> messagesList) {
        this.style = "";
        this.URI = null;
        this.isSameDay = this.isSameYear = Boolean.valueOf(false);
        String filePath = FileUtils.getCachePath((Context)RongIM.getInstance().getApplicationContext()) + File.separator + COMBINE_FILE_PATH + File.separator + System.currentTimeMillis() + COMBINE_FILE_SUFFIX;
        String filStr = this.getHtmlFromMessageList(messagesList);
        FileUtils.saveFile((String)filStr, (String)filePath);
        return Uri.parse((String)("file://" + filePath));
    }

    private String getHtmlFromMessageList(List<Message> messagesList) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getHtmlBaseHead());
        stringBuilder.append(this.getHtmlTime(messagesList));
        for (Message msg : messagesList) {
            stringBuilder.append(this.getHtmlFromMessageContent(msg, msg.getContent()));
        }
        stringBuilder.append(this.getHtmlBaseBottom());
        return stringBuilder.toString();
    }

    private String getHtmlBaseHead() {
        return this.getHtmlFromType(TAG_BASE_HEAD).replace(MSG_BASE_HEAD_STYLE, this.style);
    }

    private String getHtmlTime(List<Message> messagesList) {
        long first = messagesList.get(0).getSentTime();
        Calendar firstCalendar = Calendar.getInstance();
        firstCalendar.setTimeInMillis(first);
        long last = messagesList.get(messagesList.size() - 1).getSentTime();
        Calendar lastCalendar = Calendar.getInstance();
        lastCalendar.setTimeInMillis(last);
        this.isSameYear = firstCalendar.get(1) == lastCalendar.get(1);
        this.isSameDay = this.isSameYear != false && firstCalendar.get(2) == lastCalendar.get(2) && firstCalendar.get(5) == lastCalendar.get(5);
        String format = "yyyy-M-d";
        String time = this.isSameDay != false ? new SimpleDateFormat(format, Locale.CANADA).format(first) : new SimpleDateFormat(format, Locale.CANADA).format(first) + " - " + new SimpleDateFormat(format, Locale.CANADA).format(last);
        return this.getHtmlFromType(TAG_TIME).replace(MSG_TIME, time);
    }

    private String getHtmlFromMessageContent(Message message, MessageContent content) {
        MessageTag tag = content.getClass().getAnnotation(MessageTag.class);
        Context context = RongIM.getInstance().getApplicationContext();
        if (context == null || tag == null || !tag.value().startsWith("RC:")) {
            RLog.e((String)TAG, (String)("getHtmlFromMessageContent tag is UnKnown, content:" + content));
            return "";
        }
        String type = tag.value();
        String html = this.setUserInfo(this.getHtmlFromType(type), message);
        switch (type) {
            case "RC:TxtMsg": {
                TextMessage text = (TextMessage)content;
                html = html.replace(MSG_TEXT, text.getContent());
                break;
            }
            case "RC:ImgTextMsg": 
            case "RC:VcMsg": 
            case "RC:HQVCMsg": {
                html = html.replace(MSG_TEXT, this.getSpannable(content));
                break;
            }
            case "RC:StkMsg": {
                html = html.replace(MSG_TEXT, context.getString(R.string.rc_message_content_sticker));
                break;
            }
            case "RC:CardMsg": {
                html = html.replace(MSG_TEXT, context.getString(R.string.rc_message_content_card));
                break;
            }
            case "RC:VSTMsg": 
            case "RC:VCSummary": {
                html = html.replace(MSG_TEXT, context.getString(R.string.rc_message_content_vst));
                break;
            }
            case "RCJrmf:RpMsg": {
                html = html.replace(MSG_TEXT, context.getString(R.string.rc_message_content_rp));
                break;
            }
            case "RC:SightMsg": {
                SightMessage sight = (SightMessage)content;
                String sightBase64 = this.getBase64FromUrl(sight.getThumbUri());
                int duration = sight.getDuration();
                html = html.replace(MSG_FILE_NAME, sight.getName()).replace(MSG_SIZE, FileTypeUtils.formatFileSize(sight.getSize())).replace(MSG_FILE_URL, sight.getMediaUrl() == null ? "" : sight.getMediaUrl().toString()).replace(MSG_IMAGE_BASE64, sightBase64).replace(MSG_DURATION, String.valueOf(duration));
                break;
            }
            case "RC:ImgMsg": {
                ImageMessage image = (ImageMessage)content;
                String base64 = this.getBase64FromUrl(image.getThumUri());
                html = html.replace(MSG_FILE_URL, image.getMediaUrl() == null ? "" : image.getMediaUrl().toString()).replace(MSG_IMAG_URL, base64);
                break;
            }
            case "RC:GIFMsg": {
                GIFMessage gif = (GIFMessage)content;
                String gifBase64 = this.getBase64FromUrl(gif.getRemoteUri());
                html = html.replace(MSG_FILE_URL, gif.getRemoteUri() == null ? "" : gif.getRemoteUri().toString()).replace(MSG_IMAG_URL, gifBase64);
                break;
            }
            case "RC:FileMsg": {
                FileMessage file = (FileMessage)content;
                html = html.replace(MSG_FILE_NAME, file.getName()).replace(MSG_SIZE, FileTypeUtils.formatFileSize(file.getSize())).replace(MSG_FILE_SIZE, String.valueOf(file.getSize())).replace(MSG_FILE_URL, file.getFileUrl() == null ? "" : file.getFileUrl().toString()).replace(MSG_FILE_TYPE, file.getType()).replace(MSG_FILE_ICON, this.getBase64FromImageId(FileTypeUtils.fileTypeImageId(context, file.getName())));
                break;
            }
            case "RC:LBSMsg": {
                LocationMessage location = (LocationMessage)content;
                html = html.replace(MSG_LOCATION_NAME, location.getPoi()).replace(MSG_LATITUDE, String.valueOf(location.getLat())).replace(MSG_LONGITTUDE, String.valueOf(location.getLng()));
                break;
            }
            case "RC:CombineMsg": {
                CombineMessage combine = (CombineMessage)content;
                StringBuilder summary = new StringBuilder();
                String combineBody = this.getHtmlFromType(TAG_MSG_COMBINE_BODY);
                List<String> summarys = combine.getSummaryList();
                for (String sum : summarys) {
                    summary.append(combineBody.replace(MSG_TEXT, sum));
                }
                html = html.replace(MSG_FILE_URL, combine.getMediaUrl() == null ? "" : combine.getMediaUrl().toString()).replace(MSG_TITLE, combine.getTitle()).replace(MSG_COMBINE_BODY, summary.toString()).replace(MSG_FOOT, context.getString(R.string.rc_combine_chat_history));
                break;
            }
            default: {
                RLog.e((String)TAG, (String)("getHtmlFromMessageContent UnKnown type:" + type));
            }
        }
        return html;
    }

    private String getHtmlBaseBottom() {
        return this.getHtmlFromType(TAG_BASE_BOTTOM);
    }

    private String getHtmlFromType(String type) {
        String html;
        if (this.DATA == null || this.DATA.size() == 0) {
            this.DATA = this.getDATA();
        }
        if (this.DATA == null || this.DATA.size() == 0) {
            RLog.e((String)TAG, (String)"getHtmlFromType data is null");
            return "";
        }
        if (TAG_HQVC.equals(type)) {
            type = TAG_VC;
        }
        if (TAG_VST.equals(type)) {
            type = TAG_VCSUMMARY;
        }
        if (TextUtils.isEmpty((CharSequence)(html = this.DATA.get(type)))) {
            RLog.e((String)TAG, (String)("getHtmlFromType html is null, type:" + type));
            return "";
        }
        return html;
    }

    private Map<String, String> getDATA() {
        this.DATA = this.setData(this.getJson());
        return this.DATA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJson() {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bf = null;
        try {
            String line;
            bf = new BufferedReader(new InputStreamReader(RongIM.getInstance().getApplicationContext().getAssets().open(JSON_FILE_NAME)));
            while ((line = bf.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (IOException e) {
            RLog.e((String)TAG, (String)"getJson", (Throwable)e);
        }
        finally {
            try {
                if (bf != null) {
                    bf.close();
                }
            }
            catch (IOException e) {
                RLog.e((String)TAG, (String)"getJson", (Throwable)e);
            }
        }
        return stringBuilder.toString();
    }

    private Map<String, String> setData(String str) {
        try {
            JSONObject jsonObj = new JSONObject(str);
            this.DATA.put(TAG_BASE_HEAD, jsonObj.optString(TAG_BASE_HEAD));
            this.DATA.put(TAG_TIME, jsonObj.optString(TAG_TIME));
            this.DATA.put(TAG_TXT, jsonObj.optString(TAG_TXT));
            this.DATA.put(TAG_SIGHT, jsonObj.optString(TAG_SIGHT));
            this.DATA.put(TAG_IMG, jsonObj.optString(TAG_IMG));
            this.DATA.put(TAG_GIF, jsonObj.optString(TAG_GIF));
            this.DATA.put(TAG_COMBINE, jsonObj.optString(TAG_COMBINE));
            this.DATA.put(TAG_MSG_COMBINE_BODY, jsonObj.optString(TAG_MSG_COMBINE_BODY));
            this.DATA.put(TAG_FILE, jsonObj.optString(TAG_FILE));
            this.DATA.put(TAG_VC, jsonObj.optString(TAG_VC));
            this.DATA.put(TAG_CARD, jsonObj.optString(TAG_CARD));
            this.DATA.put(TAG_STK, jsonObj.optString(TAG_STK));
            this.DATA.put(TAG_IMG_TEXT, jsonObj.optString(TAG_IMG_TEXT));
            this.DATA.put(TAG_LBS, jsonObj.optString(TAG_LBS));
            this.DATA.put(TAG_VCSUMMARY, jsonObj.optString(TAG_VCSUMMARY));
            this.DATA.put(TAG_RP, jsonObj.optString(TAG_RP));
            this.DATA.put(TAG_BASE_BOTTOM, jsonObj.optString(TAG_BASE_BOTTOM));
            return this.DATA;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return this.DATA;
        }
    }

    private String setUserInfo(String str, Message msg) {
        String portrait = this.getUserPortrait(msg);
        String showUser = TextUtils.isEmpty((CharSequence)portrait) ? NO_USER : "";
        return str.replace(MSG_PORTRAIT, portrait).replace(MSG_SHOW_USER, showUser).replace(MSG_USER_NAMEM, this.getUserName(msg)).replace(MSG_SEND_TIME, this.getSendTime(msg));
    }

    private String getSendTime(Message msg) {
        String hourTime;
        long dateMillis = msg.getSentTime();
        Context context = RongIM.getInstance().getApplicationContext();
        if (dateMillis <= 0L) {
            return "";
        }
        if (RongDateUtils.isTime24Hour(context)) {
            hourTime = new SimpleDateFormat("H:mm", Locale.CANADA).format(dateMillis);
        } else {
            Calendar calendarTime = Calendar.getInstance();
            calendarTime.setTimeInMillis(dateMillis);
            int hour = calendarTime.get(10);
            int minute = calendarTime.get(12);
            if (calendarTime.get(9) == 0) {
                if (hour < 6) {
                    if (hour == 0) {
                        hour = 12;
                    }
                    hourTime = context.getResources().getString(R.string.rc_daybreak_format);
                } else {
                    hourTime = context.getResources().getString(R.string.rc_morning_format);
                }
            } else if (hour == 0) {
                hour = 12;
                hourTime = context.getResources().getString(R.string.rc_noon_format);
            } else {
                hourTime = hour <= 5 ? context.getResources().getString(R.string.rc_afternoon_format) : context.getResources().getString(R.string.rc_night_format);
            }
            hourTime = minute < 10 ? hourTime + " " + hour + ":0" + minute : hourTime + " " + hour + ":" + minute;
        }
        String format = this.isSameDay != false ? "" : (this.isSameYear != false ? "M-d " : "yyyy-M-d ");
        return new SimpleDateFormat(format, Locale.CANADA).format(dateMillis) + hourTime;
    }

    private String getUserName(Message msg) {
        UserInfo info = RongUserInfoManager.getInstance().getUserInfo(msg.getSenderUserId());
        if (info == null) {
            return "";
        }
        return info.getName();
    }

    private String getUserPortrait(Message msg) {
        UserInfo info = RongUserInfoManager.getInstance().getUserInfo(msg.getSenderUserId());
        if (info == null) {
            RLog.d((String)TAG, (String)("getUserPortrait userInfo is null, msg:" + msg));
            return "";
        }
        Uri uri = info.getPortraitUri();
        if (uri == null || uri.equals((Object)this.URI)) {
            Log.d((String)TAG, (String)("getUserPortrait is same uri:" + uri));
            return "";
        }
        this.URI = uri;
        return this.getBase64FromUrl(uri);
    }

    private String getBase64FromUrl(Uri uri) {
        if (uri == null) {
            return "";
        }
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equals("file")) {
            RLog.d((String)TAG, (String)("getBase64FromUrl uri is not file, uri:" + uri.toString()));
            return uri.toString();
        }
        Bitmap bitmap = null;
        try {
            bitmap = BitmapUtil.getResizedBitmap((Context)RongIM.getInstance().getApplicationContext(), (Uri)uri, (int)100, (int)100);
        }
        catch (IOException e) {
            RLog.e((String)TAG, (String)"getBase64FromUrl", (Throwable)e);
        }
        if (bitmap == null) {
            RLog.e((String)TAG, (String)("getBase64FromUrl bitmap is null, uri:" + uri.toString()));
            return "";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        byte[] data = baos.toByteArray();
        return BASE64_PRE + Base64.encodeToString((byte[])data, (int)2);
    }

    private String getBase64FromImageId(int id2) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)RongIM.getInstance().getApplicationContext().getResources(), (int)id2);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        byte[] data = baos.toByteArray();
        return BASE64_PRE + Base64.encodeToString((byte[])data, (int)2);
    }

    private String getSpannable(MessageContent content) {
        Spannable spannable = RongContext.getInstance().getMessageTemplate(content.getClass()).getContentSummary(RongIM.getInstance().getApplicationContext(), content);
        if (spannable == null) {
            return "";
        }
        return spannable.toString();
    }

    public void setStyle(String STYLE) {
        this.style = STYLE;
    }

    public String getCombineFilePath(String uri) {
        return FileUtils.getCachePath((Context)RongIM.getInstance().getApplicationContext()) + File.separator + COMBINE_FILE_PATH + File.separator + RongUtils.md5(uri) + COMBINE_FILE_SUFFIX;
    }

    private static class Holder {
        private static volatile CombineMessageUtils Utils = new CombineMessageUtils();

        private Holder() {
        }
    }
}

