/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utilities.videocompressor.videoslimmer.muxer;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.support.annotation.RequiresApi;
import android.view.Surface;
import io.rong.imkit.utilities.videocompressor.videoslimmer.render.TextureRenderer;
import java.nio.ByteBuffer;

@RequiresApi(api=17)
public class CodecInputSurface
implements SurfaceTexture.OnFrameAvailableListener {
    private static final int EGL_RECORDABLE_ANDROID = 12610;
    private final Object mFrameSyncObject = new Object();
    private EGLDisplay mEGLDisplay = EGL14.EGL_NO_DISPLAY;
    private EGLContext mEGLContext = EGL14.EGL_NO_CONTEXT;
    private EGLSurface mEGLSurface = EGL14.EGL_NO_SURFACE;
    private SurfaceTexture mSurfaceTexture;
    private Surface mSurface;
    private Surface mDrawSurface;
    private boolean mFrameAvailable;
    private ByteBuffer mPixelBuf;
    private TextureRenderer mTextureRender;

    public CodecInputSurface(Surface surface) {
        if (surface == null) {
            throw new NullPointerException();
        }
        this.mSurface = surface;
        this.eglSetup();
    }

    public void createRender() {
        this.mTextureRender = new TextureRenderer();
        this.mTextureRender.surfaceCreated();
        this.mSurfaceTexture = new SurfaceTexture(this.mTextureRender.getTextureId());
        this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.mDrawSurface = new Surface(this.mSurfaceTexture);
    }

    private void eglSetup() {
        this.mEGLDisplay = EGL14.eglGetDisplay((int)0);
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            throw new RuntimeException("unable to get EGL14 display");
        }
        int[] version = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.mEGLDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
            throw new RuntimeException("unable to initialize EGL14");
        }
        int[] attribList = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, 4, 12610, 1, 12344};
        EGLConfig[] configs = new EGLConfig[1];
        int[] numConfigs = new int[1];
        EGL14.eglChooseConfig((EGLDisplay)this.mEGLDisplay, (int[])attribList, (int)0, (EGLConfig[])configs, (int)0, (int)configs.length, (int[])numConfigs, (int)0);
        this.checkEglError("eglCreateContext RGB888+recordable ES2");
        int[] attrib_list = new int[]{12440, 2, 12344};
        this.mEGLContext = EGL14.eglCreateContext((EGLDisplay)this.mEGLDisplay, (EGLConfig)configs[0], (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])attrib_list, (int)0);
        this.checkEglError("eglCreateContext");
        int[] surfaceAttribs = new int[]{12344};
        this.mEGLSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)configs[0], (Object)this.mSurface, (int[])surfaceAttribs, (int)0);
        this.checkEglError("eglCreateWindowSurface");
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.mSurfaceTexture;
    }

    public void changeFragmentShader(String fragmentShader) {
        this.mTextureRender.changeFragmentShader(fragmentShader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitNewImage() {
        int TIMEOUT_MS = 5000;
        Object object = this.mFrameSyncObject;
        synchronized (object) {
            while (!this.mFrameAvailable) {
                try {
                    this.mFrameSyncObject.wait(5000L);
                    if (this.mFrameAvailable) continue;
                    throw new RuntimeException("Surface frame wait timed out");
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ie);
                }
            }
            this.mFrameAvailable = false;
        }
        this.mTextureRender.checkGlError("before updateTexImage");
        this.mSurfaceTexture.updateTexImage();
    }

    public void drawImage() {
        this.mTextureRender.drawFrame(this.mSurfaceTexture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture st) {
        Object object = this.mFrameSyncObject;
        synchronized (object) {
            if (this.mFrameAvailable) {
                throw new RuntimeException("mFrameAvailable already set, frame could be dropped");
            }
            this.mFrameAvailable = true;
            this.mFrameSyncObject.notifyAll();
        }
    }

    public Surface getSurface() {
        return this.mDrawSurface;
    }

    public void release() {
        if (this.mEGLDisplay != EGL14.EGL_NO_DISPLAY) {
            EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            EGL14.eglDestroySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface);
            EGL14.eglDestroyContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext);
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)this.mEGLDisplay);
        }
        this.mSurface.release();
        this.mEGLDisplay = EGL14.EGL_NO_DISPLAY;
        this.mEGLContext = EGL14.EGL_NO_CONTEXT;
        this.mEGLSurface = EGL14.EGL_NO_SURFACE;
        this.mSurface = null;
    }

    public void makeCurrent() {
        EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface, (EGLSurface)this.mEGLSurface, (EGLContext)this.mEGLContext);
        this.checkEglError("eglMakeCurrent");
    }

    public boolean swapBuffers() {
        boolean result = EGL14.eglSwapBuffers((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface);
        this.checkEglError("eglSwapBuffers");
        return result;
    }

    @RequiresApi(api=18)
    public void setPresentationTime(long nsecs) {
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface, (long)nsecs);
        this.checkEglError("eglPresentationTimeANDROID");
    }

    private void checkEglError(String msg) {
        int error = EGL14.eglGetError();
        if (error != 12288) {
            throw new RuntimeException(msg + ": EGL error: 0x" + Integer.toHexString(error));
        }
    }
}

