/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utilities.videocompressor.videoslimmer;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.media.MediaMuxer;
import android.os.Build;
import android.support.annotation.RequiresApi;
import io.rong.common.RLog;
import io.rong.imkit.utilities.videocompressor.videoslimmer.listner.SlimProgressListener;
import io.rong.imkit.utilities.videocompressor.videoslimmer.muxer.CodecInputSurface;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

public class VideoSlimEncoder {
    private static final String TAG = "VideoSlimEncoder";
    private static final boolean VERBOSE = true;
    private String path;
    private String outputPath;
    private static final String MIME_TYPE = "video/avc";
    private MediaCodec.BufferInfo mBufferInfo;
    private MediaMuxer mMuxer;
    private MediaCodec mEncoder;
    private MediaCodec mDecoder;
    private int mTrackIndex;
    private CodecInputSurface mInputSurface;
    private int mWidth = -1;
    private int mHeight = -1;
    private int mBitRate = -1;
    private static final int MEDIATYPE_NOT_AUDIO_VIDEO = -233;
    private static int FRAME_RATE = 25;
    private static int IFRAME_INTERVAL = 10;
    private final int TIMEOUT_USEC = 2500;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=18)
    public boolean convertVideo(String sourcePath, String destinationPath, int nwidth, int nheight, int nbitrate, SlimProgressListener listener) {
        this.path = sourcePath;
        this.outputPath = destinationPath;
        if (this.checkParmsError(nwidth, nheight, nbitrate)) {
            return false;
        }
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        retriever.setDataSource(this.path);
        String width = retriever.extractMetadata(18);
        String height = retriever.extractMetadata(19);
        String rotation = retriever.extractMetadata(24);
        long duration = Long.valueOf(retriever.extractMetadata(9)) * 1000L;
        long startTime = -1L;
        long endTime = -1L;
        int originalWidth = Integer.valueOf(width);
        int originalHeight = Integer.valueOf(height);
        this.mBitRate = nbitrate;
        this.mWidth = nwidth;
        this.mHeight = nheight;
        boolean error = false;
        long videoStartTime = -1L;
        long time = System.currentTimeMillis();
        File cacheFile = new File(destinationPath);
        File inputFile = new File(this.path);
        if (!inputFile.canRead()) {
            return false;
        }
        MediaExtractor extractor = null;
        MediaExtractor mAudioExtractor = null;
        try {
            extractor = new MediaExtractor();
            extractor.setDataSource(inputFile.toString());
            mAudioExtractor = new MediaExtractor();
            mAudioExtractor.setDataSource(inputFile.toString());
            try {
                this.mMuxer = new MediaMuxer(this.outputPath, 0);
            }
            catch (IOException ioe) {
                throw new RuntimeException("MediaMuxer creation failed", ioe);
            }
            int muxerAudioTrackIndex = 0;
            int audioIndex = this.selectTrack(mAudioExtractor, true);
            if (audioIndex >= 0) {
                mAudioExtractor.selectTrack(audioIndex);
                mAudioExtractor.seekTo(0L, 0);
                MediaFormat trackFormat = mAudioExtractor.getTrackFormat(audioIndex);
                muxerAudioTrackIndex = this.mMuxer.addTrack(trackFormat);
            }
            if (nwidth != originalWidth || nheight != originalHeight) {
                int videoIndex = this.selectTrack(extractor, false);
                if (videoIndex >= 0) {
                    long videoTime = -1L;
                    boolean outputDone = false;
                    boolean inputDone = false;
                    boolean decoderDone = false;
                    boolean swapUV = false;
                    int videoTrackIndex = -233;
                    extractor.selectTrack(videoIndex);
                    if (startTime > 0L) {
                        extractor.seekTo(startTime, 0);
                    } else {
                        extractor.seekTo(0L, 0);
                    }
                    MediaFormat inputFormat = extractor.getTrackFormat(videoIndex);
                    this.prepareEncoder(inputFormat);
                    ByteBuffer[] decoderInputBuffers = null;
                    ByteBuffer[] encoderOutputBuffers = null;
                    decoderInputBuffers = this.mDecoder.getInputBuffers();
                    encoderOutputBuffers = this.mEncoder.getOutputBuffers();
                    while (!outputDone) {
                        if (!inputDone) {
                            int inputBufIndex;
                            boolean eof = false;
                            int index = extractor.getSampleTrackIndex();
                            if (index == videoIndex) {
                                inputBufIndex = this.mDecoder.dequeueInputBuffer(2500L);
                                if (inputBufIndex >= 0) {
                                    ByteBuffer inputBuf = Build.VERSION.SDK_INT < 21 ? decoderInputBuffers[inputBufIndex] : this.mDecoder.getInputBuffer(inputBufIndex);
                                    int chunkSize = extractor.readSampleData(inputBuf, 0);
                                    if (chunkSize < 0) {
                                        this.mDecoder.queueInputBuffer(inputBufIndex, 0, 0, 0L, 4);
                                        inputDone = true;
                                    } else {
                                        this.mDecoder.queueInputBuffer(inputBufIndex, 0, chunkSize, extractor.getSampleTime(), 0);
                                        extractor.advance();
                                    }
                                }
                            } else if (index == -1) {
                                eof = true;
                            }
                            if (eof && (inputBufIndex = this.mDecoder.dequeueInputBuffer(2500L)) >= 0) {
                                this.mDecoder.queueInputBuffer(inputBufIndex, 0, 0, 0L, 4);
                                inputDone = true;
                            }
                        }
                        boolean decoderOutputAvailable = !decoderDone;
                        boolean encoderOutputAvailable = true;
                        while (decoderOutputAvailable || encoderOutputAvailable) {
                            int encoderStatus = this.mEncoder.dequeueOutputBuffer(this.mBufferInfo, 2500L);
                            if (encoderStatus == -1) {
                                encoderOutputAvailable = false;
                            } else if (encoderStatus == -3) {
                                if (Build.VERSION.SDK_INT < 21) {
                                    encoderOutputBuffers = this.mEncoder.getOutputBuffers();
                                }
                            } else if (encoderStatus == -2) {
                                MediaFormat newFormat = this.mEncoder.getOutputFormat();
                                if (videoTrackIndex == -233) {
                                    this.mTrackIndex = videoTrackIndex = this.mMuxer.addTrack(newFormat);
                                    this.mMuxer.start();
                                }
                            } else {
                                if (encoderStatus < 0) {
                                    throw new RuntimeException("unexpected result from mEncoder.dequeueOutputBuffer: " + encoderStatus);
                                }
                                ByteBuffer encodedData = Build.VERSION.SDK_INT < 21 ? encoderOutputBuffers[encoderStatus] : this.mEncoder.getOutputBuffer(encoderStatus);
                                if (encodedData == null) {
                                    throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                                }
                                if (this.mBufferInfo.size > 1) {
                                    if ((this.mBufferInfo.flags & 2) == 0) {
                                        this.mMuxer.writeSampleData(videoTrackIndex, encodedData, this.mBufferInfo);
                                    } else if (videoTrackIndex == -233) {
                                        byte[] csd = new byte[this.mBufferInfo.size];
                                        encodedData.limit(this.mBufferInfo.offset + this.mBufferInfo.size);
                                        encodedData.position(this.mBufferInfo.offset);
                                        encodedData.get(csd);
                                        ByteBuffer sps = null;
                                        ByteBuffer pps = null;
                                        for (int a = this.mBufferInfo.size - 1; a >= 0 && a > 3; --a) {
                                            if (csd[a] != 1 || csd[a - 1] != 0 || csd[a - 2] != 0 || csd[a - 3] != 0) continue;
                                            sps = ByteBuffer.allocate(a - 3);
                                            pps = ByteBuffer.allocate(this.mBufferInfo.size - (a - 3));
                                            sps.put(csd, 0, a - 3).position(0);
                                            pps.put(csd, a - 3, this.mBufferInfo.size - (a - 3)).position(0);
                                            break;
                                        }
                                        MediaFormat newFormat = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)nwidth, (int)nheight);
                                        if (sps != null && pps != null) {
                                            newFormat.setByteBuffer("csd-0", sps);
                                            newFormat.setByteBuffer("csd-1", pps);
                                        }
                                        videoTrackIndex = this.mMuxer.addTrack(newFormat);
                                        this.mMuxer.start();
                                    }
                                }
                                outputDone = (this.mBufferInfo.flags & 4) != 0;
                                this.mEncoder.releaseOutputBuffer(encoderStatus, false);
                            }
                            if (encoderStatus != -1 || decoderDone) continue;
                            int decoderStatus = this.mDecoder.dequeueOutputBuffer(this.mBufferInfo, 2500L);
                            if (decoderStatus == -1) {
                                decoderOutputAvailable = false;
                                continue;
                            }
                            if (decoderStatus == -3) continue;
                            if (decoderStatus == -2) {
                                MediaFormat csd = this.mDecoder.getOutputFormat();
                                continue;
                            }
                            if (decoderStatus < 0) {
                                throw new RuntimeException("unexpected result from mDecoder.dequeueOutputBuffer: " + decoderStatus);
                            }
                            boolean doRender = false;
                            boolean bl = doRender = this.mBufferInfo.size != 0;
                            if (endTime > 0L && this.mBufferInfo.presentationTimeUs >= endTime) {
                                inputDone = true;
                                decoderDone = true;
                                doRender = false;
                                this.mBufferInfo.flags |= 4;
                            }
                            if (startTime > 0L && videoTime == -1L) {
                                if (this.mBufferInfo.presentationTimeUs < startTime) {
                                    doRender = false;
                                } else {
                                    videoTime = this.mBufferInfo.presentationTimeUs;
                                }
                            }
                            this.mDecoder.releaseOutputBuffer(decoderStatus, doRender);
                            if (doRender) {
                                boolean errorWait = false;
                                try {
                                    this.mInputSurface.awaitNewImage();
                                }
                                catch (Exception e) {
                                    errorWait = true;
                                    RLog.e((String)TAG, (String)e.getMessage());
                                }
                                if (!errorWait) {
                                    this.mInputSurface.drawImage();
                                    this.mInputSurface.setPresentationTime(this.mBufferInfo.presentationTimeUs * 1000L);
                                    if (listener != null) {
                                        listener.onProgress((float)this.mBufferInfo.presentationTimeUs / (float)duration * 100.0f);
                                    }
                                    this.mInputSurface.swapBuffers();
                                }
                            }
                            if ((this.mBufferInfo.flags & 4) == 0) continue;
                            decoderOutputAvailable = false;
                            this.mEncoder.signalEndOfInputStream();
                        }
                    }
                    if (videoTime != -1L) {
                        videoStartTime = videoTime;
                    }
                }
                extractor.unselectTrack(videoIndex);
            } else {
                long videoTime = this.simpleReadAndWriteTrack(extractor, this.mMuxer, this.mBufferInfo, startTime, endTime, false);
                if (videoTime != -1L) {
                    videoStartTime = videoTime;
                }
            }
            this.writeAudioTrack(mAudioExtractor, this.mMuxer, this.mBufferInfo, videoStartTime, endTime, cacheFile, muxerAudioTrackIndex);
        }
        catch (Exception e) {
            error = true;
            RLog.e((String)TAG, (String)e.getMessage());
        }
        finally {
            if (extractor != null) {
                extractor.release();
                extractor = null;
            }
            if (mAudioExtractor != null) {
                mAudioExtractor.release();
                mAudioExtractor = null;
            }
        }
        boolean b = this.releaseCoder();
        return !error || b;
    }

    private boolean checkParmsError(int nwidth, int nheight, int nbitrate) {
        return nwidth <= 0 || nheight <= 0 || nbitrate <= 0;
    }

    @RequiresApi(api=18)
    private long simpleReadAndWriteTrack(MediaExtractor extractor, MediaMuxer mediaMuxer, MediaCodec.BufferInfo info, long start, long end, boolean isAudio) throws Exception {
        int trackIndex = this.selectTrack(extractor, isAudio);
        if (trackIndex >= 0) {
            extractor.selectTrack(trackIndex);
            MediaFormat trackFormat = extractor.getTrackFormat(trackIndex);
            int muxerTrackIndex = mediaMuxer.addTrack(trackFormat);
            if (!isAudio) {
                mediaMuxer.start();
            }
            int maxBufferSize = trackFormat.getInteger("max-input-size");
            boolean inputDone = false;
            if (start > 0L) {
                extractor.seekTo(start, 0);
            } else {
                extractor.seekTo(0L, 0);
            }
            ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
            long startTime = -1L;
            while (!inputDone) {
                boolean eof = false;
                int index = extractor.getSampleTrackIndex();
                if (index == trackIndex) {
                    info.size = extractor.readSampleData(buffer, 0);
                    if (info.size < 0) {
                        info.size = 0;
                        eof = true;
                    } else {
                        info.presentationTimeUs = extractor.getSampleTime();
                        if (start > 0L && startTime == -1L) {
                            startTime = info.presentationTimeUs;
                        }
                        if (end < 0L || info.presentationTimeUs < end) {
                            info.offset = 0;
                            info.flags = extractor.getSampleFlags();
                            mediaMuxer.writeSampleData(muxerTrackIndex, buffer, info);
                            extractor.advance();
                        } else {
                            eof = true;
                        }
                    }
                } else if (index == -1) {
                    eof = true;
                }
                if (!eof) continue;
                inputDone = true;
            }
            extractor.unselectTrack(trackIndex);
            return startTime;
        }
        return -1L;
    }

    @RequiresApi(api=18)
    private long writeAudioTrack(MediaExtractor extractor, MediaMuxer mediaMuxer, MediaCodec.BufferInfo info, long start, long end, File file, int muxerTrackIndex) throws Exception {
        int trackIndex = this.selectTrack(extractor, true);
        if (trackIndex >= 0) {
            extractor.selectTrack(trackIndex);
            MediaFormat trackFormat = extractor.getTrackFormat(trackIndex);
            int maxBufferSize = trackFormat.getInteger("max-input-size");
            boolean inputDone = false;
            if (start > 0L) {
                extractor.seekTo(start, 0);
            } else {
                extractor.seekTo(0L, 0);
            }
            ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
            long startTime = -1L;
            while (!inputDone) {
                boolean eof = false;
                int index = extractor.getSampleTrackIndex();
                if (index == trackIndex) {
                    info.size = extractor.readSampleData(buffer, 0);
                    if (info.size < 0) {
                        info.size = 0;
                        eof = true;
                    } else {
                        info.presentationTimeUs = extractor.getSampleTime();
                        if (start > 0L && startTime == -1L) {
                            startTime = info.presentationTimeUs;
                        }
                        if (end < 0L || info.presentationTimeUs < end) {
                            info.offset = 0;
                            info.flags = extractor.getSampleFlags();
                            mediaMuxer.writeSampleData(muxerTrackIndex, buffer, info);
                            extractor.advance();
                        } else {
                            eof = true;
                        }
                    }
                } else if (index == -1) {
                    eof = true;
                }
                if (!eof) continue;
                inputDone = true;
            }
            extractor.unselectTrack(trackIndex);
            return startTime;
        }
        return -1L;
    }

    private int selectTrack(MediaExtractor extractor, boolean audio) {
        int numTracks = extractor.getTrackCount();
        for (int i = 0; i < numTracks; ++i) {
            MediaFormat format = extractor.getTrackFormat(i);
            String mime = format.getString("mime");
            if (!(audio ? mime.startsWith("audio/") : mime.startsWith("video/"))) continue;
            return i;
        }
        return -233;
    }

    @RequiresApi(api=18)
    private void prepareEncoder(MediaFormat inputFormat) {
        this.mBufferInfo = new MediaCodec.BufferInfo();
        MediaFormat format = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)this.mWidth, (int)this.mHeight);
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", this.mBitRate);
        format.setInteger("frame-rate", FRAME_RATE);
        format.setInteger("i-frame-interval", IFRAME_INTERVAL);
        RLog.d((String)TAG, (String)("format: " + format));
        try {
            this.mEncoder = MediaCodec.createEncoderByType((String)MIME_TYPE);
        }
        catch (IOException e) {
            RLog.d((String)TAG, (String)("prepareEncoder:" + e));
        }
        this.mEncoder.configure(format, null, null, 1);
        this.mInputSurface = new CodecInputSurface(this.mEncoder.createInputSurface());
        this.mInputSurface.makeCurrent();
        this.mEncoder.start();
        try {
            this.mDecoder = MediaCodec.createDecoderByType((String)inputFormat.getString("mime"));
        }
        catch (IOException e) {
            RLog.d((String)TAG, (String)("prepareEncoder:" + e));
        }
        this.mInputSurface.createRender();
        this.mDecoder.configure(inputFormat, this.mInputSurface.getSurface(), null, 0);
        this.mDecoder.start();
        this.mTrackIndex = -1;
    }

    @RequiresApi(api=18)
    private boolean releaseCoder() {
        RLog.d((String)TAG, (String)"releasing encoder objects");
        if (this.mEncoder != null) {
            this.mEncoder.stop();
            this.mEncoder.release();
            this.mEncoder = null;
        }
        if (this.mDecoder != null) {
            this.mDecoder.stop();
            this.mDecoder.release();
            this.mDecoder = null;
        }
        if (this.mInputSurface != null) {
            this.mInputSurface.release();
            this.mInputSurface = null;
        }
        if (this.mMuxer != null) {
            try {
                this.mMuxer.stop();
                this.mMuxer.release();
            }
            catch (Exception e) {
                RLog.e((String)TAG, (String)"mMuxer fail");
                boolean bl = false;
                return bl;
            }
            finally {
                this.mMuxer = null;
            }
        }
        return true;
    }
}

