/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utilities.videocompressor;

import android.os.AsyncTask;
import io.rong.imkit.utilities.videocompressor.VideoController;

public class VideoCompress {
    private static final String TAG = VideoCompress.class.getSimpleName();

    public static VideoCompressTask compressVideo(String srcPath, String destPath, CompressListener listener) {
        VideoCompressTask task = new VideoCompressTask(listener);
        task.execute(new String[]{srcPath, destPath});
        return task;
    }

    public static interface CompressListener {
        public void onStart();

        public void onSuccess();

        public void onFail();

        public void onProgress(float var1);
    }

    private static class VideoCompressTask
    extends AsyncTask<String, Float, Boolean> {
        private CompressListener mListener;

        public VideoCompressTask(CompressListener listener) {
            this.mListener = listener;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            if (this.mListener != null) {
                this.mListener.onStart();
            }
        }

        protected Boolean doInBackground(String ... paths) {
            return VideoController.getInstance().convertVideo(paths[0], paths[1], new VideoController.CompressProgressListener(){

                @Override
                public void onProgress(float percent) {
                    VideoCompressTask.this.publishProgress(new Float[]{Float.valueOf(percent)});
                }
            });
        }

        protected void onProgressUpdate(Float ... percent) {
            super.onProgressUpdate((Object[])percent);
            if (this.mListener != null) {
                this.mListener.onProgress(percent[0].floatValue());
            }
        }

        protected void onPostExecute(Boolean result) {
            super.onPostExecute((Object)result);
            if (this.mListener != null) {
                if (result.booleanValue()) {
                    this.mListener.onSuccess();
                } else {
                    this.mListener.onFail();
                }
            }
        }
    }
}

