/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utilities;

import android.content.Context;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.ExifInterface;
import android.media.MediaPlayer;
import android.net.Uri;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.rong.common.LibStorageUtils;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.utilities.KitStorageUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class RongUtils {
    private static final String TAG = RongUtils.class.getSimpleName();
    private static double RATIO = 0.85;
    public static int screenWidth;
    public static int screenHeight;
    public static int screenMin;
    public static int screenMax;
    public static float density;
    public static float scaleDensity;
    public static float xdpi;
    public static float ydpi;
    public static int densityDpi;
    public static int dialogWidth;
    public static int statusbarheight;
    public static int navbarheight;

    public static int dip2px(float dipValue) {
        return (int)(dipValue * density + 0.5f);
    }

    public static int px2dip(float pxValue) {
        return (int)(pxValue / density + 0.5f);
    }

    public static int getDialogWidth() {
        dialogWidth = (int)((double)screenMin * RATIO);
        return dialogWidth;
    }

    public static void init(Context context) {
        if (null == context) {
            return;
        }
        DisplayMetrics dm = context.getApplicationContext().getResources().getDisplayMetrics();
        screenWidth = dm.widthPixels;
        screenHeight = dm.heightPixels;
        screenMin = screenWidth > screenHeight ? screenHeight : screenWidth;
        density = dm.density;
        scaleDensity = dm.scaledDensity;
        xdpi = dm.xdpi;
        ydpi = dm.ydpi;
        densityDpi = dm.densityDpi;
    }

    public static void GetInfo(Context context) {
        if (null == context) {
            return;
        }
        DisplayMetrics dm = context.getApplicationContext().getResources().getDisplayMetrics();
        screenWidth = dm.widthPixels;
        screenHeight = dm.heightPixels;
        screenMin = screenWidth > screenHeight ? screenHeight : screenWidth;
        screenMax = screenWidth < screenHeight ? screenHeight : screenWidth;
        density = dm.density;
        scaleDensity = dm.scaledDensity;
        xdpi = dm.xdpi;
        ydpi = dm.ydpi;
        densityDpi = dm.densityDpi;
        statusbarheight = RongUtils.getStatusBarHeight(context);
        navbarheight = RongUtils.getNavBarHeight(context);
        Log.d((String)TAG, (String)("screenWidth=" + screenWidth + " screenHeight=" + screenHeight + " density=" + density));
    }

    public static View getHorizontalThinLine(Context context) {
        View line = new View(context);
        line.setBackgroundColor(context.getResources().getColor(R.color.rc_divider_line));
        LinearLayout.LayoutParams llp = new LinearLayout.LayoutParams(-1, 1);
        line.setLayoutParams((ViewGroup.LayoutParams)llp);
        return line;
    }

    public static View getVerticalThinLine(Context context) {
        View line = new View(context);
        line.setBackgroundColor(context.getResources().getColor(R.color.rc_divider_line));
        LinearLayout.LayoutParams llp = new LinearLayout.LayoutParams(1, -1);
        line.setLayoutParams((ViewGroup.LayoutParams)llp);
        return line;
    }

    public static int getStatusBarHeight(Context context) {
        int sbar = 0;
        try {
            Class<?> c = Class.forName("com.android.internal.R$dimen");
            Object obj = c.newInstance();
            Field field = c.getField("status_bar_height");
            int x = Integer.parseInt(field.get(obj).toString());
            sbar = context.getResources().getDimensionPixelSize(x);
        }
        catch (Exception E) {
            RLog.e((String)TAG, (String)"getStatusBarHeight", (Throwable)E);
        }
        return sbar;
    }

    public static int getScreenWidth() {
        return screenWidth;
    }

    public static int getScreenHeight() {
        return screenHeight;
    }

    public static int getNavBarHeight(Context context) {
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return resources.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Drawable getDrawable(Context context, String resource) {
        InputStream is = null;
        try {
            Resources resources = context.getResources();
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inDensity = 240;
            options.inScreenDensity = resources.getDisplayMetrics().densityDpi;
            options.inTargetDensity = resources.getDisplayMetrics().densityDpi;
            is = context.getAssets().open(resource);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, (Rect)new Rect(), (BitmapFactory.Options)options);
            BitmapDrawable bitmapDrawable = new BitmapDrawable(context.getResources(), bitmap);
            return bitmapDrawable;
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)"getDrawable", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    RLog.e((String)TAG, (String)"getDrawable", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static Bitmap getResizedBitmap(Context context, Uri uri, int widthLimit, int heightLimit) throws IOException {
        Bitmap result;
        Bitmap bitmap;
        String path;
        if (uri.getScheme().equals("file")) {
            path = uri.getPath();
        } else if (uri.getScheme().equals("content")) {
            Cursor cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null);
            cursor.moveToFirst();
            path = cursor.getString(0);
            cursor.close();
        } else {
            return null;
        }
        ExifInterface exifInterface = new ExifInterface(path);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        int orientation = exifInterface.getAttributeInt("Orientation", 0);
        if (orientation == 6 || orientation == 8 || orientation == 5 || orientation == 7) {
            int tmp = widthLimit;
            widthLimit = heightLimit;
            heightLimit = tmp;
        }
        int width = options.outWidth;
        int height = options.outHeight;
        int sampleW = 1;
        int sampleH = 1;
        while (width / 2 > widthLimit) {
            width /= 2;
            sampleW <<= 1;
        }
        while (height / 2 > heightLimit) {
            height /= 2;
            sampleH <<= 1;
        }
        int sampleSize = 1;
        options = new BitmapFactory.Options();
        options.inSampleSize = sampleSize = Math.max(sampleW, sampleH);
        try {
            bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError e) {
            RLog.e((String)TAG, (String)"getResizedBitmap", (Throwable)e);
            options.inSampleSize <<= 1;
            bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        }
        Matrix matrix = new Matrix();
        if (bitmap == null) {
            return bitmap;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        if (orientation == 6 || orientation == 8 || orientation == 5 || orientation == 7) {
            int tmp = w;
            w = h;
            h = tmp;
        }
        switch (orientation) {
            case 6: {
                matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 3: {
                matrix.setRotate(180.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 8: {
                matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 2: {
                matrix.preScale(-1.0f, 1.0f);
                break;
            }
            case 4: {
                matrix.preScale(1.0f, -1.0f);
                break;
            }
            case 5: {
                matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                matrix.preScale(1.0f, -1.0f);
                break;
            }
            case 7: {
                matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                matrix.preScale(1.0f, -1.0f);
            }
        }
        float xS = (float)widthLimit / (float)bitmap.getWidth();
        float yS = (float)heightLimit / (float)bitmap.getHeight();
        matrix.postScale(Math.min(xS, yS), Math.min(xS, yS));
        try {
            result = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError e) {
            RLog.e((String)TAG, (String)"getResizedBitmap", (Throwable)e);
            Log.e((String)"ResourceCompressHandler", (String)("OOMHeight:" + bitmap.getHeight() + "Width:" + bitmap.getHeight() + "matrix:" + xS + " " + yS));
            return null;
        }
        return result;
    }

    public static int getVideoDuration(Context context, String videoPath) {
        try {
            MediaPlayer mp = MediaPlayer.create((Context)context, (Uri)Uri.parse((String)videoPath));
            int duration = mp.getDuration();
            mp.release();
            return duration;
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)e.toString());
            return 0;
        }
    }

    public static String md5(Object object) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(RongUtils.toByteArray(object));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Huh, MD5 should be supported?", e);
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    private static byte[] toByteArray(Object obj) {
        byte[] bytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
            oos.close();
            bos.close();
        }
        catch (IOException ex) {
            RLog.e((String)TAG, (String)"toByteArray", (Throwable)ex);
        }
        return bytes;
    }

    @Deprecated
    public static String getImageSavePath(Context context) {
        return KitStorageUtils.getImageSavePath(context);
    }

    @Deprecated
    public static String getVideoSavePath(Context context) {
        return KitStorageUtils.getVideoSavePath(context);
    }

    @Deprecated
    public static String getFileSavePath(Context context) {
        return KitStorageUtils.getFileSavePath(context);
    }

    @Deprecated
    public static String getAppName(Context context) {
        return LibStorageUtils.getAppName((Context)context);
    }
}

