/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utilities;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import io.rong.common.FileUtils;
import io.rong.common.LibStorageUtils;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imlib.common.SavePathUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;

public class KitStorageUtils {
    private static final String TAG = "LibStorageUtils";
    private static final String IMAGE_PREFIX = "Rong_Image_";
    private static final String VIDEO_PREFIX = "Rong_Video_";
    private static final String VIDEO_SUFFIX = ".mp4";

    public static boolean isQMode(Context context) {
        return LibStorageUtils.isQMode((Context)context);
    }

    public static boolean isBuildAndTargetForQ(Context context) {
        return LibStorageUtils.isBuildAndTargetForQ((Context)context);
    }

    public static String getImageSavePath(Context context) {
        return KitStorageUtils.getSavePath(context, "image", R.string.rc_image_default_saved_path);
    }

    public static String getVideoSavePath(Context context) {
        return KitStorageUtils.getSavePath(context, "video", R.string.rc_video_default_saved_path);
    }

    public static String getFileSavePath(Context context) {
        return KitStorageUtils.getSavePath(context, "file", R.string.rc_file_default_saved_path);
    }

    public static String getSavePath(Context context, String type, @StringRes int res) {
        if (!SavePathUtils.isSavePathEmpty()) {
            String savePath = SavePathUtils.getSavePath();
            File imageDir = new File(savePath, type);
            if (!imageDir.exists() && !imageDir.mkdirs()) {
                RLog.e((String)TAG, (String)("getSavePath mkdirs error path is  " + imageDir.getAbsolutePath()));
            }
            return imageDir.getAbsolutePath();
        }
        boolean sdCardExist = Environment.getExternalStorageState().equals("mounted");
        String result = context.getCacheDir().getPath();
        if (!sdCardExist) {
            RLog.d((String)TAG, (String)"getSavePath error, sdcard does not exist.");
            return result;
        }
        if (KitStorageUtils.isQMode(context)) {
            File path = context.getExternalFilesDir("RongCloud");
            File file = new File(path, type);
            result = !file.exists() && !file.mkdirs() ? path.getPath() : file.getPath();
        } else {
            String path = Environment.getExternalStorageDirectory().getPath();
            String defaultPath = context.getString(res);
            StringBuilder builder = new StringBuilder(defaultPath);
            String appName = LibStorageUtils.getAppName((Context)context);
            if (!TextUtils.isEmpty((CharSequence)appName)) {
                builder.append(appName).append(File.separator);
            }
            String appPath = builder.toString();
            File dir = new File(path = path + appPath);
            if (!dir.exists() && !dir.mkdirs()) {
                RLog.e((String)TAG, (String)("mkdirs error path is  " + path));
                result = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getPath();
            } else {
                result = path;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyVideoToPublicDir(Context context, File file, String outputFileName) {
        if (file == null || !file.exists()) {
            RLog.e((String)TAG, (String)"file is not exist");
            return false;
        }
        boolean result = true;
        if (!KitStorageUtils.isBuildAndTargetForQ(context)) {
            boolean mkdirResult;
            File dirFile = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_MOVIES);
            if (dirFile != null && !dirFile.exists() && !(mkdirResult = dirFile.mkdirs())) {
                RLog.e((String)TAG, (String)("mkdir fail,dir path is " + dirFile.getAbsolutePath()));
                return false;
            }
            if (dirFile == null) {
                RLog.e((String)TAG, (String)"dirFile is null");
                return false;
            }
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                String name;
                if (!TextUtils.isEmpty((CharSequence)outputFileName)) {
                    name = outputFileName;
                } else {
                    name = VIDEO_PREFIX + System.currentTimeMillis();
                    String suffix = FileUtils.getSuffix((String)file.getName());
                    name = suffix != null ? name + "." + suffix : name + VIDEO_SUFFIX;
                }
                String filePath = dirFile.getPath() + "/" + name;
                fis = new FileInputStream(file);
                fos = new FileOutputStream(filePath);
                KitStorageUtils.copy(fis, fos);
                File destFile = new File(filePath);
                KitStorageUtils.updatePhotoMedia(destFile, context);
            }
            catch (FileNotFoundException e) {
                result = false;
                RLog.e((String)TAG, (String)"copyVideoToPublicDir file not found", (Throwable)e);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    RLog.e((String)TAG, (String)"copyVideoToPublicDir: ", (Throwable)e);
                }
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    RLog.e((String)TAG, (String)"copyVideoToPublicDir: ", (Throwable)e);
                }
            }
        } else {
            result = KitStorageUtils.copyVideoToPublicDirForQ(context, file, outputFileName);
        }
        return result;
    }

    public static void updatePhotoMedia(File file, Context context) {
        if (file != null && file.exists()) {
            Intent intent = new Intent();
            intent.setAction("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
            intent.setData(Uri.fromFile((File)file));
            context.sendBroadcast(intent);
        }
    }

    private static boolean copyVideoToPublicDirForQ(Context context, File file, String outputFileName) {
        boolean result = true;
        String filePath = "";
        if (file.exists() && file.isFile() && context != null) {
            String name = !TextUtils.isEmpty((CharSequence)outputFileName) ? outputFileName : file.getName();
            Uri uri = KitStorageUtils.insertVideoIntoMediaStore(context, name);
            if (uri != null) {
                filePath = uri.getPath();
            }
            try {
                ParcelFileDescriptor w = context.getContentResolver().openFileDescriptor(uri, "w");
                KitStorageUtils.writeToPublicDir(file, w);
            }
            catch (FileNotFoundException pE) {
                RLog.e((String)TAG, (String)("copyVideoToPublicDir uri is not Found, uri is" + uri.toString()));
                result = false;
            }
            File destFile = new File(filePath);
            KitStorageUtils.updatePhotoMedia(destFile, context);
        } else {
            RLog.e((String)TAG, (String)"file is not Found or context is null ");
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyImageToPublicDir(Context pContext, File pFile, String outputFileName) {
        boolean result = true;
        File file = pFile;
        if (file.exists() && file.isFile() && pContext != null) {
            if (!KitStorageUtils.isBuildAndTargetForQ(pContext)) {
                boolean mkdirResult;
                File dirFile = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
                if (dirFile != null && !dirFile.exists() && !(mkdirResult = dirFile.mkdirs())) {
                    RLog.e((String)TAG, (String)("mkdir fail,dir path is " + dirFile.getAbsolutePath()));
                    return false;
                }
                if (dirFile == null) {
                    RLog.e((String)TAG, (String)"dirFile is null");
                    return false;
                }
                FileInputStream fis = null;
                FileOutputStream fos = null;
                try {
                    String name;
                    if (!TextUtils.isEmpty((CharSequence)outputFileName)) {
                        name = outputFileName;
                    } else {
                        String imgMimeType = KitStorageUtils.getImgMimeType(file);
                        int i = imgMimeType.lastIndexOf(47);
                        name = IMAGE_PREFIX + System.currentTimeMillis();
                        if (i != -1) {
                            name = name + "." + imgMimeType.substring(i + 1);
                        }
                    }
                    String filePath = dirFile.getPath() + "/" + name;
                    fis = new FileInputStream(file);
                    fos = new FileOutputStream(filePath);
                    KitStorageUtils.copy(fis, fos);
                    File destFile = new File(filePath);
                    KitStorageUtils.updatePhotoMedia(destFile, pContext);
                }
                catch (FileNotFoundException e) {
                    result = false;
                    RLog.e((String)TAG, (String)"copyImageToPublicDir file not found", (Throwable)e);
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException e) {
                        RLog.e((String)TAG, (String)"copyImageToPublicDir: ", (Throwable)e);
                    }
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException e) {
                        RLog.e((String)TAG, (String)"copyImageToPublicDir: ", (Throwable)e);
                    }
                }
            } else {
                String name;
                String imgMimeType = KitStorageUtils.getImgMimeType(file);
                if (!TextUtils.isEmpty((CharSequence)outputFileName)) {
                    name = outputFileName;
                } else {
                    int i = imgMimeType.lastIndexOf(47);
                    name = IMAGE_PREFIX + System.currentTimeMillis();
                    if (i != -1) {
                        name = name + "." + imgMimeType.substring(i + 1);
                    }
                }
                Uri uri = KitStorageUtils.insertImageIntoMediaStore(pContext, name, imgMimeType);
                try {
                    ParcelFileDescriptor w = pContext.getContentResolver().openFileDescriptor(uri, "w");
                    KitStorageUtils.writeToPublicDir(file, w);
                }
                catch (FileNotFoundException pE) {
                    result = false;
                    RLog.e((String)TAG, (String)("copyImageToPublicDir uri is not Found, uri is" + uri.toString()));
                }
            }
        } else {
            result = false;
            RLog.e((String)TAG, (String)"file is not Found or context is null ");
        }
        return result;
    }

    public static Uri insertImageIntoMediaStore(Context context, String fileName, String mimeType) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("_display_name", fileName);
        contentValues.put("datetaken", Long.valueOf(System.currentTimeMillis()));
        contentValues.put("mime_type", mimeType);
        Uri uri = context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
        return uri;
    }

    public static Uri insertVideoIntoMediaStore(Context context, String fileName) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("_display_name", fileName);
        contentValues.put("datetaken", Long.valueOf(System.currentTimeMillis()));
        contentValues.put("mime_type", "video/mp4");
        Uri uri = context.getContentResolver().insert(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, contentValues);
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToPublicDir(File pFile, ParcelFileDescriptor pParcelFileDescriptor) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(pFile);
            fos = new FileOutputStream(pParcelFileDescriptor.getFileDescriptor());
            KitStorageUtils.copy(fis, fos);
        }
        catch (FileNotFoundException pE) {
            RLog.e((String)TAG, (String)("writeToPublicDir file is not found file path is " + pFile.getAbsolutePath()));
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                RLog.e((String)TAG, (String)"writeToPublicDir: ", (Throwable)e);
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                RLog.e((String)TAG, (String)"writeToPublicDir: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void read(ParcelFileDescriptor parcelFileDescriptor, File dst) throws IOException {
        try (FileInputStream istream = new FileInputStream(parcelFileDescriptor.getFileDescriptor());
             FileOutputStream ostream = new FileOutputStream(dst);){
            KitStorageUtils.copy(istream, ostream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(FileInputStream ist, FileOutputStream ost) {
        if (ist == null || ost == null) {
            return;
        }
        FileChannel fileChannelInput = null;
        FileChannel fileChannelOutput = null;
        try {
            fileChannelInput = ist.getChannel();
            fileChannelOutput = ost.getChannel();
            fileChannelInput.transferTo(0L, fileChannelInput.size(), fileChannelOutput);
        }
        catch (IOException e) {
            RLog.e((String)TAG, (String)"copy method error", (Throwable)e);
        }
        finally {
            try {
                ist.close();
                if (fileChannelInput != null) {
                    fileChannelInput.close();
                }
                ost.close();
                if (fileChannelOutput != null) {
                    fileChannelOutput.close();
                }
            }
            catch (IOException e) {
                RLog.e((String)TAG, (String)"copy method error", (Throwable)e);
            }
        }
    }

    public static String getImgMimeType(File imgFile) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imgFile.getPath(), (BitmapFactory.Options)options);
        return options.outMimeType;
    }

    public Uri getContentUri(int type, String id2) {
        Uri uri;
        switch (type) {
            case 0: {
                uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI.buildUpon().appendPath(String.valueOf(id2)).build();
                break;
            }
            case 1: {
                uri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI.buildUpon().appendPath(String.valueOf(id2)).build();
                break;
            }
            case 2: {
                uri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI.buildUpon().appendPath(String.valueOf(id2)).build();
                break;
            }
            default: {
                uri = null;
            }
        }
        return uri;
    }

    public InputStream getFileInputStreamWithUri(Context pContext, Uri pUri) {
        FileInputStream inputStream = null;
        ContentResolver cr = pContext.getContentResolver();
        try {
            AssetFileDescriptor r = cr.openAssetFileDescriptor(pUri, "r");
            ParcelFileDescriptor parcelFileDescriptor = r.getParcelFileDescriptor();
            if (parcelFileDescriptor != null) {
                inputStream = new FileInputStream(parcelFileDescriptor.getFileDescriptor());
            }
        }
        catch (FileNotFoundException e) {
            RLog.e((String)TAG, (String)"getFileInputStreamWithUri: ", (Throwable)e);
        }
        return inputStream;
    }

    public static boolean saveMediaToPublicDir(Context context, File file, String type) {
        return KitStorageUtils.saveMediaToPublicDir(context, file, null, type);
    }

    public static boolean saveMediaToPublicDir(Context context, File file, String outputFileName, String type) {
        if ("image".equals(type)) {
            return KitStorageUtils.copyImageToPublicDir(context, file, outputFileName);
        }
        if ("video".equals(type)) {
            return KitStorageUtils.copyVideoToPublicDir(context, file, outputFileName);
        }
        RLog.i((String)TAG, (String)"type is error");
        return false;
    }

    public static class MediaType {
        public static final String IMAGE = "image";
        public static final String VIDEO = "video";
    }
}

