/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utilities;

import android.content.Context;
import android.content.SharedPreferences;
import io.rong.imlib.common.SharedPreferencesUtils;
import io.rong.imlib.model.Conversation;
import java.util.ArrayList;
import java.util.List;

public class ExtensionHistoryUtil {
    private static boolean enableHistory;
    private static final String EMOJI_POS = "EMOJI_POS";
    private static final String EXTENSION_BAR_STATE = "EXTENSION_BAR_STATE";
    private static List<Conversation.ConversationType> sExceptConversationTypes;

    public static void setEnableHistory(boolean enable) {
        enableHistory = enable;
    }

    public static void addExceptConversationType(Conversation.ConversationType conversationType) {
        sExceptConversationTypes.add(conversationType);
    }

    public static void setEmojiPosition(Context context, String id2, int position) {
        if (enableHistory) {
            SharedPreferences sp = SharedPreferencesUtils.get((Context)context, (String)"RongKitConfig", (int)0);
            sp.edit().putInt(id2 + EMOJI_POS, position).commit();
        }
    }

    public static int getEmojiPosition(Context context, String id2) {
        if (!enableHistory) {
            return 0;
        }
        SharedPreferences sp = SharedPreferencesUtils.get((Context)context, (String)"RongKitConfig", (int)0);
        return sp.getInt(id2 + EMOJI_POS, 0);
    }

    public static void setExtensionBarState(Context context, String id2, Conversation.ConversationType conversationType, ExtensionBarState state) {
        if (enableHistory && !sExceptConversationTypes.contains(conversationType)) {
            SharedPreferences sp = SharedPreferencesUtils.get((Context)context, (String)"RongKitConfig", (int)0);
            sp.edit().putString(id2 + EXTENSION_BAR_STATE, state.toString()).commit();
        }
    }

    public static ExtensionBarState getExtensionBarState(Context context, String id2, Conversation.ConversationType conversationType) {
        if (!enableHistory || sExceptConversationTypes.contains(conversationType)) {
            return ExtensionBarState.NORMAL;
        }
        SharedPreferences sp = SharedPreferencesUtils.get((Context)context, (String)"RongKitConfig", (int)0);
        String v = sp.getString(id2 + EXTENSION_BAR_STATE, ExtensionBarState.NORMAL.toString());
        return ExtensionBarState.valueOf(v);
    }

    static {
        sExceptConversationTypes = new ArrayList<Conversation.ConversationType>();
    }

    public static enum ExtensionBarState {
        NORMAL,
        VOICE;

    }
}

