/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.userInfoCache;

import android.content.Context;
import android.content.ContextWrapper;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import io.rong.common.rlog.RLog;
import java.io.File;

public class RongDatabaseContext
extends ContextWrapper {
    private static final String TAG = "RongDatabaseContext";
    private String mDirPath;

    public RongDatabaseContext(Context context, String dirPath) {
        super(context);
        this.mDirPath = dirPath;
    }

    public File getDatabasePath(String name) {
        boolean successMkdir;
        File result = new File(this.mDirPath + File.separator + name);
        if (!result.getParentFile().exists() && !(successMkdir = result.getParentFile().mkdirs())) {
            RLog.e((String)TAG, (String)"Created folders UnSuccessfully");
        }
        return result;
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory) {
        return SQLiteDatabase.openOrCreateDatabase((File)this.getDatabasePath(name), (SQLiteDatabase.CursorFactory)factory);
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory, DatabaseErrorHandler errorHandler) {
        return SQLiteDatabase.openOrCreateDatabase((String)this.getDatabasePath(name).getAbsolutePath(), (SQLiteDatabase.CursorFactory)factory, (DatabaseErrorHandler)errorHandler);
    }
}

