/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.tools;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.net.http.SslError;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Base64;
import android.view.KeyEvent;
import android.webkit.JavascriptInterface;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import io.rong.common.FileUtils;
import io.rong.common.LibStorageUtils;
import io.rong.common.RLog;
import io.rong.common.RongWebView;
import io.rong.imkit.R;
import io.rong.imkit.RongBaseActivity;
import io.rong.imkit.RongContext;
import io.rong.imkit.activity.CombinePicturePagerActivity;
import io.rong.imkit.model.Event;
import io.rong.imkit.plugin.location.AMapPreviewActivity;
import io.rong.imkit.plugin.location.AMapPreviewActivity2D;
import io.rong.imkit.utilities.RongUtils;
import io.rong.imkit.utils.CombineMessageUtils;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.common.DeviceUtils;
import io.rong.imlib.common.NetUtils;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import io.rong.message.ImageMessage;
import io.rong.message.LocationMessage;
import io.rong.message.SightMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

public class CombineWebViewActivity
extends RongBaseActivity {
    private static final String TAG = CombineWebViewActivity.class.getSimpleName();
    private static final int VIDEO_WIDTH = 300;
    private static final int VIDEO_HEIGHT = 600;
    public static final String TYPE_LOCAL = "local";
    public static final String TYPE_MEDIA = "media";
    private static final String COMBINE_FILE_PATH = "combine";
    protected RongWebView mWebView;
    protected TextView mWebViewTitle;
    private ProgressBar mProgress;
    private ImageView mImageView;
    private TextView mTextView;
    private String mType;
    private int mMessageId;
    private String mPrevUrl;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.rc_combine_webview);
        this.initUI();
        this.initData();
        RongContext.getInstance().getEventBus().register((Object)this);
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private void initUI() {
        this.mWebView = (RongWebView)this.findViewById(R.id.rc_webview);
        this.mWebViewTitle = (TextView)this.findViewById(R.id.rc_action_bar_title);
        this.mProgress = (ProgressBar)this.findViewById(R.id.rc_web_progress);
        this.mImageView = (ImageView)this.findViewById(R.id.rc_web_download_failed);
        this.mTextView = (TextView)this.findViewById(R.id.rc_web_download_text);
        this.mWebView.setVerticalScrollbarOverlay(true);
        this.mWebView.setWebViewClient((WebViewClient)new CombineWebViewClient());
        if (NetUtils.isNetWorkAvailable((Context)this.getApplicationContext())) {
            this.mWebView.setWebChromeClient((WebChromeClient)new CombineWebChromeClient());
        }
        if (Build.VERSION.SDK_INT >= 17) {
            this.mWebView.addJavascriptInterface((Object)new JsInterface(), "interface");
        }
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.getSettings().setLoadWithOverviewMode(true);
        this.mWebView.getSettings().setUseWideViewPort(true);
        this.mWebView.getSettings().setBuiltInZoomControls(true);
        this.mWebView.getSettings().setSupportZoom(true);
        this.mWebView.getSettings().setDomStorageEnabled(true);
        this.mWebView.getSettings().setDefaultTextEncodingName("utf-8");
        this.mWebView.getSettings().setDisplayZoomControls(false);
        if (Build.VERSION.SDK_INT >= 17) {
            this.mWebView.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.mWebView.getSettings().setMixedContentMode(0);
        }
    }

    private void initData() {
        Intent intent = this.getIntent();
        if (intent == null) {
            return;
        }
        this.mMessageId = intent.getIntExtra("messageId", -1);
        String uri = intent.getStringExtra("uri");
        this.mType = intent.getStringExtra("type");
        String title = intent.getStringExtra("title");
        this.mPrevUrl = uri;
        this.mWebView.loadUrl(this.mPrevUrl);
        if (this.mWebViewTitle != null && !TextUtils.isEmpty((CharSequence)title)) {
            this.mWebViewTitle.setText((CharSequence)title);
        }
        this.onCreateActionbar(new RongBaseActivity.ActionBar());
    }

    private void openSight(JSONObject jsonObj) {
        String mediaUrl = jsonObj.optString("fileUrl");
        int duration = jsonObj.optInt("duration");
        String base64 = jsonObj.optString("imageBase64");
        int dotIndex = base64.indexOf(",");
        base64 = base64.substring(dotIndex + 1);
        EncodeFile encodeFile = new EncodeFile(mediaUrl, base64).invoke();
        String sightThumb = encodeFile.getThumb();
        String sightName = encodeFile.getName();
        SightMessage sightMessage = new SightMessage();
        sightMessage.setThumbUri(Uri.parse((String)("file://" + sightThumb + sightName)));
        sightMessage.setMediaUrl(Uri.parse((String)mediaUrl));
        sightMessage.setDuration(duration);
        if (new IsSightFileExists(sightMessage).invoke()) {
            String sightPath = LibStorageUtils.getMediaDownloadDir((Context)this.getApplicationContext(), (String)"video");
            String name = DeviceUtils.ShortMD5((int)2, (String[])new String[]{mediaUrl});
            if (sightPath.startsWith("file://")) {
                sightPath = sightPath.substring(7);
            }
            sightMessage.setLocalPath(Uri.parse((String)(sightPath + File.separator + name)));
        }
        Message message = new Message();
        message.setContent((MessageContent)sightMessage);
        message.setTargetId(RongIMClient.getInstance().getCurrentUserId());
        message.setConversationType(Conversation.ConversationType.PRIVATE);
        ComponentName cn = new ComponentName((Context)this, "io.rong.sight.player.SightPlayerActivity");
        Intent intent = new Intent();
        intent.setComponent(cn);
        intent.putExtra("Message", (Parcelable)message);
        intent.putExtra("SightMessage", (Parcelable)sightMessage);
        this.startActivity(intent);
    }

    private void openImage(JSONObject jsonObj) {
        String mediaUrl = jsonObj.optString("fileUrl");
        String base64 = jsonObj.optString("imgUrl");
        int dotIndex = base64.indexOf(",");
        base64 = base64.substring(dotIndex + 1);
        EncodeFile encodeFile = new EncodeFile(mediaUrl, base64).invoke();
        String thumb = encodeFile.getThumb();
        String name = encodeFile.getName();
        ImageMessage imageMessage = ImageMessage.obtain();
        imageMessage.setThumUri(Uri.parse((String)("file://" + thumb + name)));
        imageMessage.setRemoteUri(Uri.parse((String)mediaUrl));
        Message message = new Message();
        message.setContent((MessageContent)imageMessage);
        message.setConversationType(Conversation.ConversationType.PRIVATE);
        try {
            Intent intent = new Intent(this.getApplicationContext(), CombinePicturePagerActivity.class);
            intent.setPackage(this.getApplicationContext().getPackageName());
            intent.setFlags(0x10000000);
            intent.putExtra("message", (Parcelable)message);
            this.getApplicationContext().startActivity(intent);
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)"openImage", (Throwable)e);
        }
    }

    public String getCombineFilePath(String uri) {
        return FileUtils.getCachePath((Context)this.getApplicationContext()) + File.separator + COMBINE_FILE_PATH + File.separator;
    }

    private static boolean isImageFile(byte[] data) {
        if (data == null || data.length == 0) {
            return false;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
        return options.outWidth != -1;
    }

    private void openFile(JSONObject jsonObj) {
        Intent intent = new Intent("io.rong.imkit.intent.action.openwebfile");
        intent.setPackage(this.getPackageName());
        intent.putExtra("fileUrl", jsonObj.optString("fileUrl"));
        intent.putExtra("fileName", jsonObj.optString("fileName"));
        intent.putExtra("fileSize", jsonObj.optString("fileSize"));
        this.startActivity(intent);
    }

    private void openMap(JSONObject jsonObj) {
        double lat = Double.parseDouble(jsonObj.optString("latitude"));
        double lng = Double.parseDouble(jsonObj.optString("longitude"));
        String poi = jsonObj.optString("locationName");
        LocationMessage content = LocationMessage.obtain((double)lat, (double)lng, (String)poi, null);
        try {
            Intent intent = this.getApplicationContext().getResources().getBoolean(R.bool.rc_location_2D) ? new Intent((Context)this, AMapPreviewActivity2D.class) : new Intent((Context)this, AMapPreviewActivity.class);
            intent.putExtra("location", (Parcelable)content);
            intent.setFlags(0x10000000);
            this.startActivity(intent);
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)"openMap", (Throwable)e);
        }
    }

    private void openCombine(JSONObject jsonObj) {
        String type = TYPE_MEDIA;
        String uri = jsonObj.optString("fileUrl");
        String filePath = CombineMessageUtils.getInstance().getCombineFilePath(uri);
        if (new File(filePath).exists()) {
            uri = Uri.parse((String)("file://" + filePath)).toString();
            type = TYPE_LOCAL;
        }
        Intent intent = new Intent("io.rong.imkit.intent.action.combinewebview");
        intent.setPackage(this.getPackageName());
        intent.addFlags(0x10000000);
        intent.putExtra("uri", uri);
        intent.putExtra("type", type);
        intent.putExtra("title", jsonObj.optString("title"));
        this.startActivity(intent);
    }

    private void openLink(JSONObject jsonObj) {
        String link = jsonObj.optString("link");
        Intent intent = new Intent("io.rong.imkit.intent.action.webview");
        intent.setPackage(this.getPackageName());
        intent.putExtra("url", link);
        this.startActivity(intent);
    }

    private void openPhone(JSONObject jsonObj) {
        String phoneNumber = jsonObj.optString("phoneNum");
        Intent intent = new Intent("android.intent.action.DIAL");
        intent.setData(Uri.parse((String)("tel:" + phoneNumber)));
        this.startActivity(intent);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.mWebView.canGoBack()) {
            this.mWebView.goBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public void onEventMainThread(Event.RemoteMessageRecallEvent event) {
        if (this.mMessageId != -1 && this.mMessageId == event.getMessageId()) {
            new AlertDialog.Builder((Context)this, 5).setMessage((CharSequence)this.getString(R.string.rc_recall_success)).setPositiveButton((CharSequence)this.getString(R.string.rc_dialog_ok), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    CombineWebViewActivity.this.finish();
                }
            }).setCancelable(false).show();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mWebView != null) {
            this.mWebView.destroy();
        }
        RongContext.getInstance().getEventBus().unregister((Object)this);
    }

    private class EncodeFile {
        private String mediaUrl;
        private String base64;
        private String thumb;
        private String name;

        EncodeFile(String mediaUrl, String base64) {
            this.mediaUrl = mediaUrl;
            this.base64 = base64;
        }

        String getThumb() {
            return this.thumb;
        }

        public String getName() {
            return this.name;
        }

        public EncodeFile invoke() {
            this.thumb = CombineWebViewActivity.this.getCombineFilePath(this.mediaUrl);
            this.name = RongUtils.md5(this.mediaUrl) + ".jpg";
            File thumbFile = new File(this.thumb + this.name);
            if (!TextUtils.isEmpty((CharSequence)this.base64) && !thumbFile.exists()) {
                byte[] data = null;
                try {
                    data = Base64.decode((String)this.base64, (int)2);
                }
                catch (IllegalArgumentException e) {
                    RLog.e((String)TAG, (String)"afterDecodeMessage Not Base64 Content!");
                    RLog.e((String)TAG, (String)"IllegalArgumentException ", (Throwable)e);
                }
                if (!CombineWebViewActivity.isImageFile(data)) {
                    RLog.e((String)TAG, (String)"afterDecodeMessage Not Image File!");
                    return this;
                }
                FileUtils.byte2File((byte[])data, (String)this.thumb, (String)this.name);
            }
            return this;
        }
    }

    private static class DownloadTask
    extends AsyncTask<String, Void, Void> {
        private DownloadTask() {
        }

        protected void onPreExecute() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void doInBackground(String ... params) {
            OutputStream out = null;
            HttpURLConnection urlConnection = null;
            try {
                int len;
                URL url = new URL(params[0]);
                urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setConnectTimeout(15000);
                urlConnection.setReadTimeout(15000);
                int code = urlConnection.getResponseCode();
                if (code < 200 || code >= 300) {
                    RLog.e((String)TAG, (String)("DownloadTask failed! code:" + code));
                    Void void_ = null;
                    return void_;
                }
                InputStream in = urlConnection.getInputStream();
                File file = new File(params[1]);
                if (!file.exists()) {
                    if (file.getParent() == null) {
                        RLog.e((String)TAG, (String)"DownloadTask failed! file.getParent is null.");
                        Void void_ = null;
                        return void_;
                    }
                    File dir = new File(file.getParent());
                    boolean successMkdir = dir.mkdirs();
                    boolean isCreateNewFile = file.createNewFile();
                    RLog.d((String)TAG, (String)("DownloadTask successMkdir:" + successMkdir + ",isCreateNewFile:" + isCreateNewFile));
                }
                out = new FileOutputStream(file);
                byte[] buffer = new byte[10240];
                while ((len = in.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
                in.close();
            }
            catch (IOException e) {
                RLog.e((String)TAG, (String)"DownloadTask", (Throwable)e);
            }
            finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        RLog.e((String)TAG, (String)"DownloadTask", (Throwable)e);
                    }
                }
            }
            return null;
        }

        protected void onPostExecute(Void aVoid) {
        }
    }

    private class IsSightFileExists {
        private SightMessage sightMessage;

        public IsSightFileExists(SightMessage sightMessage) {
            this.sightMessage = sightMessage;
        }

        public boolean invoke() {
            String sightPath = LibStorageUtils.getMediaDownloadDir((Context)CombineWebViewActivity.this.getApplicationContext(), (String)"video");
            String name = DeviceUtils.ShortMD5((int)2, (String[])new String[]{this.sightMessage.getMediaUrl().toString()});
            if (sightPath.startsWith("file://")) {
                sightPath = sightPath.substring(7);
            }
            File file = new File(sightPath + File.separator + name);
            return file.exists();
        }
    }

    private class JsInterface {
        private JsInterface() {
        }

        @JavascriptInterface
        public void sendInfoToAndroid(String uri) {
            try {
                RLog.d((String)TAG, (String)("sendInfoToAndroid type start" + uri));
                JSONObject jsonObj = new JSONObject(uri);
                String type = jsonObj.optString("type");
                RLog.d((String)TAG, (String)("sendInfoToAndroid type:" + type));
                switch (type) {
                    case "RC:FileMsg": {
                        CombineWebViewActivity.this.openFile(jsonObj);
                        break;
                    }
                    case "RC:LBSMsg": {
                        CombineWebViewActivity.this.openMap(jsonObj);
                        break;
                    }
                    case "RC:CombineMsg": {
                        CombineWebViewActivity.this.openCombine(jsonObj);
                        break;
                    }
                    case "link": {
                        CombineWebViewActivity.this.openLink(jsonObj);
                        break;
                    }
                    case "phone": {
                        CombineWebViewActivity.this.openPhone(jsonObj);
                        break;
                    }
                    case "RC:ImgMsg": {
                        CombineWebViewActivity.this.openImage(jsonObj);
                        break;
                    }
                    case "RC:SightMsg": {
                        CombineWebViewActivity.this.openSight(jsonObj);
                    }
                }
            }
            catch (Exception e) {
                RLog.e((String)TAG, (String)"sendInfoToAndroid", (Throwable)e);
            }
        }
    }

    private class CombineWebChromeClient
    extends WebChromeClient {
        private CombineWebChromeClient() {
        }

        public void onProgressChanged(WebView view, int newProgress) {
            if (newProgress == 100) {
                CombineWebViewActivity.this.mProgress.setVisibility(8);
                CombineWebViewActivity.this.mImageView.setVisibility(8);
                CombineWebViewActivity.this.mTextView.setVisibility(8);
                CombineWebViewActivity.this.mWebView.setVisibility(0);
            } else {
                if (CombineWebViewActivity.this.mProgress.getVisibility() == 8) {
                    CombineWebViewActivity.this.mProgress.setVisibility(0);
                }
                if (CombineWebViewActivity.this.mTextView.getVisibility() == 8) {
                    CombineWebViewActivity.this.mTextView.setText((CharSequence)CombineWebViewActivity.this.getString(R.string.rc_combine_webview_loading));
                    CombineWebViewActivity.this.mTextView.setVisibility(0);
                }
                if (CombineWebViewActivity.this.mWebView.getVisibility() == 0) {
                    CombineWebViewActivity.this.mWebView.setVisibility(8);
                }
            }
            super.onProgressChanged(view, newProgress);
        }

        public void onReceivedTitle(WebView view, String title) {
            if (CombineWebViewActivity.this.mWebViewTitle != null && TextUtils.isEmpty((CharSequence)CombineWebViewActivity.this.mWebViewTitle.getText())) {
                CombineWebViewActivity.this.mWebViewTitle.setText((CharSequence)title);
            }
        }

        public void onCloseWindow(WebView window) {
            super.onCloseWindow(window);
            if (!CombineWebViewActivity.this.isFinishing()) {
                CombineWebViewActivity.this.finish();
            }
        }

        public Bitmap getDefaultVideoPoster() {
            return Bitmap.createBitmap((int)300, (int)600, (Bitmap.Config)Bitmap.Config.ALPHA_8);
        }
    }

    private class CombineWebViewClient
    extends WebViewClient {
        private CombineWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            String filePath;
            RLog.d((String)TAG, (String)("shouldOverrideUrlLoading mPrevUrl: " + CombineWebViewActivity.this.mPrevUrl + ", url:" + url));
            if (CombineWebViewActivity.this.mPrevUrl != null && CombineWebViewActivity.this.mPrevUrl.equals(url)) {
                return false;
            }
            if (CombineWebViewActivity.TYPE_MEDIA.equals(CombineWebViewActivity.this.mType) && url != null && (url.toLowerCase().startsWith("http") || url.toLowerCase().startsWith("ftp")) && new File(filePath = CombineMessageUtils.getInstance().getCombineFilePath(url)).exists()) {
                url = Uri.parse((String)("file://" + filePath)).toString();
                CombineWebViewActivity.this.mType = CombineWebViewActivity.TYPE_LOCAL;
            }
            CombineWebViewActivity.this.mPrevUrl = url;
            CombineWebViewActivity.this.mWebView.loadUrl(CombineWebViewActivity.this.mPrevUrl);
            return true;
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            String filePath;
            super.onPageStarted(view, url, favicon);
            RLog.d((String)TAG, (String)("onPageStarted url:" + url));
            if (CombineWebViewActivity.TYPE_MEDIA.equals(CombineWebViewActivity.this.mType) && url != null && (url.toLowerCase().startsWith("http") || url.toLowerCase().startsWith("ftp")) && !new File(filePath = CombineMessageUtils.getInstance().getCombineFilePath(url)).exists()) {
                new DownloadTask().execute(new String[]{url, filePath});
            }
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            RLog.d((String)TAG, (String)("onReceivedError errorCode:" + errorCode));
            CombineWebViewActivity.this.mProgress.setVisibility(8);
            CombineWebViewActivity.this.mImageView.setVisibility(0);
            CombineWebViewActivity.this.mTextView.setVisibility(0);
            CombineWebViewActivity.this.mWebView.setVisibility(8);
            CombineWebViewActivity.this.mTextView.setText((CharSequence)CombineWebViewActivity.this.getString(R.string.rc_combine_webview_download_failed));
        }

        public void onReceivedSslError(WebView view, final SslErrorHandler handler, SslError error) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)CombineWebViewActivity.this);
            builder.setMessage(R.string.rc_notification_error_ssl_cert_invalid);
            builder.setPositiveButton(R.string.rc_dialog_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    handler.proceed();
                }
            });
            builder.setNegativeButton(R.string.rc_dialog_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    handler.cancel();
                }
            });
            AlertDialog dialog = builder.create();
            dialog.show();
        }
    }
}

