/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.resend;

import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.imkit.RongIM;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Message;
import io.rong.message.ImageMessage;
import io.rong.message.LocationMessage;
import io.rong.message.MediaMessageContent;
import io.rong.message.ReferenceMessage;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ResendManager {
    private final String TAG = "ResendManager";
    private static final int TIME_DELAY = 300;
    private volatile boolean mIsProcessing = false;
    private Hashtable<Integer, Message> mMessageMap = new Hashtable();
    private ConcurrentLinkedQueue<Integer> mMessageQueue = new ConcurrentLinkedQueue();
    private Handler mResendHandler;

    private ResendManager() {
        HandlerThread resendThread = new HandlerThread("RESEND_WORK");
        resendThread.start();
        this.mResendHandler = new Handler(resendThread.getLooper());
    }

    public static ResendManager getInstance() {
        return ResendManagerHolder.instance;
    }

    public void addResendMessage(final Message message, final RongIMClient.ErrorCode errorCode, final AddResendMessageCallBack callBack) {
        this.mResendHandler.post(new Runnable(){

            @Override
            public void run() {
                if (ResendManager.this.isResendErrorCode(errorCode) && !ResendManager.this.mMessageMap.containsKey(message.getMessageId())) {
                    RLog.d((String)"ResendManager", (String)("addResendMessage : id=" + message.getMessageId()));
                    if (ResendManager.this.mMessageMap != null && ResendManager.this.mMessageQueue != null) {
                        ResendManager.this.mMessageMap.put(message.getMessageId(), message);
                        ResendManager.this.mMessageQueue.add(message.getMessageId());
                        ResendManager.this.beginResend();
                        message.setSentStatus(Message.SentStatus.SENDING);
                    }
                }
                callBack.onComplete(message, errorCode);
            }
        });
    }

    public void removeResendMessage(final int messageId) {
        this.mResendHandler.post(new Runnable(){

            @Override
            public void run() {
                if (ResendManager.this.mMessageMap != null) {
                    ResendManager.this.mMessageMap.remove(messageId);
                    ResendManager.this.mMessageQueue.remove(messageId);
                }
            }
        });
    }

    public void removeAllResendMessage() {
        this.mResendHandler.post(new Runnable(){

            @Override
            public void run() {
                if (ResendManager.this.mMessageMap != null) {
                    ResendManager.this.mMessageMap.clear();
                    ResendManager.this.mMessageQueue.clear();
                    ResendManager.this.mIsProcessing = false;
                }
            }
        });
    }

    public boolean isResendErrorCode(RongIMClient.ErrorCode errorCode) {
        return errorCode.equals((Object)RongIMClient.ErrorCode.RC_NET_CHANNEL_INVALID) || errorCode.equals((Object)RongIMClient.ErrorCode.RC_NET_UNAVAILABLE) || errorCode.equals((Object)RongIMClient.ErrorCode.RC_MSG_RESP_TIMEOUT);
    }

    public boolean needResend(int messageId) {
        if (this.mMessageMap == null) {
            return false;
        }
        return this.mMessageMap.containsKey(messageId);
    }

    public void beginResend() {
        this.mResendHandler.post(new Runnable(){

            @Override
            public void run() {
                if (ResendManager.this.mMessageMap == null || ResendManager.this.mMessageMap.size() == 0) {
                    RLog.i((String)"ResendManager", (String)"beginResend onChanged no message need resend");
                    ResendManager.this.mIsProcessing = false;
                    return;
                }
                if (ResendManager.this.mIsProcessing) {
                    RLog.i((String)"ResendManager", (String)"beginResend ConnectionStatus is resending");
                    return;
                }
                ResendManager.this.mIsProcessing = true;
                ResendManager.this.loopResendMessage();
            }
        });
    }

    private void loopResendMessage() {
        this.mResendHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                final Integer idInteger = (Integer)ResendManager.this.mMessageQueue.peek();
                RLog.d((String)"ResendManager", (String)("beginResend: messageId = " + idInteger));
                if (idInteger == null || RongIM.getInstance().getCurrentConnectionStatus() != RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTED) {
                    ResendManager.this.mIsProcessing = false;
                    return;
                }
                ResendManager.this.resendMessage((Message)ResendManager.this.mMessageMap.get(idInteger), new IRongCallback.ISendMessageCallback(){

                    public void onAttached(Message message) {
                    }

                    public void onSuccess(Message message) {
                        RLog.i((String)"ResendManager", (String)("resendMessage success messageId = " + message.getMessageId()));
                        ResendManager.this.removeResendMessage(idInteger);
                        ResendManager.this.loopResendMessage();
                    }

                    public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                        RLog.i((String)"ResendManager", (String)("resendMessage error messageId = " + message.getMessageId()));
                        if (ResendManager.this.isResendErrorCode(errorCode)) {
                            ResendManager.this.loopResendMessage();
                        } else {
                            ResendManager.this.removeResendMessage(idInteger);
                            ResendManager.this.loopResendMessage();
                        }
                    }
                });
            }
        }, 300L);
    }

    private void resendMessage(Message message, final IRongCallback.ISendMessageCallback callback) {
        if (message == null) {
            RLog.i((String)"ResendManager", (String)"resendMessage: Message is Null");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)message.getTargetId()) || message.getContent() == null) {
            RLog.e((String)"ResendManager", (String)"targetId or messageContent is Null");
            this.removeResendMessage(message.getMessageId());
            return;
        }
        if (message.getContent() instanceof ImageMessage) {
            ImageMessage imageMessage = (ImageMessage)message.getContent();
            if (imageMessage.getRemoteUri() != null && !imageMessage.getRemoteUri().toString().startsWith("file")) {
                RongIM.getInstance().sendMessage(message, null, null, callback);
            } else {
                RongIM.getInstance().sendImageMessage(message, null, null, new RongIMClient.SendImageMessageCallback(){

                    public void onAttached(Message message) {
                    }

                    public void onError(Message message, RongIMClient.ErrorCode code) {
                        callback.onError(message, code);
                    }

                    public void onSuccess(Message message) {
                        callback.onSuccess(message);
                    }

                    public void onProgress(Message message, int progress) {
                    }
                });
            }
        } else if (message.getContent() instanceof LocationMessage) {
            RongIM.getInstance().sendLocationMessage(message, null, null, callback);
        } else if (message.getContent() instanceof ReferenceMessage) {
            RongIM.getInstance().sendMessage(message, null, null, callback);
        } else if (message.getContent() instanceof MediaMessageContent) {
            MediaMessageContent mediaMessageContent = (MediaMessageContent)message.getContent();
            if (mediaMessageContent.getMediaUrl() != null) {
                RongIM.getInstance().sendMessage(message, null, null, callback);
            } else {
                RongIM.getInstance().sendMediaMessage(message, null, null, new IRongCallback.ISendMediaMessageCallback(){

                    public void onProgress(Message message, int progress) {
                    }

                    public void onCanceled(Message message) {
                    }

                    public void onAttached(Message message) {
                    }

                    public void onSuccess(Message message) {
                        callback.onSuccess(message);
                    }

                    public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                        callback.onError(message, errorCode);
                    }
                });
            }
        } else {
            RongIM.getInstance().sendMessage(message, null, null, callback);
        }
    }

    public static interface AddResendMessageCallBack {
        public void onComplete(Message var1, RongIMClient.ErrorCode var2);
    }

    private static class ResendManagerHolder {
        private static ResendManager instance = new ResendManager();

        private ResendManagerHolder() {
        }
    }
}

