/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.reference;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.os.Parcelable;
import android.support.v4.content.ContextCompat;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.TextView;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.activity.FilePreviewActivity;
import io.rong.imkit.activity.PicturePagerActivity;
import io.rong.imkit.emoticon.AndroidEmoji;
import io.rong.imkit.model.GroupUserInfo;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.UserInfo;
import io.rong.message.FileMessage;
import io.rong.message.ImageMessage;
import io.rong.message.ReferenceMessage;
import io.rong.message.RichContentMessage;
import io.rong.message.TextMessage;

public class ReferenceView
extends FrameLayout {
    private static final String TAG = "ConversationFragment";
    private static final int DEFAULT_MAX_HEIGHT = 238;
    private int maxHeight = 238;
    private TextView tvReferenceName;
    private TextView tvReferenceContent;
    private AsyncImageView imgReferenceContent;
    private CancelListener cancelListener;

    public ReferenceView(Context context) {
        super(context);
        this.init();
    }

    public ReferenceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
        this.init();
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ReferenceView);
        int count = a.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int attr = a.getIndex(i);
            if (attr != R.styleable.ReferenceView_RCMaxHeight) continue;
            this.maxHeight = a.getDimensionPixelOffset(attr, 238);
        }
        a.recycle();
    }

    private void init() {
        ReferenceView.inflate((Context)this.getContext(), (int)R.layout.rc_view_reference, (ViewGroup)this);
        ImageButton imgCancel = (ImageButton)this.findViewById(R.id.rc_view_iv_reference_cancel);
        this.tvReferenceName = (TextView)this.findViewById(R.id.rc_view_tv_reference_name);
        this.tvReferenceContent = (TextView)this.findViewById(R.id.rc_view_tv_reference_content);
        this.imgReferenceContent = (AsyncImageView)this.findViewById(R.id.rc_view_iv_reference_content);
        imgCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ReferenceView.this.cancelListener != null) {
                    ReferenceView.this.cancelListener.cancelClick();
                }
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.maxHeight = (int)this.getResources().getDimension(R.dimen.rc_reference_dimen_size_103);
        if (heightMode == 0x40000000) {
            int n = heightSize = heightSize <= this.maxHeight ? heightSize : this.maxHeight;
        }
        if (heightMode == 0) {
            int n = heightSize = heightSize <= this.maxHeight ? heightSize : this.maxHeight;
        }
        if (heightMode == Integer.MIN_VALUE) {
            heightSize = heightSize <= this.maxHeight ? heightSize : this.maxHeight;
        }
        int maxHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)heightMode);
        super.onMeasure(widthMeasureSpec, maxHeightMeasureSpec);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        return true;
    }

    public ReferenceMessage setMessageContent(UIMessage uiMessage) {
        if (this.tvReferenceContent != null) {
            this.tvReferenceContent.setOnClickListener(null);
        }
        if (uiMessage != null) {
            ReferenceMessage referenceMessage = null;
            if (uiMessage.getContent() instanceof TextMessage) {
                referenceMessage = this.makeTextMessage(uiMessage);
            } else if (uiMessage.getContent() instanceof ImageMessage) {
                referenceMessage = this.makeImageMessage(uiMessage);
            } else if (uiMessage.getContent() instanceof FileMessage) {
                referenceMessage = this.makeFileMessage(uiMessage);
            } else if (uiMessage.getContent() instanceof RichContentMessage) {
                referenceMessage = this.makeRichContentMessage(uiMessage);
            } else if (uiMessage.getContent() instanceof ReferenceMessage) {
                referenceMessage = this.makeReferenceMessage(uiMessage);
            }
            return referenceMessage;
        }
        return null;
    }

    private ReferenceMessage makeReferenceMessage(UIMessage uiMessage) {
        ReferenceMessage message = (ReferenceMessage)uiMessage.getContent();
        if (uiMessage.getSenderUserId() != null) {
            this.tvReferenceName.setText((CharSequence)this.getDisplayName(uiMessage));
            SpannableStringBuilder span = this.createSpan(message.getEditSendText());
            this.setTextContent(this.tvReferenceContent, span);
            this.tvReferenceContent.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.rc_reference_normal_text_color));
            this.tvReferenceContent.setVisibility(0);
            this.imgReferenceContent.setVisibility(8);
            TextMessage obtain = TextMessage.obtain((String)message.getEditSendText());
            return ReferenceMessage.obtainMessage((String)uiMessage.getSenderUserId(), (MessageContent)obtain);
        }
        return null;
    }

    private ReferenceMessage makeRichContentMessage(UIMessage uiMessage) {
        RichContentMessage richContentMessage = (RichContentMessage)uiMessage.getContent();
        if (uiMessage.getSenderUserId() != null && richContentMessage.getTitle() != null && richContentMessage.getUrl() != null) {
            this.tvReferenceName.setText((CharSequence)this.getDisplayName(uiMessage));
            String string2 = this.getResources().getString(R.string.rc_reference_link) + ' ' + richContentMessage.getTitle();
            SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)string2);
            AndroidEmoji.ensure((Spannable)ssb);
            this.tvReferenceContent.setText((CharSequence)ssb);
            this.tvReferenceContent.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.rc_reference_text_link_color));
            this.tvReferenceContent.setVisibility(0);
            this.imgReferenceContent.setVisibility(8);
            return ReferenceMessage.obtainMessage((String)uiMessage.getSenderUserId(), (MessageContent)uiMessage.getContent());
        }
        return null;
    }

    private ReferenceMessage makeFileMessage(final UIMessage uiMessage) {
        final FileMessage fileMessage = (FileMessage)uiMessage.getContent();
        if (uiMessage.getSenderUserId() != null && fileMessage.getFileUrl() != null) {
            this.tvReferenceName.setText((CharSequence)this.getDisplayName(uiMessage));
            String string2 = this.getResources().getString(R.string.rc_reference_file) + ' ' + fileMessage.getName();
            SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)string2);
            AndroidEmoji.ensure((Spannable)ssb);
            this.tvReferenceContent.setText((CharSequence)ssb);
            this.tvReferenceContent.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.rc_reference_text_link_color));
            this.tvReferenceContent.setVisibility(0);
            this.imgReferenceContent.setVisibility(8);
            this.tvReferenceContent.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    try {
                        Intent intent = new Intent();
                        intent.setClass(view.getContext(), FilePreviewActivity.class);
                        intent.setPackage(view.getContext().getPackageName());
                        intent.putExtra("FileMessage", (Parcelable)fileMessage);
                        intent.putExtra("Message", (Parcelable)uiMessage.getMessage());
                        intent.putExtra("Progress", uiMessage.getProgress());
                        view.getContext().startActivity(intent);
                    }
                    catch (Exception e) {
                        RLog.e((String)ReferenceView.TAG, (String)("exception: " + e));
                    }
                }
            });
            return ReferenceMessage.obtainMessage((String)uiMessage.getSenderUserId(), (MessageContent)uiMessage.getContent());
        }
        return null;
    }

    private ReferenceMessage makeImageMessage(final UIMessage uiMessage) {
        ImageMessage imageMessage = (ImageMessage)uiMessage.getContent();
        if (uiMessage.getSenderUserId() != null && imageMessage.getRemoteUri() != null) {
            this.tvReferenceName.setText((CharSequence)this.getDisplayName(uiMessage));
            this.tvReferenceContent.setVisibility(8);
            this.imgReferenceContent.setVisibility(0);
            this.imgReferenceContent.setResource(imageMessage.getThumUri());
            this.imgReferenceContent.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    try {
                        Intent intent = new Intent(view.getContext(), PicturePagerActivity.class);
                        intent.setPackage(view.getContext().getPackageName());
                        intent.putExtra("message", (Parcelable)uiMessage.getMessage());
                        view.getContext().startActivity(intent);
                    }
                    catch (Exception e) {
                        RLog.e((String)ReferenceView.TAG, (String)("exception: " + e));
                    }
                }
            });
            return ReferenceMessage.obtainMessage((String)uiMessage.getSenderUserId(), (MessageContent)uiMessage.getContent());
        }
        return null;
    }

    private ReferenceMessage makeTextMessage(UIMessage uiMessage) {
        TextMessage textMessage = (TextMessage)uiMessage.getContent();
        if (uiMessage.getSenderUserId() != null && textMessage.getContent() != null) {
            this.tvReferenceName.setText((CharSequence)this.getDisplayName(uiMessage));
            SpannableStringBuilder span = this.createSpan(textMessage.getContent());
            this.setTextContent(this.tvReferenceContent, span);
            this.tvReferenceContent.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.rc_reference_normal_text_color));
            this.tvReferenceContent.setVisibility(0);
            this.imgReferenceContent.setVisibility(8);
            return ReferenceMessage.obtainMessage((String)uiMessage.getSenderUserId(), (MessageContent)uiMessage.getContent());
        }
        return null;
    }

    private SpannableStringBuilder createSpan(String content) {
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)content);
        AndroidEmoji.ensure((Spannable)spannable);
        return spannable;
    }

    private void setTextContent(final TextView textView, final SpannableStringBuilder spannable) {
        int len = spannable.length();
        if (this.getHandler() != null && len > 500) {
            this.getHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    textView.setText((CharSequence)spannable);
                }
            }, 50L);
        } else {
            textView.setText((CharSequence)spannable);
        }
    }

    public void clearReference() {
        this.tvReferenceName.setText((CharSequence)"");
        this.tvReferenceContent.setText((CharSequence)"");
        this.imgReferenceContent.setImageDrawable(null);
        this.setVisibility(8);
    }

    public void setCancelListener(CancelListener cancelListener) {
        this.cancelListener = cancelListener;
    }

    private String getDisplayName(UIMessage uiMessage) {
        if (uiMessage.getSenderUserId() != null) {
            GroupUserInfo groupUserInfo;
            if (uiMessage.getConversationType().equals((Object)Conversation.ConversationType.GROUP) && (groupUserInfo = RongUserInfoManager.getInstance().getGroupUserInfo(uiMessage.getTargetId(), uiMessage.getSenderUserId())) != null) {
                return groupUserInfo.getNickname();
            }
            UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(uiMessage.getSenderUserId());
            if (userInfo != null) {
                return userInfo.getName();
            }
        }
        return null;
    }

    public static interface CancelListener {
        public void cancelClick();
    }
}

