/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.reference;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.net.Uri;
import android.os.Parcelable;
import android.support.v4.content.ContextCompat;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.activity.FilePreviewActivity;
import io.rong.imkit.activity.PicturePagerActivity;
import io.rong.imkit.emoticon.AndroidEmoji;
import io.rong.imkit.model.GroupUserInfo;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.tools.RongWebviewActivity;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.utils.TextViewUtils;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imkit.widget.ILinkClickListener;
import io.rong.imkit.widget.LinkTextViewMovementMethod;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.UserInfo;
import io.rong.message.FileMessage;
import io.rong.message.ImageMessage;
import io.rong.message.ReferenceMessage;
import io.rong.message.RichContentMessage;
import io.rong.message.TextMessage;

@ProviderTag(messageContent=ReferenceMessage.class, showProgress=false, showReadState=true)
public class ReferenceMessageItemProvider
extends IContainerItemProvider.MessageProvider<ReferenceMessage> {
    private static final String TAG = "ReferenceMessageItemProvider";

    @Override
    public View newView(Context context, ViewGroup viewGroup) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_message_reference, null);
        ViewHolder viewHolder = new ViewHolder();
        viewHolder.containerView = (LinearLayout)view;
        viewHolder.referenceName = (TextView)view.findViewById(R.id.rc_msg_tv_reference_name);
        viewHolder.referenceFileName = (TextView)view.findViewById(R.id.rc_msg_tv_reference_file_name);
        viewHolder.referenceContent = (TextView)view.findViewById(R.id.rc_msg_tv_reference_content);
        viewHolder.referenceSendContent = (TextView)view.findViewById(R.id.rc_msg_tv_reference_send_content);
        viewHolder.referenceImg = (AsyncImageView)view.findViewById(R.id.rc_msg_iv_reference);
        viewHolder.referenceVerticalMark = view.findViewById(R.id.rc_reference_vertical_mark);
        viewHolder.referenceHorizontalMark = view.findViewById(R.id.rc_reference_horizontal_mark);
        view.setTag((Object)viewHolder);
        return view;
    }

    @Override
    public void bindView(View view, int position, ReferenceMessage referenceMessage, UIMessage uiMessage) {
        ViewHolder holder = (ViewHolder)view.getTag();
        holder.referenceName.setText((CharSequence)"");
        holder.referenceContent.setText((CharSequence)"");
        holder.referenceSendContent.setText((CharSequence)"");
        holder.referenceSendContent.setVisibility(0);
        if (uiMessage.getMessageDirection() == Message.MessageDirection.SEND) {
            holder.containerView.setBackgroundResource(R.drawable.rc_ic_bubble_right);
            Drawable drawable2 = ContextCompat.getDrawable((Context)view.getContext(), (int)R.drawable.rc_shape_bg_vertical_bar);
            if (drawable2 == null) {
                return;
            }
            drawable2.mutate();
            int color2 = ContextCompat.getColor((Context)view.getContext(), (int)R.color.rc_reference_sent_mark_bg);
            if (drawable2 instanceof ShapeDrawable) {
                ((ShapeDrawable)drawable2).getPaint().setColor(color2);
            } else if (drawable2 instanceof GradientDrawable) {
                ((GradientDrawable)drawable2).setColor(color2);
            }
            holder.referenceVerticalMark.setBackground(drawable2);
            holder.referenceHorizontalMark.setBackgroundColor(view.getResources().getColor(R.color.rc_reference_sent_mark_bg));
            holder.referenceName.setTextColor(ContextCompat.getColor((Context)view.getContext(), (int)R.color.rc_reference_sent_title));
        } else {
            holder.containerView.setBackgroundResource(R.drawable.rc_ic_bubble_left);
            holder.referenceVerticalMark.setBackgroundResource(R.drawable.rc_shape_bg_vertical_bar);
            holder.referenceHorizontalMark.setBackgroundColor(view.getResources().getColor(R.color.rc_reference_received_mark_bg));
            holder.referenceName.setTextColor(ContextCompat.getColor((Context)view.getContext(), (int)R.color.rc_reference_received_title));
        }
        if (referenceMessage.getUserId() != null) {
            holder.referenceName.setText((CharSequence)this.getDisplayName(uiMessage, referenceMessage.getUserId()));
        }
        if (referenceMessage.getEditSendText() != null) {
            this.setTextContent(holder.referenceSendContent, uiMessage, referenceMessage.getEditSendText(), true);
            this.setMovementMethod(view, uiMessage, holder.referenceSendContent);
        }
        if (referenceMessage.getReferenceContent() == null) {
            return;
        }
        if (referenceMessage.getReferenceContent() instanceof TextMessage) {
            this.setTextType(view, holder, position, referenceMessage, uiMessage);
            holder.referenceContent.setVisibility(0);
            holder.referenceContent.setMaxLines(Integer.MAX_VALUE);
            holder.referenceImg.setVisibility(8);
            holder.referenceFileName.setVisibility(8);
            this.setMovementMethod(view, uiMessage, holder.referenceContent);
        } else if (referenceMessage.getReferenceContent() instanceof ImageMessage) {
            this.setImageType(view, holder, position, referenceMessage, uiMessage);
            holder.referenceContent.setVisibility(8);
            holder.referenceImg.setVisibility(0);
            holder.referenceFileName.setVisibility(8);
        } else if (referenceMessage.getReferenceContent() instanceof FileMessage) {
            this.setFileType(view, holder, position, referenceMessage, uiMessage);
            holder.referenceContent.setVisibility(8);
            holder.referenceImg.setVisibility(8);
            holder.referenceFileName.setVisibility(0);
        } else if (referenceMessage.getReferenceContent() instanceof RichContentMessage) {
            this.setRichType(view, holder, position, referenceMessage, uiMessage);
            holder.referenceContent.setVisibility(0);
            holder.referenceContent.setMaxLines(3);
            holder.referenceContent.setEllipsize(TextUtils.TruncateAt.END);
            holder.referenceImg.setVisibility(8);
            holder.referenceFileName.setVisibility(8);
        } else if (referenceMessage.getReferenceContent() instanceof ReferenceMessage) {
            this.setReferenceType(view, holder, position, referenceMessage, uiMessage);
            holder.referenceContent.setVisibility(0);
            holder.referenceContent.setMaxLines(Integer.MAX_VALUE);
            holder.referenceImg.setVisibility(8);
            holder.referenceFileName.setVisibility(8);
        } else {
            holder.referenceContent.setVisibility(0);
            holder.referenceContent.setText(R.string.rc_message_unknown);
            holder.referenceImg.setVisibility(8);
            holder.referenceFileName.setVisibility(8);
        }
    }

    private void setMovementMethod(final View view, final UIMessage uiMessage, TextView referenceContent) {
        referenceContent.setMovementMethod((MovementMethod)new LinkTextViewMovementMethod(new ILinkClickListener(){

            @Override
            public boolean onLinkClick(String link) {
                String str;
                RongIM.ConversationBehaviorListener listener = RongContext.getInstance().getConversationBehaviorListener();
                RongIM.ConversationClickListener clickListener = RongContext.getInstance().getConversationClickListener();
                boolean result = false;
                if (listener != null) {
                    result = listener.onMessageLinkClick(view.getContext(), link);
                } else if (clickListener != null) {
                    result = clickListener.onMessageLinkClick(view.getContext(), link, uiMessage.getMessage());
                }
                if ((listener == null && clickListener == null || !result) && ((str = link.toLowerCase()).startsWith("http") || str.startsWith("https"))) {
                    Intent intent = new Intent("io.rong.imkit.intent.action.webview");
                    intent.setPackage(view.getContext().getPackageName());
                    intent.putExtra("url", link);
                    view.getContext().startActivity(intent);
                    result = true;
                }
                return result;
            }
        }));
    }

    private void setRichType(final View view, ViewHolder holder, int position, ReferenceMessage referenceMessage, UIMessage uiMessage) {
        holder.referenceContent.setOnClickListener(null);
        if (referenceMessage == null || referenceMessage.getReferenceContent() == null) {
            return;
        }
        holder.referenceContent.setOnClickListener(null);
        final RichContentMessage content = (RichContentMessage)referenceMessage.getReferenceContent();
        String string2 = view.getContext().getString(R.string.rc_reference_link) + ' ' + content.getTitle();
        SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)string2);
        ssb.setSpan((Object)new ForegroundColorSpan(view.getContext().getResources().getColor(R.color.rc_reference_text_link_color)), 0, string2.length(), 33);
        AndroidEmoji.ensure((Spannable)ssb);
        holder.referenceContent.setText((CharSequence)ssb);
        holder.referenceContent.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                try {
                    Intent intent = new Intent(view.getContext(), RongWebviewActivity.class);
                    intent.setPackage(view.getContext().getPackageName());
                    intent.putExtra("url", content.getUrl());
                    view.getContext().startActivity(intent);
                }
                catch (Exception e) {
                    RLog.e((String)ReferenceMessageItemProvider.TAG, (String)("exception: " + e));
                }
            }
        });
        holder.referenceContent.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return view.performLongClick();
            }
        });
        holder.referenceSendContent.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return view.performLongClick();
            }
        });
    }

    private void setFileType(final View view, ViewHolder holder, int position, ReferenceMessage referenceMessage, final UIMessage uiMessage) {
        holder.referenceContent.setOnClickListener(null);
        if (referenceMessage == null || referenceMessage.getReferenceContent() == null) {
            return;
        }
        holder.referenceContent.setOnClickListener(null);
        FileMessage content = (FileMessage)referenceMessage.getReferenceContent();
        String string2 = view.getContext().getString(R.string.rc_search_file_prefix) + ' ' + content.getName();
        SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)string2);
        ssb.setSpan((Object)new ForegroundColorSpan(view.getContext().getResources().getColor(R.color.rc_reference_text_link_color)), 0, string2.length(), 33);
        AndroidEmoji.ensure((Spannable)ssb);
        holder.referenceFileName.setText((CharSequence)ssb);
        holder.referenceFileName.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                try {
                    Intent intent = new Intent();
                    intent.setClass(view.getContext(), FilePreviewActivity.class);
                    intent.setPackage(view.getContext().getPackageName());
                    ReferenceMessage referenceMessage = (ReferenceMessage)uiMessage.getMessage().getContent();
                    FileMessage fileMessage = (FileMessage)referenceMessage.getReferenceContent();
                    intent.putExtra("FileMessage", (Parcelable)fileMessage);
                    intent.putExtra("Message", (Parcelable)uiMessage.getMessage());
                    intent.putExtra("Progress", uiMessage.getProgress());
                    view.getContext().startActivity(intent);
                }
                catch (Exception e) {
                    RLog.e((String)ReferenceMessageItemProvider.TAG, (String)("exception: " + e));
                }
            }
        });
        holder.referenceFileName.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return view.performLongClick();
            }
        });
        holder.referenceSendContent.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return view.performLongClick();
            }
        });
    }

    private void setImageType(final View view, ViewHolder holder, int position, ReferenceMessage referenceMessage, final UIMessage uiMessage) {
        holder.referenceContent.setOnClickListener(null);
        if (referenceMessage == null || referenceMessage.getReferenceContent() == null) {
            return;
        }
        ImageMessage content = (ImageMessage)referenceMessage.getReferenceContent();
        Uri imageUri = null;
        if (content.getThumUri() != null) {
            imageUri = content.getThumUri();
        } else if (content.getLocalPath() != null) {
            imageUri = content.getLocalPath();
        } else if (content.getMediaUrl() != null) {
            imageUri = content.getMediaUrl();
        }
        if (imageUri != null) {
            holder.referenceImg.setResource(content.getThumUri());
        }
        holder.referenceImg.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                try {
                    Intent intent = new Intent(view.getContext(), PicturePagerActivity.class);
                    intent.setPackage(view.getContext().getPackageName());
                    intent.putExtra("message", (Parcelable)uiMessage.getMessage());
                    view.getContext().startActivity(intent);
                }
                catch (Exception e) {
                    RLog.e((String)ReferenceMessageItemProvider.TAG, (String)"setImageType", (Throwable)e);
                }
            }
        });
        holder.referenceImg.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return view.performLongClick();
            }
        });
        holder.referenceSendContent.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return view.performLongClick();
            }
        });
    }

    private void setTextType(View view, ViewHolder holder, int position, ReferenceMessage referenceMessage, UIMessage uiMessage) {
        holder.referenceContent.setOnClickListener(null);
        if (referenceMessage == null || referenceMessage.getReferenceContent() == null) {
            return;
        }
        if (referenceMessage.getReferenceContent() instanceof TextMessage) {
            this.setTextContent(holder.referenceContent, uiMessage, ((TextMessage)referenceMessage.getReferenceContent()).getContent(), false);
            this.setReferenceContentAction(view, holder, position, referenceMessage, uiMessage);
        }
    }

    private void setReferenceContentAction(final View view, ViewHolder holder, int position, ReferenceMessage referenceMessage, UIMessage uiMessage) {
        holder.referenceContent.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return view.performLongClick();
            }
        });
        holder.referenceSendContent.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return view.performLongClick();
            }
        });
        holder.referenceContent.setMovementMethod((MovementMethod)new LinkTextViewMovementMethod(new ILinkClickListener(){

            @Override
            public boolean onLinkClick(String link) {
                boolean result = false;
                String str = link.toLowerCase();
                if (str.startsWith("http") || str.startsWith("https")) {
                    Intent intent = new Intent("io.rong.imkit.intent.action.webview");
                    intent.setPackage(view.getContext().getPackageName());
                    intent.putExtra("url", link);
                    view.getContext().startActivity(intent);
                    result = true;
                }
                return result;
            }
        }));
    }

    private void setReferenceType(View view, ViewHolder holder, int position, ReferenceMessage referenceMessage, UIMessage uiMessage) {
        holder.referenceContent.setOnClickListener(null);
        if (referenceMessage == null || referenceMessage.getReferenceContent() == null) {
            return;
        }
        if (referenceMessage.getReferenceContent() instanceof TextMessage) {
            this.setTextContent(holder.referenceContent, uiMessage, ((TextMessage)referenceMessage.getReferenceContent()).getContent(), false);
            this.setReferenceContentAction(view, holder, position, referenceMessage, uiMessage);
        }
    }

    @Override
    public Spannable getContentSummary(ReferenceMessage referenceMessage) {
        return new SpannableString(AndroidEmoji.ensure(referenceMessage.getEditSendText()));
    }

    @Override
    public void onItemClick(View view, int i, ReferenceMessage referenceMessage, UIMessage uiMessage) {
    }

    private void setTextContent(final TextView textView, final UIMessage data, String content, boolean isSendContent) {
        textView.setTag((Object)data.getMessageId());
        if (isSendContent) {
            if (data.getContentSpannable() == null) {
                SpannableStringBuilder spannable = TextViewUtils.getSpannable(content, new TextViewUtils.RegularCallBack(){

                    @Override
                    public void finish(SpannableStringBuilder spannable) {
                        data.setContentSpannable(spannable);
                        if (textView.getTag().equals(data.getMessageId())) {
                            textView.post(new Runnable(){

                                @Override
                                public void run() {
                                    textView.setText((CharSequence)data.getContentSpannable());
                                }
                            });
                        }
                    }
                });
                data.setContentSpannable(spannable);
            }
            textView.setText((CharSequence)data.getContentSpannable());
        } else {
            if (data.getReferenceContentSpannable() == null) {
                SpannableStringBuilder spannable = TextViewUtils.getSpannable(content, new TextViewUtils.RegularCallBack(){

                    @Override
                    public void finish(SpannableStringBuilder spannable) {
                        data.setReferenceContentSpannable(spannable);
                        if (textView.getTag().equals(data.getMessageId())) {
                            textView.post(new Runnable(){

                                @Override
                                public void run() {
                                    textView.setText((CharSequence)data.getReferenceContentSpannable());
                                }
                            });
                        }
                    }
                });
                data.setReferenceContentSpannable(spannable);
            }
            textView.setText((CharSequence)data.getReferenceContentSpannable());
        }
    }

    private String getDisplayName(UIMessage uiMessage, String referenceUserId) {
        if (uiMessage.getSenderUserId() != null) {
            GroupUserInfo groupUserInfo;
            if (uiMessage.getConversationType().equals((Object)Conversation.ConversationType.GROUP) && (groupUserInfo = RongUserInfoManager.getInstance().getGroupUserInfo(uiMessage.getTargetId(), referenceUserId)) != null) {
                return groupUserInfo.getNickname();
            }
            UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(referenceUserId);
            if (userInfo != null) {
                return userInfo.getName();
            }
        }
        return null;
    }

    private static class ViewHolder {
        LinearLayout containerView;
        TextView referenceName;
        TextView referenceFileName;
        TextView referenceContent;
        TextView referenceSendContent;
        AsyncImageView referenceImg;
        View referenceVerticalMark;
        View referenceHorizontalMark;

        private ViewHolder() {
        }
    }
}

