/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.recallEdit;

import io.rong.imkit.recallEdit.RecallEditCountDownCallBack;
import io.rong.imkit.recallEdit.RecallEditCountDownTimer;
import io.rong.imkit.recallEdit.RecallEditCountDownTimerListener;
import io.rong.imlib.model.Message;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RecallEditManager {
    private Map<String, ConcurrentHashMap<Integer, RecallEditCountDownTimer>> timerMap = new HashMap<String, ConcurrentHashMap<Integer, RecallEditCountDownTimer>>();

    private RecallEditManager() {
    }

    public static RecallEditManager getInstance() {
        return RecallEditManagerHolder.instance;
    }

    public void startCountDown(Message message, long millisInFuture, RecallEditCountDownCallBack callBack) {
        RecallEditCountDownTimer timer;
        String key = message.getConversationType().getName() + message.getTargetId();
        ConcurrentHashMap<Integer, RecallEditCountDownTimer> recallEditTimerMap = this.timerMap.get(key);
        if (recallEditTimerMap != null && (timer = recallEditTimerMap.get(message.getMessageId())) != null) {
            timer.setListener(new RecallEditTimerListener(message, callBack));
            return;
        }
        RecallEditCountDownTimer countDownTimer = new RecallEditCountDownTimer(String.valueOf(message.getMessageId()), new RecallEditTimerListener(message, callBack), millisInFuture);
        if (recallEditTimerMap == null) {
            ConcurrentHashMap<Integer, RecallEditCountDownTimer> timers = new ConcurrentHashMap<Integer, RecallEditCountDownTimer>();
            timers.put(message.getMessageId(), countDownTimer);
            this.timerMap.put(key, timers);
        } else {
            recallEditTimerMap.put(message.getMessageId(), countDownTimer);
        }
        countDownTimer.start();
    }

    public void cancelCountDownInConversation(String key) {
        ConcurrentHashMap<Integer, RecallEditCountDownTimer> timers = this.timerMap.get(key);
        if (timers != null && timers.size() > 0) {
            Set<Map.Entry<Integer, RecallEditCountDownTimer>> entrySet = timers.entrySet();
            for (Map.Entry<Integer, RecallEditCountDownTimer> entry : entrySet) {
                RecallEditCountDownTimer timer = entry.getValue();
                if (timer == null) continue;
                timer.cancel();
            }
            this.timerMap.remove(key);
        }
    }

    public void cancelCountDown(String messageId) {
        Set<Map.Entry<String, ConcurrentHashMap<Integer, RecallEditCountDownTimer>>> timerEntrySet = this.timerMap.entrySet();
        for (Map.Entry<String, ConcurrentHashMap<Integer, RecallEditCountDownTimer>> timerEntry : timerEntrySet) {
            RecallEditCountDownTimer timer;
            ConcurrentHashMap<Integer, RecallEditCountDownTimer> timers = timerEntry.getValue();
            if (timers == null || timers.size() <= 0 || (timer = timers.get(Integer.valueOf(messageId))) == null) continue;
            timer.cancel();
            timers.remove(Integer.valueOf(messageId));
        }
    }

    private class RecallEditTimerListener
    implements RecallEditCountDownTimerListener {
        private Message message;
        private RecallEditCountDownCallBack callBack;

        public RecallEditTimerListener(Message message, RecallEditCountDownCallBack callBack) {
            this.message = message;
            this.callBack = callBack;
        }

        @Override
        public void onTick(long untilFinished, String messageId) {
        }

        @Override
        public void onFinish(String messageId) {
            Map value = (Map)RecallEditManager.this.timerMap.get(this.message.getConversationType().getName() + messageId);
            if (value != null && value.get(this.message.getMessageId()) != null) {
                value.remove(this.message.getMessageId());
            }
            if (this.callBack != null) {
                this.callBack.onFinish(messageId);
            }
        }
    }

    private static class RecallEditManagerHolder {
        private static RecallEditManager instance = new RecallEditManager();

        private RecallEditManagerHolder() {
        }
    }
}

