/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.plugin.location;

import android.content.Context;
import android.text.TextUtils;
import com.amap.api.maps.CoordinateConverter;
import com.amap.api.maps.model.LatLng;
import com.amap.api.netlocation.AMapNetworkLocationClient;
import io.rong.common.RLog;
import io.rong.imkit.plugin.location.AMapLocationInfo;
import io.rong.imkit.plugin.location.AMapLocationParser;
import io.rong.imkit.plugin.location.ILocationChangedListener;
import io.rong.imkit.plugin.location.IMyLocationChangedListener;
import io.rong.imkit.plugin.location.IRealTimeLocationStateListener;
import io.rong.imkit.plugin.location.IUserInfoProvider;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.location.RealTimeLocationConstant;
import io.rong.imlib.location.RealTimeLocationType;
import io.rong.imlib.model.Conversation;
import java.util.List;

public class LocationManager {
    private static final String TAG = "LocationManager";
    private Context mContext;
    private Conversation.ConversationType mConversationType;
    private String mTargetId;
    private IRealTimeLocationStateListener mParticipantChangedListener;
    private IMyLocationChangedListener mMyLocationChangedListener;
    private ILocationChangedListener mLocationChangedListener;
    private AMapLocationParser mLocationParser;
    private AMapNetworkLocationClient mLocationClient;
    private LatLng mLatLng;
    private AMapLocationInfo mMyLastLatLng;
    private LoopThread mLoopThread;
    private IUserInfoProvider mUserInfoProvider;

    private LocationManager() {
    }

    public static LocationManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void getUserInfo(String userId, IUserInfoProvider.UserInfoCallback userInfoCallback) {
        if (this.mUserInfoProvider != null) {
            this.mUserInfoProvider.getUserInfo(userId, userInfoCallback);
        }
    }

    public void bindConversation(Context context, Conversation.ConversationType conversationType, String targetId) {
        this.mContext = context.getApplicationContext();
        this.mConversationType = conversationType;
        this.mTargetId = targetId;
        this.mLocationParser = new AMapLocationParser();
        RongIMClient.getInstance().addRealTimeLocationListener(this.mConversationType, this.mTargetId, new RongIMClient.RealTimeLocationListener(){

            public void onStatusChange(RealTimeLocationConstant.RealTimeLocationStatus status) {
                RLog.d((String)LocationManager.TAG, (String)("onStatusChange status = " + status.getMessage()));
                LocationManager.this.sendOnParticipantChanged();
            }

            public void onReceiveLocationWithType(double latitude, double longitude, RealTimeLocationType type, String userId) {
                RLog.d((String)LocationManager.TAG, (String)("onReceiveLocationWithType userId = " + userId + "; latitude = " + latitude + "; longitude = " + longitude + ",type = " + type));
                if (type == RealTimeLocationType.WGS84 && (latitude != 0.0 || longitude != 0.0)) {
                    LatLng sourceLatLng = new LatLng(latitude, longitude);
                    CoordinateConverter converter = new CoordinateConverter(LocationManager.this.mContext);
                    converter.from(CoordinateConverter.CoordType.GPS);
                    converter.coord(sourceLatLng);
                    LatLng desLatLng = converter.convert();
                    if (userId.equals(RongIMClient.getInstance().getCurrentUserId())) {
                        LocationManager.this.mLatLng = new LatLng(desLatLng.latitude, desLatLng.longitude);
                    }
                    LocationManager.this.sendOnLocationChanged(desLatLng.latitude, desLatLng.longitude, userId);
                } else {
                    if (userId.equals(RongIMClient.getInstance().getCurrentUserId())) {
                        LocationManager.this.mLatLng = new LatLng(latitude, longitude);
                    }
                    LocationManager.this.sendOnLocationChanged(latitude, longitude, userId);
                }
            }

            public void onReceiveLocation(double latitude, double longitude, String userId) {
                RLog.d((String)LocationManager.TAG, (String)("onReceiveLocation userId = " + userId + "; latitude = " + latitude + "; longitude = " + longitude));
                if (userId.equals(RongIMClient.getInstance().getCurrentUserId())) {
                    LocationManager.this.mLatLng = new LatLng(latitude, longitude);
                }
                LocationManager.this.sendOnLocationChanged(latitude, longitude, userId);
            }

            public void onParticipantsJoin(String userId) {
                RLog.d((String)LocationManager.TAG, (String)("onParticipantsJoin userId = " + userId));
                LocationManager.this.sendOnParticipantChanged();
                LocationManager.this.sendOnParticipantJoinSharing(userId);
            }

            public void onParticipantsQuit(String userId) {
                RLog.d((String)LocationManager.TAG, (String)("onParticipantsQuit userId = " + userId));
                LocationManager.this.sendOnParticipantChanged();
                LocationManager.this.sendOnParticipantQuitSharing(userId);
            }

            public void onError(RealTimeLocationConstant.RealTimeLocationErrorCode errorCode) {
                RLog.d((String)LocationManager.TAG, (String)("RealTimeLocationErrorCode errorCode = " + errorCode));
                LocationManager.this.stopMyLocationInLoop();
                LocationManager.this.sendOnRealTimeLocationError(errorCode);
            }
        });
    }

    public void unBindConversation() {
        RongIMClient.getInstance().removeRealTimeLocationObserver(this.mConversationType, this.mTargetId);
    }

    public void setUserInfoProvider(IUserInfoProvider userInfoProvider) {
        this.mUserInfoProvider = userInfoProvider;
    }

    public void setParticipantChangedListener(IRealTimeLocationStateListener listener) {
        this.mParticipantChangedListener = listener;
        if (this.mParticipantChangedListener != null) {
            this.mParticipantChangedListener.onParticipantChanged(RongIMClient.getInstance().getRealTimeLocationParticipants(this.mConversationType, this.mTargetId));
        }
    }

    public void setMyLocationChangedListener(IMyLocationChangedListener listener) {
        this.mMyLocationChangedListener = listener;
        if (this.mMyLocationChangedListener != null) {
            this.updateMyLocation();
            if (this.mMyLastLatLng != null) {
                listener.onMyLocationChanged(this.mMyLastLatLng);
            }
        }
    }

    public void setLocationChangedListener(ILocationChangedListener listener) {
        this.mLocationChangedListener = listener;
        if (this.mLocationChangedListener != null && this.mLatLng != null) {
            this.mLocationChangedListener.onLocationChanged(this.mLatLng.latitude, this.mLatLng.longitude, RongIMClient.getInstance().getCurrentUserId());
        }
    }

    public int joinLocationSharing() {
        RongIMClient.ConnectionStatusListener.ConnectionStatus state = RongIMClient.getInstance().getCurrentConnectionStatus();
        if (state != RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTED) {
            return 1;
        }
        RealTimeLocationConstant.RealTimeLocationStatus status = RongIMClient.getInstance().getRealTimeLocationCurrentState(this.mConversationType, this.mTargetId);
        switch (status) {
            case RC_REAL_TIME_LOCATION_STATUS_IDLE: {
                RongIMClient.getInstance().startRealTimeLocation(this.mConversationType, this.mTargetId);
                break;
            }
            case RC_REAL_TIME_LOCATION_STATUS_INCOMING: {
                int errorCode = RongIMClient.getInstance().joinRealTimeLocation(this.mConversationType, this.mTargetId).getValue();
                if (errorCode != RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_EXCEED_MAX_PARTICIPANT.getValue()) break;
                return 2;
            }
        }
        return 0;
    }

    public void quitLocationSharing() {
        RLog.d((String)TAG, (String)"quitLocationSharing");
        RealTimeLocationConstant.RealTimeLocationStatus status = RongIMClient.getInstance().getRealTimeLocationCurrentState(this.mConversationType, this.mTargetId);
        if (status == RealTimeLocationConstant.RealTimeLocationStatus.RC_REAL_TIME_LOCATION_STATUS_CONNECTED || status == RealTimeLocationConstant.RealTimeLocationStatus.RC_REAL_TIME_LOCATION_STATUS_OUTGOING) {
            RongIMClient.getInstance().quitRealTimeLocation(this.mConversationType, this.mTargetId);
            this.stopMyLocationInLoop();
            this.mLatLng = null;
        }
    }

    public void updateMyLocation() {
        MyLocationThread thread = new MyLocationThread();
        thread.start();
    }

    public void updateMyLocationInLoop(int sec) {
        if (this.mLoopThread != null) {
            this.mLoopThread.stopLooping();
        }
        this.mLoopThread = new LoopThread(sec);
        this.mLoopThread.start();
    }

    public void stopMyLocationInLoop() {
        if (this.mLoopThread != null) {
            this.mLoopThread.stopLooping();
            this.mLoopThread = null;
        }
    }

    public boolean isSharing() {
        RealTimeLocationConstant.RealTimeLocationStatus status = RongIMClient.getInstance().getRealTimeLocationCurrentState(this.mConversationType, this.mTargetId);
        return status == RealTimeLocationConstant.RealTimeLocationStatus.RC_REAL_TIME_LOCATION_STATUS_CONNECTED || status == RealTimeLocationConstant.RealTimeLocationStatus.RC_REAL_TIME_LOCATION_STATUS_OUTGOING;
    }

    private void sendOnParticipantChanged() {
        if (this.mContext != null && this.mParticipantChangedListener != null) {
            List userIdList = RongIMClient.getInstance().getRealTimeLocationParticipants(this.mConversationType, this.mTargetId);
            this.mParticipantChangedListener.onParticipantChanged(userIdList);
        }
    }

    private void sendOnMyLocationChanged(AMapLocationInfo locInfo) {
        if (this.mContext != null && this.mMyLocationChangedListener != null && locInfo != null) {
            this.mMyLocationChangedListener.onMyLocationChanged(locInfo);
        }
    }

    private void sendOnRealTimeLocationError(RealTimeLocationConstant.RealTimeLocationErrorCode code) {
        if (this.mContext != null && this.mLocationChangedListener != null) {
            this.mLocationChangedListener.onError(code);
        }
        if (this.mParticipantChangedListener != null) {
            this.mParticipantChangedListener.onErrorException();
        }
    }

    private void sendOnLocationChanged(double latitude, double longitude, String userId) {
        if (this.mContext != null && this.mLocationChangedListener != null) {
            this.mLocationChangedListener.onLocationChanged(latitude, longitude, userId);
        }
    }

    private void sendOnParticipantJoinSharing(String userId) {
        if (this.mContext != null && this.mLocationChangedListener != null) {
            this.mLocationChangedListener.onParticipantJoinSharing(userId);
        }
    }

    private void sendOnParticipantQuitSharing(String userId) {
        if (this.mContext != null && this.mLocationChangedListener != null) {
            this.mLocationChangedListener.onParticipantQuitSharing(userId);
        }
    }

    private class MyLocationThread
    extends Thread {
        private MyLocationThread() {
        }

        @Override
        public void run() {
            if (LocationManager.this.mLocationClient == null) {
                LocationManager.this.mLocationClient = new AMapNetworkLocationClient(LocationManager.this.mContext);
                LocationManager.this.mLocationClient.setApiKey("8bc77f14ab831d62baaf2ed17fb798a4");
            }
            String locStr = LocationManager.this.mLocationClient.getNetworkLocation();
            RLog.d((String)LocationManager.TAG, (String)("MyLocationThread location: " + locStr));
            AMapLocationInfo locInfo = LocationManager.this.mLocationParser.parserApsJsonResp(locStr);
            LocationManager.this.sendOnMyLocationChanged(locInfo);
            LocationManager.this.mMyLastLatLng = locInfo;
        }
    }

    private class LoopThread
    extends Thread {
        private boolean mLooping;
        private int mMilSec;

        public LoopThread(int sec) {
            this.mMilSec = sec * 1000;
        }

        public void stopLooping() {
            this.mLooping = false;
        }

        @Override
        public void run() {
            this.mLooping = true;
            while (this.mLooping) {
                if (LocationManager.this.mLocationClient == null) {
                    LocationManager.this.mLocationClient = new AMapNetworkLocationClient(LocationManager.this.mContext);
                    LocationManager.this.mLocationClient.setApiKey("8bc77f14ab831d62baaf2ed17fb798a4");
                }
                String locStr = LocationManager.this.mLocationClient.getNetworkLocation();
                RLog.d((String)LocationManager.TAG, (String)("LoopThread location: " + locStr));
                if (!TextUtils.isEmpty((CharSequence)locStr)) {
                    AMapLocationInfo locInfo = LocationManager.this.mLocationParser.parserApsJsonResp(locStr);
                    RealTimeLocationType realTimeLocationType = locInfo.getCoord() == 1 ? RealTimeLocationType.GCJ02 : RealTimeLocationType.WGS84;
                    RongIMClient.getInstance().updateRealTimeLocationStatus(LocationManager.this.mConversationType, LocationManager.this.mTargetId, locInfo.getLat(), locInfo.getLng(), realTimeLocationType);
                    LocationManager.this.mMyLastLatLng = locInfo;
                }
                try {
                    LoopThread.sleep(this.mMilSec);
                }
                catch (InterruptedException e) {
                    RLog.e((String)LocationManager.TAG, (String)"LoopThread run", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static class SingletonHolder {
        private static final LocationManager INSTANCE = new LocationManager();

        private SingletonHolder() {
        }
    }
}

