/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.plugin.location;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.amap.api.maps.AMap;
import com.amap.api.maps.CameraUpdate;
import com.amap.api.maps.CameraUpdateFactory;
import com.amap.api.maps.MapView;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;
import io.rong.common.RLog;
import io.rong.imageloader.core.DisplayImageOptions;
import io.rong.imageloader.core.ImageLoader;
import io.rong.imageloader.core.assist.LoadedFrom;
import io.rong.imageloader.core.display.CircleBitmapDisplayer;
import io.rong.imageloader.core.imageaware.ImageViewAware;
import io.rong.imkit.R;
import io.rong.imkit.RongBaseNoActionbarActivity;
import io.rong.imkit.plugin.location.AMapLocationInfo;
import io.rong.imkit.plugin.location.ILocationChangedListener;
import io.rong.imkit.plugin.location.IMyLocationChangedListener;
import io.rong.imkit.plugin.location.IUserInfoProvider;
import io.rong.imkit.plugin.location.LocationManager;
import io.rong.imkit.utilities.PromptPopupDialog;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.location.RealTimeLocationConstant;
import io.rong.imlib.model.UserInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AMapRealTimeActivity
extends RongBaseNoActionbarActivity
implements ILocationChangedListener,
IUserInfoProvider.UserInfoCallback {
    private static final String TAG = "AMapRealTimeActivity";
    private MapView mAMapView;
    private ViewGroup mTitleBar;
    private TextView mUserText;
    private Handler mHandler;
    private AMap mAMap;
    private Map<String, UserTarget> mUserTargetMap;
    private ArrayList<String> mParticipants;
    private boolean mHasAnimate;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.rc_location_real_time_activity);
        this.mHandler = new Handler();
        this.mUserTargetMap = new HashMap<String, UserTarget>();
        this.mAMapView = (MapView)this.findViewById(R.id.rc_ext_amap);
        this.mAMapView.onCreate(savedInstanceState);
        View exitView = this.findViewById(R.id.rc_toolbar_close);
        exitView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PromptPopupDialog dialog = PromptPopupDialog.newInstance(v.getContext(), "", AMapRealTimeActivity.this.getString(R.string.rc_ext_exit_location_sharing), AMapRealTimeActivity.this.getString(R.string.rc_ext_exit_location_sharing_confirm));
                dialog.setPromptButtonClickedListener(new PromptPopupDialog.OnPromptButtonClickedListener(){

                    @Override
                    public void onPositiveButtonClicked() {
                        LocationManager.getInstance().quitLocationSharing();
                        AMapRealTimeActivity.this.finish();
                    }
                });
                dialog.show();
            }
        });
        View closeView = this.findViewById(R.id.rc_toolbar_hide);
        closeView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AMapRealTimeActivity.this.finish();
            }
        });
        this.mTitleBar = (ViewGroup)this.findViewById(R.id.rc_user_icons);
        this.mUserText = (TextView)this.findViewById(R.id.rc_user_text);
        this.mParticipants = this.getIntent().getStringArrayListExtra("participants");
        if (this.mParticipants == null) {
            this.mParticipants = new ArrayList();
            this.mParticipants.add(RongIMClient.getInstance().getCurrentUserId());
        }
        this.initMap();
        LocationManager.getInstance().setLocationChangedListener(this);
        LocationManager.getInstance().setMyLocationChangedListener(new IMyLocationChangedListener(){

            @Override
            public void onMyLocationChanged(AMapLocationInfo locInfo) {
                AMapRealTimeActivity.this.updateParticipantMarker(locInfo.getLat(), locInfo.getLng(), RongIMClient.getInstance().getCurrentUserId());
            }
        });
        LocationManager.getInstance().updateMyLocationInLoop(5);
    }

    private void initMap() {
        this.mAMap = this.mAMapView.getMap();
        this.mAMap.getUiSettings().setMyLocationButtonEnabled(false);
        this.mAMap.setMapType(1);
        for (String userId : this.mParticipants) {
            UserTarget userTarget = this.createUserTargetById(userId);
            this.mUserTargetMap.put(userId, userTarget);
            LocationManager.getInstance().getUserInfo(userId, this);
            this.updateParticipantTitleText();
        }
        CameraUpdate zoom = CameraUpdateFactory.zoomTo((float)17.0f);
        this.mAMap.animateCamera(zoom, null);
    }

    @Override
    public void onGotUserInfo(UserInfo userInfo) {
        String userId = userInfo.getUserId();
        UserTarget userTarget = this.mUserTargetMap.get(userId);
        if (userTarget != null) {
            this.setAvatar(userTarget.getTargetView(), userInfo.getPortraitUri() != null ? userInfo.getPortraitUri().toString() : null);
            View iconView = LayoutInflater.from((Context)this).inflate(R.layout.rc_icon_rt_location_marker, null);
            ImageView imageView = (ImageView)iconView.findViewById(16908294);
            ImageView locImageView = (ImageView)iconView.findViewById(16908295);
            this.setAvatar(imageView, userInfo.getPortraitUri() != null ? userInfo.getPortraitUri().toString() : null);
            if (userId.equals(RongIMClient.getInstance().getCurrentUserId())) {
                locImageView.setImageResource(R.drawable.rc_rt_loc_myself);
            } else {
                locImageView.setImageResource(R.drawable.rc_rt_loc_other);
            }
            userTarget.getTargetMarker().setIcon(BitmapDescriptorFactory.fromView((View)iconView));
        }
    }

    @Override
    public void onLocationChanged(double latitude, double longitude, String userId) {
        this.updateParticipantMarker(latitude, longitude, userId);
    }

    @Override
    public void onParticipantJoinSharing(String userId) {
        if (this.mUserTargetMap.get(userId) != null) {
            return;
        }
        if (!this.mParticipants.contains(userId)) {
            this.mParticipants.add(userId);
        }
        UserTarget userTarget = this.createUserTargetById(userId);
        this.mUserTargetMap.put(userId, userTarget);
        LocationManager.getInstance().getUserInfo(userId, this);
        this.updateParticipantTitleText();
    }

    @Override
    public void onParticipantQuitSharing(String userId) {
        UserTarget userTarget = this.mUserTargetMap.get(userId);
        this.mParticipants.remove(userId);
        if (userTarget != null) {
            this.mUserTargetMap.remove(userId);
            this.removeParticipantTitleIcon(userTarget);
            this.updateParticipantTitleText();
            this.removeParticipantMarker(userTarget);
        }
    }

    @Override
    public void onError(RealTimeLocationConstant.RealTimeLocationErrorCode code) {
        Toast.makeText((Context)this, (int)R.string.rc_network_exception, (int)0).show();
        LocationManager.getInstance().quitLocationSharing();
        this.finish();
    }

    @Override
    public void onSharingTerminated() {
    }

    private DisplayImageOptions createDisplayImageOptions(int defaultResId) {
        DisplayImageOptions.Builder builder = new DisplayImageOptions.Builder();
        if (defaultResId != 0) {
            Drawable defaultDrawable = this.getResources().getDrawable(defaultResId);
            builder.showImageOnLoading(defaultDrawable);
            builder.showImageForEmptyUri(defaultDrawable);
            builder.showImageOnFail(defaultDrawable);
        }
        builder.displayer(new CircleBitmapDisplayer());
        return builder.resetViewBeforeLoading(false).cacheInMemory(true).cacheOnDisk(true).bitmapConfig(Bitmap.Config.RGB_565).build();
    }

    private Bitmap drawableToBitmap(Drawable drawable2) {
        int width = drawable2.getIntrinsicWidth();
        int height = drawable2.getIntrinsicHeight();
        Bitmap.Config config = drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, width, height);
        drawable2.draw(canvas);
        return bitmap;
    }

    private void setAvatar(ImageView imageView, String url) {
        DisplayImageOptions options = this.createDisplayImageOptions(url == null ? R.drawable.rc_ext_realtime_default_avatar : 0);
        ImageViewAware imageViewAware = new ImageViewAware(imageView);
        if (url == null) {
            Drawable drawable2 = options.getImageForEmptyUri(null);
            try {
                Bitmap bitmap = this.drawableToBitmap(drawable2);
                options.getDisplayer().display(bitmap, imageViewAware, LoadedFrom.DISC_CACHE);
            }
            catch (Exception e) {
                RLog.e((String)TAG, (String)"setAvatar", (Throwable)e);
            }
        } else {
            File file = ImageLoader.getInstance().getDiskCache().get(url);
            if (file != null && file.exists()) {
                try {
                    BitmapFactory.Options opt = new BitmapFactory.Options();
                    opt.inSampleSize = 1;
                    Bitmap bitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)opt);
                    options.getDisplayer().display(bitmap, imageViewAware, LoadedFrom.DISC_CACHE);
                }
                catch (Exception e) {
                    RLog.e((String)TAG, (String)"setAvatar", (Throwable)e);
                }
            } else if (!TextUtils.isEmpty((CharSequence)url)) {
                ImageLoader.getInstance().displayImage(url, imageViewAware, options, null, null);
            } else {
                RLog.e((String)TAG, (String)"SetAvatar, url is empty");
            }
        }
    }

    protected void onDestroy() {
        RLog.d((String)TAG, (String)"onDestroy()");
        this.mAMapView.onDestroy();
        LocationManager.getInstance().setLocationChangedListener(null);
        LocationManager.getInstance().setMyLocationChangedListener(null);
        super.onDestroy();
    }

    private UserTarget createUserTargetById(String userId) {
        if (this.mUserTargetMap.get(userId) != null) {
            return this.mUserTargetMap.get(userId);
        }
        UserTarget userTarget = new UserTarget();
        userTarget.setTargetView(new ImageView((Context)this));
        userTarget.getTargetView().setTag((Object)userId);
        userTarget.getTargetView().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String userId = (String)v.getTag();
                UserTarget user = (UserTarget)AMapRealTimeActivity.this.mUserTargetMap.get(userId);
                LatLng latLng = null;
                if (user != null) {
                    latLng = user.getTargetMarker().getPosition();
                }
                if (latLng != null) {
                    CameraUpdate update = CameraUpdateFactory.changeLatLng((LatLng)latLng);
                    AMapRealTimeActivity.this.mAMap.animateCamera(update, null);
                }
            }
        });
        float scale = Resources.getSystem().getDisplayMetrics().density;
        int hw = (int)(40.0f * scale + 0.5f);
        int pd = (int)(2.0f * scale + 0.5f);
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(hw, hw);
        userTarget.getTargetView().setLayoutParams(lp);
        userTarget.getTargetView().setPadding(pd, pd, pd, pd);
        this.setAvatar(userTarget.getTargetView(), null);
        this.mTitleBar.addView((View)userTarget.getTargetView());
        View iconView = LayoutInflater.from((Context)this).inflate(R.layout.rc_icon_rt_location_marker, null);
        ImageView locImageView = (ImageView)iconView.findViewById(16908295);
        ImageView avatar = (ImageView)iconView.findViewById(16908294);
        this.setAvatar(avatar, null);
        if (userId.equals(RongIMClient.getInstance().getCurrentUserId())) {
            locImageView.setImageResource(R.drawable.rc_rt_loc_myself);
        } else {
            locImageView.setImageResource(R.drawable.rc_rt_loc_other);
        }
        MarkerOptions markerOptions = new MarkerOptions().anchor(0.5f, 0.5f).icon(BitmapDescriptorFactory.fromView((View)iconView));
        userTarget.setTargetMarker(this.mAMap.addMarker(markerOptions));
        return userTarget;
    }

    private void removeParticipantTitleIcon(final UserTarget userTarget) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                AMapRealTimeActivity.this.mTitleBar.removeView((View)userTarget.getTargetView());
            }
        });
    }

    private void updateParticipantTitleText() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (AMapRealTimeActivity.this.mUserTargetMap.size() == 0) {
                    RLog.e((String)AMapRealTimeActivity.TAG, (String)"mUserTargetMap size is 0 ");
                } else {
                    AMapRealTimeActivity.this.mUserText.setText((CharSequence)String.format(AMapRealTimeActivity.this.getResources().getString(R.string.rc_others_are_sharing_location2), AMapRealTimeActivity.this.mUserTargetMap.size()));
                }
            }
        });
    }

    private void updateParticipantMarker(final double latitude, final double longitude, final String userId) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                UserTarget target = (UserTarget)AMapRealTimeActivity.this.mUserTargetMap.get(userId);
                if (target == null) {
                    target = AMapRealTimeActivity.this.createUserTargetById(userId);
                    AMapRealTimeActivity.this.mUserTargetMap.put(userId, target);
                    LocationManager.getInstance().getUserInfo(userId, AMapRealTimeActivity.this);
                    if (!AMapRealTimeActivity.this.mParticipants.contains(userId)) {
                        AMapRealTimeActivity.this.mParticipants.add(userId);
                    }
                }
                target.getTargetMarker().setPosition(new LatLng(latitude, longitude));
                AMapRealTimeActivity.this.updateParticipantTitleText();
                if (userId.equals(RongIMClient.getInstance().getCurrentUserId()) && !AMapRealTimeActivity.this.mHasAnimate && latitude != 0.0 && longitude != 0.0) {
                    CameraUpdate update = CameraUpdateFactory.changeLatLng((LatLng)new LatLng(latitude, longitude));
                    AMapRealTimeActivity.this.mAMap.animateCamera(update, null);
                    AMapRealTimeActivity.this.mHasAnimate = true;
                }
            }
        });
    }

    private void removeParticipantMarker(UserTarget userTarget) {
        userTarget.getTargetMarker().remove();
    }

    protected void onResume() {
        super.onResume();
        this.mAMapView.onResume();
    }

    protected void onPause() {
        super.onPause();
        this.mAMapView.onPause();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mAMapView.onSaveInstanceState(outState);
    }

    private class UserTarget {
        private ImageView targetView;
        private Marker targetMarker;

        private UserTarget() {
        }

        public ImageView getTargetView() {
            return this.targetView;
        }

        public void setTargetView(ImageView targetView) {
            this.targetView = targetView;
        }

        public Marker getTargetMarker() {
            return this.targetMarker;
        }

        public void setTargetMarker(Marker targetMarker) {
            this.targetMarker = targetMarker;
        }
    }
}

