/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.plugin.location;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.amap.api.maps2d.AMap;
import com.amap.api.maps2d.CameraUpdate;
import com.amap.api.maps2d.CameraUpdateFactory;
import com.amap.api.maps2d.LocationSource;
import com.amap.api.maps2d.MapView;
import com.amap.api.maps2d.model.BitmapDescriptor;
import com.amap.api.maps2d.model.BitmapDescriptorFactory;
import com.amap.api.maps2d.model.CameraPosition;
import com.amap.api.maps2d.model.LatLng;
import com.amap.api.maps2d.model.Marker;
import com.amap.api.maps2d.model.MarkerOptions;
import com.amap.api.maps2d.model.MyLocationStyle;
import com.amap.api.services.core.LatLonPoint;
import com.amap.api.services.core.PoiItem;
import com.amap.api.services.geocoder.GeocodeResult;
import com.amap.api.services.geocoder.GeocodeSearch;
import com.amap.api.services.geocoder.RegeocodeAddress;
import com.amap.api.services.geocoder.RegeocodeQuery;
import com.amap.api.services.geocoder.RegeocodeResult;
import com.amap.api.services.poisearch.PoiResult;
import com.amap.api.services.poisearch.PoiSearch;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongBaseActivity;
import io.rong.imkit.plugin.location.AMapLocationInfo;
import io.rong.imkit.plugin.location.IMyLocationChangedListener;
import io.rong.imkit.plugin.location.LocationManager2D;
import io.rong.imkit.plugin.location.SearchLocationActivity;
import io.rong.imkit.utilities.RongUtils;
import java.util.ArrayList;
import java.util.List;

public class AMapLocationActivity2D
extends RongBaseActivity
implements LocationSource,
AMap.OnCameraChangeListener,
GeocodeSearch.OnGeocodeSearchListener,
IMyLocationChangedListener,
View.OnClickListener {
    private static final String TAG = "AMapLocationActivity2D";
    private static final int REQUEST_CODE_ASK_PERMISSIONS = 100;
    private static final int REQUEST_SEARCH_LOCATION = 1;
    private static final int PAGE_COUNT = 20;
    private int currentPage = 1;
    private int mTouchSlop;
    private BitmapDescriptor mBitmapDescriptor;
    private MapView mAMapView;
    private AMap mAMap;
    private TextView mLocationTip;
    private Handler mHandler;
    private Marker mMarker;
    private GeocodeSearch mGeocodeSearch;
    private LocationSource.OnLocationChangedListener mLocationChangedListener;
    private double mMyLat;
    private double mMyLng;
    private String mMyPoi;
    private double mLatResult;
    private double mLngResult;
    private String mPoiResult;
    private ListView listViewNearby;
    private NearbyListAdapter nearbyListAdapter;
    private ProgressBar listLoadingView;
    private float Y;
    private float downY;
    private float lastY;
    private int flag = 0;
    private String cityCode = "";
    ValueAnimator animator;
    private AbsListView.OnScrollListener onScrollListener = new AbsListView.OnScrollListener(){

        public void onScrollStateChanged(AbsListView view, int scrollState) {
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            View lastVisibleItemView;
            if (firstVisibleItem != 0 && firstVisibleItem + visibleItemCount == totalItemCount && (lastVisibleItemView = AMapLocationActivity2D.this.listViewNearby.getChildAt(AMapLocationActivity2D.this.listViewNearby.getChildCount() - 1)) != null && lastVisibleItemView.getBottom() == AMapLocationActivity2D.this.listViewNearby.getHeight()) {
                AMapLocationActivity2D.this.loadNextPageNearByView();
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.rc_plugin_location_activity_2d);
        this.mAMapView = (MapView)this.findViewById(R.id.rc_ext_amap);
        this.initNearbyView();
        this.mHandler = new Handler();
        this.mLocationTip = (TextView)this.findViewById(R.id.rc_ext_location_marker);
        this.searchButton.setVisibility(0);
        this.searchButton.setOnClickListener((View.OnClickListener)this);
        ImageView myLocationView = (ImageView)this.findViewById(R.id.rc_ext_my_location);
        myLocationView.setOnClickListener((View.OnClickListener)this);
        Button ok = (Button)this.findViewById(R.id.rc_action_bar_ok);
        ok.setText((CharSequence)this.getResources().getString(R.string.rc_ext_send));
        ok.setVisibility(0);
        ok.setOnClickListener((View.OnClickListener)this);
        TextView title = (TextView)this.findViewById(R.id.rc_action_bar_title);
        title.setText(R.string.rc_plugin_location);
        this.mAMapView.onCreate(savedInstanceState);
        this.initMap();
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 100) {
            if (grantResults[0] == 0 && permissions[0].equals("android.permission.ACCESS_COARSE_LOCATION")) {
                this.initMap();
            }
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    private void initMap() {
        this.mAMap = this.mAMapView.getMap();
        this.mAMap.setLocationSource((LocationSource)this);
        this.mAMap.setMyLocationEnabled(true);
        this.mAMap.getUiSettings().setZoomControlsEnabled(false);
        this.mAMap.getUiSettings().setMyLocationButtonEnabled(false);
        this.mAMap.setMapType(1);
        MyLocationStyle myLocationStyle = new MyLocationStyle();
        myLocationStyle.myLocationIcon(BitmapDescriptorFactory.fromResource((int)R.drawable.rc_ext_my_locator));
        myLocationStyle.strokeWidth(0.0f);
        myLocationStyle.strokeColor(R.color.rc_main_theme);
        myLocationStyle.radiusFillColor(0);
        this.mAMap.setMyLocationStyle(myLocationStyle);
        this.mGeocodeSearch = new GeocodeSearch((Context)this);
        this.mGeocodeSearch.setOnGeocodeSearchListener((GeocodeSearch.OnGeocodeSearchListener)this);
        LocationManager2D.getInstance().setMyLocationChangedListener(this);
    }

    public void onRegeocodeSearched(RegeocodeResult regeocodeResult, int i) {
        RLog.e((String)TAG, (String)"onRegeocodeSearched");
        if (regeocodeResult != null) {
            RegeocodeAddress regeocodeAddress = regeocodeResult.getRegeocodeAddress();
            this.mLatResult = regeocodeResult.getRegeocodeQuery().getPoint().getLatitude();
            this.mLngResult = regeocodeResult.getRegeocodeQuery().getPoint().getLongitude();
            String formatAddress = regeocodeResult.getRegeocodeAddress().getFormatAddress();
            this.mPoiResult = formatAddress.replace(regeocodeAddress.getProvince(), "").replace(regeocodeAddress.getCity(), "").replace(regeocodeAddress.getDistrict(), "");
            this.mLocationTip.setText((CharSequence)this.mPoiResult);
            LatLng latLng = new LatLng(this.mLatResult, this.mLngResult);
            if (this.mMarker != null) {
                this.mMarker.setPosition(latLng);
            }
            this.updateNearByView(this.mPoiResult);
        } else {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.rc_location_fail), (int)0).show();
        }
    }

    private String getMapUrl(double latitude, double longitude) {
        return "http://restapi.amap.com/v3/staticmap?location=" + longitude + "," + latitude + "&zoom=16&scale=2&size=408*240&markers=mid,,A:" + longitude + "," + latitude + "&key=e09af6a2b26c02086e9216bd07c960ae";
    }

    public void onGeocodeSearched(GeocodeResult geocodeResult, int i) {
    }

    public void activate(LocationSource.OnLocationChangedListener onLocationChangedListener) {
        this.mLocationChangedListener = onLocationChangedListener;
    }

    public void deactivate() {
    }

    public void onCameraChange(CameraPosition cameraPosition) {
        RLog.d((String)TAG, (String)"onCameraChange");
        if (Build.VERSION.SDK_INT < 11) {
            this.mMarker.setPosition(cameraPosition.target);
        }
    }

    public void onCameraChangeFinish(CameraPosition cameraPosition) {
        RLog.d((String)TAG, (String)"onCameraChangeFinish");
        LatLonPoint point = new LatLonPoint(cameraPosition.target.latitude, cameraPosition.target.longitude);
        RegeocodeQuery query = new RegeocodeQuery(point, 50.0f, "autonavi");
        this.mGeocodeSearch.getFromLocationAsyn(query);
        if (this.mMarker != null) {
            this.animMarker();
        }
    }

    private void addLocatedMarker(LatLng latLng, String poi) {
        this.mBitmapDescriptor = BitmapDescriptorFactory.fromResource((int)R.drawable.rc_ext_location_marker);
        MarkerOptions markerOptions = new MarkerOptions().position(latLng).icon(this.mBitmapDescriptor);
        if (this.mMarker != null) {
            this.mMarker.remove();
        }
        this.mMarker = this.mAMap.addMarker(markerOptions);
        this.mMarker.setPositionByPixels(this.mAMapView.getWidth() / 2, this.mAMapView.getHeight() / 2);
        this.mLocationTip.setText((CharSequence)String.format("%s", poi));
    }

    @TargetApi(value=11)
    private void animMarker() {
        if (Build.VERSION.SDK_INT > 11) {
            if (this.animator != null) {
                this.animator.start();
                return;
            }
            this.animator = ValueAnimator.ofFloat((float[])new float[]{this.mAMapView.getHeight() / 2, this.mAMapView.getHeight() / 2 - 30});
            this.animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            this.animator.setDuration(150L);
            this.animator.setRepeatCount(1);
            this.animator.setRepeatMode(2);
            this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    RLog.d((String)AMapLocationActivity2D.TAG, (String)"onAnimationUpdate");
                    Float value = (Float)animation.getAnimatedValue();
                    AMapLocationActivity2D.this.mMarker.setPositionByPixels(AMapLocationActivity2D.this.mAMapView.getWidth() / 2, Math.round(value.floatValue()));
                }
            });
            this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    AMapLocationActivity2D.this.mMarker.setIcon(AMapLocationActivity2D.this.mBitmapDescriptor);
                }
            });
            this.animator.start();
        }
    }

    protected void onDestroy() {
        this.mAMapView.onDestroy();
        LocationManager2D.getInstance().setMyLocationChangedListener(null);
        super.onDestroy();
    }

    @Override
    public void onMyLocationChanged(final AMapLocationInfo locationInfo) {
        RLog.d((String)TAG, (String)"onLocationChanged");
        if (this.mLocationChangedListener != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (locationInfo != null) {
                        AMapLocationActivity2D.this.mMyLat = (AMapLocationActivity2D.this.mLatResult = locationInfo.getLat());
                        AMapLocationActivity2D.this.mMyLng = (AMapLocationActivity2D.this.mLngResult = locationInfo.getLng());
                        AMapLocationActivity2D.this.mMyPoi = (AMapLocationActivity2D.this.mPoiResult = locationInfo.getStreet() + locationInfo.getPoiname());
                        AMapLocationActivity2D.this.cityCode = locationInfo.getCitycode();
                        AMapLocationActivity2D.this.updateNearByView(AMapLocationActivity2D.this.mMyPoi);
                        Location location = new Location("AMap");
                        location.setLatitude(locationInfo.getLat());
                        location.setLongitude(locationInfo.getLng());
                        location.setTime(locationInfo.getTime());
                        location.setAccuracy(locationInfo.getAccuracy());
                        AMapLocationActivity2D.this.mLocationChangedListener.onLocationChanged(location);
                        LatLng mLatLang = new LatLng(AMapLocationActivity2D.this.mLatResult, AMapLocationActivity2D.this.mLngResult);
                        AMapLocationActivity2D.this.addLocatedMarker(mLatLang, AMapLocationActivity2D.this.mPoiResult);
                        CameraUpdate update = CameraUpdateFactory.changeLatLng((LatLng)mLatLang);
                        AMapLocationActivity2D.this.mAMap.animateCamera(update, new AMap.CancelableCallback(){

                            public void onFinish() {
                                AMapLocationActivity2D.this.mAMap.setOnCameraChangeListener((AMap.OnCameraChangeListener)AMapLocationActivity2D.this);
                            }

                            public void onCancel() {
                            }
                        });
                    } else {
                        Toast.makeText((Context)AMapLocationActivity2D.this, (CharSequence)AMapLocationActivity2D.this.getString(R.string.rc_location_fail), (int)0).show();
                    }
                }
            });
        }
    }

    private void initNearbyView() {
        this.listViewNearby = (ListView)this.findViewById(R.id.rc_list_nearby);
        this.listLoadingView = (ProgressBar)this.findViewById(R.id.rc_ext_loading);
        this.listViewNearby.setVisibility(8);
        this.listLoadingView.setVisibility(0);
        this.mTouchSlop = ViewConfiguration.get((Context)this).getScaledTouchSlop();
        this.listViewNearby.setOnScrollListener(this.onScrollListener);
        this.listViewNearby.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                for (int i = 0; i < AMapLocationActivity2D.this.nearbyListAdapter.getCount(); ++i) {
                    MapNearbyInfo mapNearbyInfo = (MapNearbyInfo)AMapLocationActivity2D.this.nearbyListAdapter.getItem(i);
                    if (i == position) {
                        mapNearbyInfo.setChecked(true);
                        AMapLocationActivity2D.this.mLngResult = mapNearbyInfo.getLongitude();
                        AMapLocationActivity2D.this.mLatResult = mapNearbyInfo.getLatitude();
                        AMapLocationActivity2D.this.mPoiResult = mapNearbyInfo.getPoi();
                        AMapLocationActivity2D.this.updateCheckedMapView(AMapLocationActivity2D.this.mLngResult, AMapLocationActivity2D.this.mLatResult, AMapLocationActivity2D.this.mPoiResult);
                        continue;
                    }
                    mapNearbyInfo.setChecked(false);
                }
                AMapLocationActivity2D.this.nearbyListAdapter.notifyDataSetChanged();
            }
        });
        this.listViewNearby.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                AMapLocationActivity2D.this.Y = event.getRawY();
                switch (event.getAction()) {
                    case 0: {
                        AMapLocationActivity2D.this.downY = AMapLocationActivity2D.this.Y;
                        AMapLocationActivity2D.this.lastY = AMapLocationActivity2D.this.Y;
                        break;
                    }
                    case 2: {
                        if (!(Math.abs(AMapLocationActivity2D.this.Y - AMapLocationActivity2D.this.downY) > (float)AMapLocationActivity2D.this.mTouchSlop)) break;
                        if (AMapLocationActivity2D.this.Y - AMapLocationActivity2D.this.downY >= 0.0f && AMapLocationActivity2D.this.Y - AMapLocationActivity2D.this.lastY >= 0.0f) {
                            AMapLocationActivity2D.this.lastY = AMapLocationActivity2D.this.Y;
                            return AMapLocationActivity2D.this.handleScrollState(ScrollDirection.SCROLL_DOWN);
                        }
                        AMapLocationActivity2D.this.lastY = AMapLocationActivity2D.this.Y;
                        return AMapLocationActivity2D.this.handleScrollState(ScrollDirection.SCROLL_UP);
                    }
                    case 1: {
                        AMapLocationActivity2D.this.Y = 0.0f;
                        if (AMapLocationActivity2D.this.flag == 1) {
                            AMapLocationActivity2D.this.flag = 0;
                            return true;
                        }
                        AMapLocationActivity2D.this.lastY = 0.0f;
                    }
                }
                return false;
            }
        });
    }

    private boolean handleScrollState(ScrollDirection scrollDirection) {
        int minHeight = (int)this.getResources().getDimension(R.dimen.rc_ext_location_nearby_list_min_height);
        int maxHeight = (int)this.getResources().getDimension(R.dimen.rc_ext_location_nearby_list_max_height);
        if (scrollDirection == ScrollDirection.SCROLL_DOWN) {
            return this.updateListViewHeight(maxHeight, minHeight);
        }
        return this.updateListViewHeight(minHeight, maxHeight);
    }

    private boolean updateListViewHeight(int oldHeight, int newHeight) {
        int height = this.listViewNearby.getHeight();
        if (this.listViewNearby == null || this.listViewNearby.getChildAt(0) == null) {
            return false;
        }
        int top = this.listViewNearby.getChildAt(0).getTop();
        if (top == 0 && Math.abs(this.Y - this.downY) > (float)this.mTouchSlop && this.flag == 0 && height == oldHeight) {
            this.flag = 1;
        }
        if (this.flag == 1) {
            ViewGroup.LayoutParams layoutParams = this.listViewNearby.getLayoutParams();
            layoutParams.height = newHeight;
            this.listViewNearby.setLayoutParams(layoutParams);
            LatLng latLng = new LatLng(this.mLatResult, this.mLngResult);
            if (this.mMarker != null) {
                this.mMarker.setPosition(latLng);
            }
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mLocationTip.getLayoutParams();
            if (oldHeight < newHeight) {
                int marginTop = RongUtils.dip2px(3.0f);
                int marginLeft = RongUtils.dip2px(20.0f);
                int marginRight = RongUtils.dip2px(20.0f);
                params.setMargins(marginLeft, marginTop, marginRight, 0);
                this.mLocationTip.setLayoutParams((ViewGroup.LayoutParams)params);
            } else {
                int marginTop = RongUtils.dip2px(20.0f);
                int marginLeft = RongUtils.dip2px(20.0f);
                int marginRight = RongUtils.dip2px(20.0f);
                params.setMargins(marginLeft, marginTop, marginRight, 0);
                this.mLocationTip.setLayoutParams((ViewGroup.LayoutParams)params);
            }
            return true;
        }
        return false;
    }

    private void updateNearByView(final String poi) {
        PoiSearch.Query query = new PoiSearch.Query("", "\u6c7d\u8f66\u670d\u52a1|\u6c7d\u8f66\u9500\u552e|\u6c7d\u8f66\u7ef4\u4fee|\u6469\u6258\u8f66\u670d\u52a1|\u9910\u996e\u670d\u52a1|\u8d2d\u7269\u670d\u52a1|\u751f\u6d3b\u670d\u52a1|\u4f53\u80b2\u4f11\u95f2\u670d\u52a1|\u533b\u7597\u4fdd\u5065\u670d\u52a1|\u4f4f\u5bbf\u670d\u52a1|\u98ce\u666f\u540d\u80dc|\u5546\u52a1\u4f4f\u5b85|\u653f\u5e9c\u673a\u6784\u53ca\u793e\u4f1a\u56e2\u4f53|\u79d1\u6559\u6587\u5316\u670d\u52a1|\u4ea4\u901a\u8bbe\u65bd\u670d\u52a1|\u91d1\u878d\u4fdd\u9669\u670d\u52a1|\u516c\u53f8\u4f01\u4e1a|\u9053\u8def\u9644\u5c5e\u8bbe\u65bd|\u5730\u540d\u5730\u5740\u4fe1\u606f|\u516c\u5171\u8bbe\u65bd", "");
        query.setPageSize(20);
        this.currentPage = 1;
        query.setPageNum(this.currentPage);
        PoiSearch poiSearch = new PoiSearch((Context)this, query);
        double longitude = this.mLngResult;
        double latitude = this.mLatResult;
        if (latitude != 0.0 && longitude != 0.0) {
            poiSearch.setBound(new PoiSearch.SearchBound(new LatLonPoint(latitude, longitude), 6000));
            poiSearch.setOnPoiSearchListener(new PoiSearch.OnPoiSearchListener(){

                public void onPoiSearched(PoiResult poiResult, int i) {
                    if (poiResult != null && poiResult.getPois().size() > 0) {
                        ArrayList<MapNearbyInfo> mapNearbyInfos = new ArrayList<MapNearbyInfo>();
                        ArrayList poiItemList = poiResult.getPois();
                        MapNearbyInfo nearbyInfo = new MapNearbyInfo();
                        nearbyInfo.setName(poi);
                        nearbyInfo.setChecked(true);
                        nearbyInfo.setLongitude(AMapLocationActivity2D.this.mLngResult);
                        nearbyInfo.setLatitude(AMapLocationActivity2D.this.mLatResult);
                        nearbyInfo.setPoi(poi);
                        mapNearbyInfos.add(nearbyInfo);
                        for (int j = 0; j < poiItemList.size(); ++j) {
                            PoiItem poiItem = (PoiItem)poiItemList.get(j);
                            nearbyInfo = new MapNearbyInfo(poiItem.getTitle(), poiItem.getSnippet());
                            nearbyInfo.setLongitude(poiItem.getLatLonPoint().getLongitude());
                            nearbyInfo.setLatitude(poiItem.getLatLonPoint().getLatitude());
                            nearbyInfo.setPoi(poiItem.getTitle());
                            mapNearbyInfos.add(nearbyInfo);
                        }
                        AMapLocationActivity2D.this.nearbyListAdapter = new NearbyListAdapter((Context)AMapLocationActivity2D.this, mapNearbyInfos);
                        AMapLocationActivity2D.this.listViewNearby.setAdapter((ListAdapter)AMapLocationActivity2D.this.nearbyListAdapter);
                        AMapLocationActivity2D.this.listViewNearby.setVisibility(0);
                        AMapLocationActivity2D.this.listLoadingView.setVisibility(8);
                    }
                }

                public void onPoiItemSearched(PoiItem poiItem, int i) {
                }
            });
            poiSearch.searchPOIAsyn();
        } else {
            this.listViewNearby.setVisibility(0);
            this.listLoadingView.setVisibility(8);
            Toast.makeText((Context)this, (CharSequence)this.getResources().getString(R.string.rc_location_fail), (int)0).show();
        }
    }

    private void loadNextPageNearByView() {
        PoiSearch.Query query = new PoiSearch.Query("", "\u6c7d\u8f66\u670d\u52a1|\u6c7d\u8f66\u9500\u552e|\u6c7d\u8f66\u7ef4\u4fee|\u6469\u6258\u8f66\u670d\u52a1|\u9910\u996e\u670d\u52a1|\u8d2d\u7269\u670d\u52a1|\u751f\u6d3b\u670d\u52a1|\u4f53\u80b2\u4f11\u95f2\u670d\u52a1|\u533b\u7597\u4fdd\u5065\u670d\u52a1|\u4f4f\u5bbf\u670d\u52a1|\u98ce\u666f\u540d\u80dc|\u5546\u52a1\u4f4f\u5b85|\u653f\u5e9c\u673a\u6784\u53ca\u793e\u4f1a\u56e2\u4f53|\u79d1\u6559\u6587\u5316\u670d\u52a1|\u4ea4\u901a\u8bbe\u65bd\u670d\u52a1|\u91d1\u878d\u4fdd\u9669\u670d\u52a1|\u516c\u53f8\u4f01\u4e1a|\u9053\u8def\u9644\u5c5e\u8bbe\u65bd|\u5730\u540d\u5730\u5740\u4fe1\u606f|\u516c\u5171\u8bbe\u65bd", "");
        query.setPageSize(20);
        query.setPageNum(++this.currentPage);
        PoiSearch poiSearch = new PoiSearch((Context)this, query);
        double longitude = this.mLngResult;
        double latitude = this.mLatResult;
        if (latitude != 0.0 && longitude != 0.0) {
            poiSearch.setBound(new PoiSearch.SearchBound(new LatLonPoint(latitude, longitude), 6000));
            poiSearch.setOnPoiSearchListener(new PoiSearch.OnPoiSearchListener(){

                public void onPoiSearched(PoiResult poiResult, int i) {
                    if (poiResult != null && poiResult.getPois().size() > 0) {
                        ArrayList<MapNearbyInfo> mapNearbyInfos = new ArrayList<MapNearbyInfo>();
                        ArrayList poiItemList = poiResult.getPois();
                        for (int j = 0; j < poiItemList.size(); ++j) {
                            PoiItem poiItem = (PoiItem)poiItemList.get(j);
                            MapNearbyInfo nearbyInfo = new MapNearbyInfo(poiItem.getTitle(), poiItem.getSnippet());
                            nearbyInfo.setLongitude(poiItem.getLatLonPoint().getLongitude());
                            nearbyInfo.setLatitude(poiItem.getLatLonPoint().getLatitude());
                            nearbyInfo.setPoi(poiItem.getTitle());
                            mapNearbyInfos.add(nearbyInfo);
                        }
                        AMapLocationActivity2D.this.nearbyListAdapter.addItems(mapNearbyInfos);
                        AMapLocationActivity2D.this.nearbyListAdapter.notifyDataSetChanged();
                    }
                }

                public void onPoiItemSearched(PoiItem poiItem, int i) {
                }
            });
            poiSearch.searchPOIAsyn();
        } else {
            Toast.makeText((Context)this, (CharSequence)this.getResources().getString(R.string.rc_location_fail), (int)0).show();
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.rc_ext_my_location) {
            this.handleMyLocation();
        } else if (v.getId() == R.id.rc_action_bar_ok) {
            this.handleOkButton();
        } else if (v.getId() == R.id.rc_search) {
            Intent intent = new Intent((Context)this, SearchLocationActivity.class);
            intent.putExtra("city code", this.cityCode);
            this.startActivityForResult(intent, 1);
        }
    }

    private void handleMyLocation() {
        if (this.mMyPoi != null) {
            this.mAMap.setOnCameraChangeListener(null);
            CameraUpdate update = CameraUpdateFactory.changeLatLng((LatLng)new LatLng(this.mMyLat, this.mMyLng));
            this.mAMap.animateCamera(update, new AMap.CancelableCallback(){

                public void onFinish() {
                    AMapLocationActivity2D.this.mAMap.setOnCameraChangeListener((AMap.OnCameraChangeListener)AMapLocationActivity2D.this);
                }

                public void onCancel() {
                }
            });
            this.mLocationTip.setText((CharSequence)this.mMyPoi);
            this.mLatResult = this.mMyLat;
            this.mLngResult = this.mMyLng;
            this.mPoiResult = this.mMyPoi;
            LatLng latLng = new LatLng(this.mLatResult, this.mLngResult);
            this.updateNearByView(this.mMyPoi);
            if (this.mMarker != null) {
                this.mMarker.setPosition(latLng);
            }
        } else {
            LocationManager2D.getInstance().updateMyLocation();
        }
    }

    private void handleOkButton() {
        if (this.mLatResult == 0.0 && this.mLngResult == 0.0 && TextUtils.isEmpty((CharSequence)this.mPoiResult)) {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.rc_location_temp_failed), (int)0).show();
            return;
        }
        Intent intent = new Intent();
        intent.putExtra("thumb", this.getMapUrl(this.mLatResult, this.mLngResult));
        intent.putExtra("lat", this.mLatResult);
        intent.putExtra("lng", this.mLngResult);
        intent.putExtra("poi", this.mPoiResult);
        this.setResult(-1, intent);
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1 && data != null) {
            this.mLngResult = data.getDoubleExtra("longitude", 0.0);
            this.mLatResult = data.getDoubleExtra("latitude", 0.0);
            this.mPoiResult = data.getStringExtra("poi");
            this.resetViewHeight();
            this.updateToPosition(this.mLngResult, this.mLatResult, this.mPoiResult, true);
        }
    }

    private void resetViewHeight() {
        if (this.listViewNearby != null) {
            int minHeight = (int)this.getResources().getDimension(R.dimen.rc_ext_location_nearby_list_min_height);
            ViewGroup.LayoutParams layoutParams = this.listViewNearby.getLayoutParams();
            layoutParams.height = minHeight;
            this.listViewNearby.setLayoutParams(layoutParams);
        }
        final FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mLocationTip.getLayoutParams();
        int marginTop = RongUtils.dip2px(20.0f);
        int marginLeft = RongUtils.dip2px(20.0f);
        int marginRight = RongUtils.dip2px(20.0f);
        params.setMargins(marginLeft, marginTop, marginRight, 0);
        this.mLocationTip.post(new Runnable(){

            @Override
            public void run() {
                AMapLocationActivity2D.this.mLocationTip.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        });
    }

    private void updateToPosition(double longitude, double latitude, String poi, boolean updateNearby) {
        if (poi != null) {
            this.mLatResult = latitude;
            this.mLngResult = longitude;
            this.mPoiResult = poi;
            this.mLocationTip.setText((CharSequence)this.mPoiResult);
            if (updateNearby) {
                this.updateNearByView(this.mPoiResult);
            }
            final LatLng latLng = new LatLng(this.mLatResult, this.mLngResult);
            CameraUpdate update = CameraUpdateFactory.changeLatLng((LatLng)latLng);
            this.mAMap.setOnCameraChangeListener(null);
            this.mAMap.animateCamera(update, new AMap.CancelableCallback(){

                public void onFinish() {
                    AMapLocationActivity2D.this.mAMap.setOnCameraChangeListener((AMap.OnCameraChangeListener)AMapLocationActivity2D.this);
                    if (AMapLocationActivity2D.this.mMarker != null) {
                        AMapLocationActivity2D.this.mMarker.setPosition(latLng);
                    }
                }

                public void onCancel() {
                }
            });
        }
    }

    private void updateCheckedMapView(double longitude, double latitude, String poi) {
        this.updateToPosition(longitude, latitude, poi, false);
    }

    private static enum ScrollDirection {
        SCROLL_UP,
        SCROLL_DOWN;

    }

    private class MapNearbyInfo {
        String name;
        String address;
        double latitude;
        double longitude;
        String poi;
        boolean checked;

        public MapNearbyInfo() {
        }

        public MapNearbyInfo(String name, String address) {
            this.name = name;
            this.address = address;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public String getAddress() {
            return this.address;
        }

        public double getLongitude() {
            return this.longitude;
        }

        public void setLongitude(double longitude) {
            this.longitude = longitude;
        }

        public double getLatitude() {
            return this.latitude;
        }

        public void setLatitude(double latitude) {
            this.latitude = latitude;
        }

        public String getPoi() {
            return this.poi;
        }

        public void setPoi(String poi) {
            this.poi = poi;
        }

        public void setChecked(boolean checked) {
            this.checked = checked;
        }

        public boolean getChecked() {
            return this.checked;
        }
    }

    private class NearbyListAdapter
    extends BaseAdapter {
        List<MapNearbyInfo> nearbyInfoList;
        Context context;

        public NearbyListAdapter(Context context, List<MapNearbyInfo> nearbyInfoList) {
            this.context = context;
            this.nearbyInfoList = nearbyInfoList;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            NearbyViewHolder nearbyViewHolder;
            MapNearbyInfo mapNearbyInfo = this.nearbyInfoList.get(position);
            if (convertView == null) {
                nearbyViewHolder = new NearbyViewHolder();
                convertView = View.inflate((Context)this.context, (int)R.layout.rc_map_nearby_info_item, null);
                nearbyViewHolder.tvNearbyName = (TextView)convertView.findViewById(R.id.rc_nearby_name);
                nearbyViewHolder.tvNearbyAddress = (TextView)convertView.findViewById(R.id.rc_nearby_address);
                nearbyViewHolder.ivNearbyChecked = (ImageView)convertView.findViewById(R.id.rc_nearby_checked);
                convertView.setTag((Object)nearbyViewHolder);
            } else {
                nearbyViewHolder = (NearbyViewHolder)convertView.getTag();
            }
            if (position == 0) {
                nearbyViewHolder.tvNearbyAddress.setVisibility(8);
                nearbyViewHolder.tvNearbyName.setText((CharSequence)mapNearbyInfo.getName());
            } else {
                nearbyViewHolder.tvNearbyAddress.setVisibility(0);
                nearbyViewHolder.tvNearbyName.setText((CharSequence)mapNearbyInfo.getName());
                nearbyViewHolder.tvNearbyAddress.setText((CharSequence)mapNearbyInfo.getAddress());
            }
            if (mapNearbyInfo.getChecked()) {
                nearbyViewHolder.ivNearbyChecked.setVisibility(0);
            } else {
                nearbyViewHolder.ivNearbyChecked.setVisibility(8);
            }
            return convertView;
        }

        public Object getItem(int position) {
            if (this.nearbyInfoList != null && this.nearbyInfoList.size() > 0) {
                return this.nearbyInfoList.get(position);
            }
            return null;
        }

        public long getItemId(int position) {
            return position;
        }

        public int getCount() {
            return this.nearbyInfoList.size();
        }

        public void addItems(List<MapNearbyInfo> nearbyInfoList) {
            if (this.nearbyInfoList != null) {
                this.nearbyInfoList.addAll(nearbyInfoList);
            }
        }

        class NearbyViewHolder {
            TextView tvNearbyName;
            TextView tvNearbyAddress;
            ImageView ivNearbyChecked;

            NearbyViewHolder() {
            }
        }
    }
}

